#if( ! require( 'R.utils' , character.only = TRUE ) ){
#      #  If package was not able to be loaded then re-install
#      install.packages( 'R.utils' , dependencies = TRUE, repos = "http://cran.us.r-project.org" )
#      #  Load package after installing
#      require( 'R.utils' , character.only = TRUE )
#    }

#library.path <- .libPaths()
#print(library.path)
#library("R.utils", lib.loc = library.path)



library(R.utils)

source("0_master_execution_function.R")
args = commandArgs(asValue=TRUE)
keys <- attachLocally(args)

if (dependent_allow != "0") {
    dependent_allow <- as.numeric(strsplit(dependent_allow, ",")[[1]])
} else {
	dependent_allow <- 0
}
if (formula_value_cuts != "NULL") {
    formula_value_cuts <- as.numeric(strsplit(formula_value_cuts, ",")[[1]])
} else {
	formula_value_cuts <- NULL
}
if (formula_bene_levels != "NULL") {
    formula_bene_levels <- as.numeric(strsplit(formula_bene_levels, ",")[[1]])
} else {
	formula_bene_levels <- NULL
}
if (base_bene_level == "NULL") {
	base_bene_level = NULL
} else {
	base_bene_level = as.numeric(base_bene_level)
}

d <- policy_simulation(
	acs_dir=acs_dir,
	fmla_file=fmla_file,
	fmla_year=as.numeric(fmla_year),
	acs_year=as.numeric(acs_year),
	saveCSV=TRUE,
	FEDGOV=as.logical(FEDGOV),
	STATEGOV=as.logical(STATEGOV),
	LOCALGOV=as.logical(LOCALGOV),
	base_bene_level=base_bene_level,
	impute_method=gsub('_', ' ', impute_method),
	makelog = TRUE,
	state=state,
	SELFEMP=as.logical(SELFEMP),
	place_of_work=as.logical(place_of_work),
	clone_factor=as.numeric(clone_factor),
	week_bene_cap=as.numeric(week_bene_cap),
	own_uptake=as.numeric(own_uptake),
	matdis_uptake=as.numeric(matdis_uptake),
	bond_uptake=as.numeric(bond_uptake),
	illparent_uptake=as.numeric(illparent_uptake),
	illspouse_uptake=as.numeric(illspouse_uptake),
	illchild_uptake=as.numeric(illchild_uptake),
	maxlen_own=as.numeric(maxlen_own),
	maxlen_matdis=as.numeric(maxlen_matdis),
	maxlen_bond=as.numeric(maxlen_bond),
	maxlen_illparent=as.numeric(maxlen_illparent),
	maxlen_illspouse=as.numeric(maxlen_illspouse),
	maxlen_illchild=as.numeric(maxlen_illchild),
	maxlen_total=as.numeric(maxlen_total),
	maxlen_PFL=as.numeric(maxlen_PFL),
	maxlen_DI=as.numeric(maxlen_DI),
	earnings=as.numeric(earnings),
	weeks=as.numeric(weeks),
	ann_hours=as.numeric(ann_hours),
	minsize=as.numeric(minsize),
	random_seed=as.numeric(random_seed),
	progress_file=progress_file,
	log_directory=log_directory,
	out_dir=out_dir,
	kval=5,
	alpha=as.numeric(alpha),
	wait_period=as.numeric(wait_period),
	wait_period_recollect=as.logical(wait_period_recollect),
	min_cfl_recollect=as.numeric(min_cfl_recollect),
	dual_receiver=as.numeric(dual_receiver),
	min_takeup_cpl=as.numeric(min_takeup_cpl),
	model_start_time=model_start_time,
	ABF_enabled=FALSE,
	dependent_allow=dependent_allow,
	formula_value_cuts=formula_value_cuts,
	formula_bene_levels=formula_bene_levels,
	se_report=as.logical(se_report),
)
