log using "c:\temp\acs_comp3.log", replace text 

***********************************************
*** Read the Raw Person U.S. Dataset from 2020 
***********************************************
clear

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pusa.csv", clear
save "c:\temp\psam_pusa.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pusb.csv", clear
save "c:\temp\psam_pusb.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pusc.csv", clear
save "c:\temp\psam_pusc.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pusd.csv", clear

append using "c:\temp\psam_pusa.dta"
append using "c:\temp\psam_pusb.dta"
append using "c:\temp\psam_pusc.dta"

***Get the dataset down as small as possible
compress

***Sort so it is easy to merge with the household data
sort serialno sporder

save "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", replace


*******************************
*** Feds, Person **************
*******************************
use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear

***Keep ages 16+ and COW of 5 (feds)
keep if age>=16 & age!=. & cow == 5

export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\person_files\gov_workers_us_person_2020_fed.csv", replace

**********************************
*** All government, Person *******
**********************************
use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear

***Keep ages 16+ and COW of 3-5 (they are government workers)
keep if age>=16 & age!=. & inlist(cow,3,4,5)

export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\person_files\gov_workers_us_person_2020_fed_state_local.csv", replace


**********************************************************
*** Check that the Person-Level State Files are the Same
**********************************************************
***Generate the state/person level files
local stpost AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY
local stfips 01 02 04 05 06 08 09 10 11 12 13 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 44 45 46 47 48 49 50 51 53 54 55 56

local snum : word count `stpost'

forvalues i = 1/`snum' {

	local stp = "`:word `i' of `stpost''"
	local stf = "`:word `i' of `stfips''"
	
	*display "`stp'"
	*display "`stf'"

	use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear
	
    ***Keep ages 16+ and COW of 1-7 (they are working)
    keep if age>=16 & age!=. & inlist(cow,1,2,3,4,5,6,7) & powsp==`stf'

    ***Drop any NAICS codes that indicate military for the state-level place of work datasets
    drop if naicsp == "928110P1" | naicsp == "928110P2" | naicsp == "928110P3" | naicsp == "928110P4" | naicsp == "928110P5" | naicsp == "928110P6" | naicsp == "928110P7"

	export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\pow_person_files\p`stf'_`stp'_pow.csv", replace
}


***************************************************
*** Read the Raw Household U.S. Dataset from 2020 
***************************************************
clear

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_husa.csv", clear
save "c:\temp\psam_husa.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_husb.csv", clear
save "c:\temp\psam_husb.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_husc.csv", clear
save "c:\temp\psam_husc.dta", replace

import delimited "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_husd.csv", clear

append using "c:\temp\psam_husa.dta"
append using "c:\temp\psam_husb.dta"
append using "c:\temp\psam_husc.dta"

***Get the dataset down as small as possible
compress

***Sort so it is easy to merge with the person-level data
sort serialno

save "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta", replace

****************************************************************
*** Household-Level State Files Derived from Person-Level Files
***************************^^^^^^*******************************

***Feds, household
import delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\person_files\gov_workers_us_person_2020_fed.csv", clear
	
keep serialno
sort serialno
by serialno: keep if _n==1

merge 1:1 serialno using "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta"

keep if _merge == 3

drop _merge

export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\household_files\gov_workers_us_household_2020_fed.csv", replace

***Government workers, household
import delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\person_files\gov_workers_us_person_2020_fed_state_local.csv", clear
	
keep serialno
sort serialno
by serialno: keep if _n==1

merge 1:1 serialno using "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta"

keep if _merge == 3

drop _merge

export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\household_files\gov_workers_us_household_2020_fed_state_local.csv", replace



***Generate the state/household level files
local stpost AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY
local stfips 01 02 04 05 06 08 09 10 11 12 13 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 44 45 46 47 48 49 50 51 53 54 55 56


local snum : word count `stpost'

forvalues i = 1/`snum' {

	local stp = "`:word `i' of `stpost''"
	local stf = "`:word `i' of `stfips''"

	import delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\pow_person_files\p`stf'_`stp'_pow.csv", clear
	
	keep serialno
	sort serialno
	by serialno: keep if _n==1
	
	merge 1:1 serialno using "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta"
	
	keep if _merge == 3

	drop _merge

	export delimited using "C:\Ryan\DOL\microsim\Microsim_dev\data\acs\2020\pow_household_files\h`stf'_`stp'_pow.csv", replace
}


************************************************************
*** State-by-State Person-Level Files
************************************************************
***Generate the state/person level files
local stpost AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY
local stfips 01 02 04 05 06 08 09 10 11 12 13 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 44 45 46 47 48 49 50 51 53 54 55 56

local snum : word count `stpost'

forvalues i = 1/`snum' {

	local stp = "`:word `i' of `stpost''"
	local stf = "`:word `i' of `stfips''"
	
	*display "`stp'"
	*display "`stf'"

	use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear
	
    ***Keep ages 16+ and COW of 1-7 (they are working)
    *keep if age>=16 & age!=. & inlist(cow,1,2,3,4,5,6,7) & powsp==`stf'

    ***Drop any NAICS codes that indicate military for the state-level place of work datasets
    *drop if naicsp == "928110P1" | naicsp == "928110P2" | naicsp == "928110P3" | naicsp == "928110P4" | naicsp == "928110P5" | naicsp == "928110P6" | naicsp == "928110P7"
	
	keep if st==`stf'

	export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\person_files\ss20p`stp'.csv", replace
	
	use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta", clear
	
	keep if st==`stf'
	
	export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\household_files\ss20h`stp'.csv", replace

}


*******************************
*** Feds, Person and HH *******
*******************************
use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear

***Keep COW of 5 (feds)
keep if cow == 5

export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\person_files\gov_workers_us_person_2020_fed.csv", replace

keep serialno
sort serialno
by serialno: keep if _n==1

merge 1:1 serialno using "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta"

keep if _merge == 3

drop _merge

export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\household_files\gov_workers_us_household_2020_fed.csv", replace

**********************************
*** All government, Person *******
**********************************
use "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_pus.dta", clear

***Keep ages 16+ and COW of 3-5 (they are government workers)
keep if inlist(cow,3,4,5)

export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\person_files\gov_workers_us_person_2020_fed_state_local.csv", replace

keep serialno
sort serialno
by serialno: keep if _n==1

merge 1:1 serialno using "C:\Ryan\DOL\microsim\Data\raw\acs\2020\psam_hus.dta"

keep if _merge == 3

drop _merge

export delimited using "C:\Ryan\DOL\microsim\Data\final\acs\2020\household_files\gov_workers_us_household_2020_fed_state_local.csv", replace

log close