#' ---
#' title: "DOL-ILAB SDC - Nepal_HT_Study_round1_2_3_v1"
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "Nepal_HT_Study_round1_2_3_v1" # !!!Update filename
functions_vers <-  "functions_1.6.R" # !!!Update helper functions file

#' #Setup and crate dictionary
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Location: Small Location (<100,000) Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .xlsx format and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII

#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
#' !!!Replace vector in "variables" field below with relevant variable names

# Encode Direct PII-team

mydata <- encode_direct_PII_team (variables="Srvyr")

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("VDC", "ward") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

break_age <- c(0, 15,25,35,45,55,100)
labels_age <- c("Less than 15" =1, 
                "15-24" =2, 
                "25-34" =3, 
                "35-44" =4, 
                "45-54" =5, 
                "55 and older" =6, 
                "NA" = 7)
mydata <- ordinal_recode (variable="D_2", break_points=break_age, missing=999999, value_labels=labels_age)


break_age <- c(15,25,35,45,55,65,100)
labels_age <- c("15-24" =1, 
                "25-34" =2, 
                "35-44" =3, 
                "45-54" =4, 
                "55-64" =5, 
                "65 and older" =6, 
                "NA" = 7)
mydata <- ordinal_recode (variable="IDR3_20", break_points=break_age, missing=999999, value_labels=labels_age)

# !!!Include relevant variables in list below

indirect_PII <- c("D_1",
                  "D_3",
                  "D_4",
                  "D_6",
                  "D_9",
                  "D_20",
                  "Inc_17",
                  "Inc_23",
                  "EM_16_1",
                  "EM_16_2",
                  "EM_16_3",
                  "EM_16_6",
                  "CM_1C",
                  "CM_2",
                  "CM_29",
                  "CL_2b_TEXT",
                  "ME_1",
                  "ME_3",
                  "ME_5",
                  "ME_7",
                  "ME_13",
                  "ME_14",
                  "ME_16",
                  "child_int",
                  "working_child",
                  "hcl_self",
                  "fl_adult_self",
                  "fl_child_self",
                  "wfcl_self",
                  "clabor",
                  "CAHR_u3",
                  "CAHR_unicef",
                  "working_child_rc1",
                  "working_child_rc2",
                  "working_child_rc3",
                  "working_child_rc4",
                  "working_child_rc5",
                  "working_child_rc6",
                  "hcl_rc1",
                  "hcl_rc2",
                  "hcl_rc3",
                  "fl_rc1",
                  "fl_rc2",
                  "fl_rc3",
                  "fl_rc4",
                  "fl_rc5",
                  "fl_rc6",
                  "wfcl_rc1",
                  "wfcl_rc2",
                  "wfcl_rc3",
                  "wfcl_rc4",
                  "wfcl_rc5",
                  "wfcl_rc6",
                  "clabor_rc1",
                  "clabor_rc2",
                  "clabor_rc3",
                  "CAHR_u1_rc1",
                  "CAHR_u2_rc1",
                  "CAHR_u3_rc1",
                  "CAHR_unicef_rc1",
                  "CAHR_u1_rc2",
                  "CAHR_u2_rc2",
                  "CAHR_u3_rc2",
                  "CAHR_unicef_rc2",
                  "CAHR_u1_rc3",
                  "CAHR_u2_rc3",
                  "CAHR_u3_rc3",
                  "CAHR_unicef_rc3",
                  "CAHR_u1_rc4",
                  "CAHR_u2_rc4",
                  "CAHR_u3_rc4",
                  "CAHR_unicef_rc4",
                  "CAHR_u1_rc5",
                  "CAHR_u2_rc5",
                  "CAHR_u3_rc5",
                  "CAHR_unicef_rc5",
                  "CAHR_u1_rc6",
                  "CAHR_u3_rc6",
                  "CAHR_unicef_rc6",
                  "allchild_int_hh",
                  "allworking_child_hh",
                  "allclabor_hh",
                  "allhcl_hh",
                  "allwfcl_hh",
                  "allfl_child_hh",
                  "allCAHR_u1_hh",
                  "allCAHR_u2_hh",
                  "allCAHR_u3_hh",
                  "allCAHR_unicef_hh",
                  "working_child_rcnum",
                  "clabor_rcnum",
                  "hcl_rcnum",
                  "wfcl_rcnum",
                  "fl_rcnum",
                  "CAHR_u1_rcnum",
                  "CAHR_u2_rcnum",
                  "CAHR_u3_rcnum",
                  "CAHR_unicef_rcnum")

capture_tables (indirect_PII)

# Recode education into standard categories

break_edu <- c(0,6,9,11,12,13,17,18, 777, 888, 999)
labels_edu <- c("Primary or less (0-5)" = 1,
                "Lower secondary (6-8)" = 2,
                "Secondary (9-10)" = 3,
                "SLC (11)" = 4,
                "CLASS 12/Intermediate level (12)" = 5,
                "Bachelor/Postgraduate level" = 6,
                "Literate, but never attended school" = 7,
                "Illiterate, and never attended school"= 8,
                "Refused"= 9, 
                "Does not apply" = 10, 
                "Don't Know" = 11)
mydata <- ordinal_recode (variable="D_4", break_points=break_edu, missing=999, value_labels=labels_edu)

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("D_20", break_point=5, missing=c(888, 999999)) # Topcode cases with 5 or more children

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(mydata$Inc_17[mydata$Inc_17!=999999], probs = c(0.995)))
mydata <- top_recode (variable="Inc_17", break_point=percentile_99.5, missing=999999) 

percentile_99.5 <- floor(quantile(mydata$Inc_23[mydata$Inc_23!=999999], probs = c(0.995)))
mydata <- top_recode (variable="Inc_23", break_point=percentile_99.5, missing=999999)

# Encode caste

mydata <- encode_location (variables= "D_3", missing=999999)

# Recode religion

break_rel <- c(1,2,3, 777, 888, 999)
labels_rel <- c("Hindu" = 1,
                "Buddhist" = 2,
                "Other" = 3,
                "Refused" = 4,
                "Not applicable" = 5,
                "Don't know" = 6)
mydata <- ordinal_recode (variable="D_6", break_points=break_rel, missing=999, value_labels=labels_rel)

# Recode reason for moving

break_mov <- c(1,2,3, 4, 777, 888, 999)
labels_mov <- c("Family reasons (e.g., marriage)" = 1,
                "For education / training" = 2,
                "For work" = 3,
                "Other" = 4,
                "Refused to asnwer" = 5,
                "Not applicable" = 6,
                "Don't know" = 7)
mydata <- ordinal_recode (variable="CM_2", break_points=break_mov, missing=999, value_labels=labels_mov)

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('D_2', 'D_1', 'D_4') ##!!! Replace with candidate categorical demo vars

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial
#' 0 cases violate 2-anonimty, no need for local supressions.

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("HTV_1_10_TEXT",
               "HTV_3_11_TEXTx3",
               "HTV_3_11_TEXTx3_Translation")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% "HTV_1_10_TEXT"] # Drop as verbatim data in Nepali.
mydata <- mydata[!names(mydata) %in% "HTV_3_11_TEXTx3"] # Drop as verbatim data in Nepali.

#' #GPS data: Displace
#' !!!No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

