#' ---
#' title: "DOL-ILAB SDC - Round_1_temp"
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup and crate dictionary

filename <- "Round_1_temp" # !!!Update filename
source ("functions_1.6.R")

#mydata <- mydata [1:10,] # remove '#' from #mydata if you want to conduct a fast check on 10 rows. 

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .xlsx format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII

#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
#' !!!No Direct PII - team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

mydata <- encode_location (variables= "VDC", missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

break_age <- c(0, 15,25,35,45,55,100)
labels_age <- c("Less than 15" =1, 
                "15-24" =2, 
                "25-34" =3, 
                "35-44" =4, 
                "45-54" =5, 
                "55 and older" =6, 
                "NA" = 7)
mydata <- ordinal_recode (variable="D_2", break_points=break_age, missing=999999, value_labels=labels_age)

# Recode education into standard categories

break_edu <- c(0,6,9,11,12,13,17,18, 777, 888, 999)
labels_edu <- c("Primary or less (0-5)" = 1,
                "Lower secondary (6-8)" = 2,
                "Secondary (9-10)" = 3,
                "SLC (11)" = 4,
                "CLASS 12/Intermediate level (12)" = 5,
                "Bachelor/Postgraduate level" = 6,
                "Literate, but never attended school" = 7,
                "Illiterate, and never attended school"= 8,
                "Refused"= 9, 
                "Does not apply" = 10, 
                "Don't Know" = 11)
mydata <- ordinal_recode (variable="D_4", break_points=break_edu, missing=999, value_labels=labels_edu)

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("D_20", break_point=5, missing=c(888, 999999)) # Topcode cases with 5 or more children

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(mydata$Inc_17[mydata$Inc_17!=999999], probs = c(0.995)))
mydata <- top_recode (variable="Inc_17", break_point=percentile_99.5, missing=999999)

percentile_99.5 <- floor(quantile(mydata$Inc_23[mydata$Inc_23!=999999], probs = c(0.995)))
mydata <- top_recode (variable="Inc_23", break_point=percentile_99.5, missing=999999)

#' #Indirect PII - Categorical: 
# !!!Include relevant variables in list below

indirect_PII <- c("D_3",
                  "D_4",
                  "D_6",
                  "D_9",
                  "EM_16_1",
                  "EM_16_2",
                  "EM_16_3",
                  "EM_16_6",
                  "CM_1C",
                  "CM_2",
                  "ME_1",
                  "ME_3",
                  "ME_5",
                  "ME_7",
                  "ME_13",
                  "ME_14",
                  "ME_16")

capture_tables (indirect_PII)

# Encode caste

mydata <- encode_location (variables= "D_3", missing=999999)

# Recode religion

break_rel <- c(1,2,3, 777, 888, 999)
labels_rel <- c("Hindu" = 1,
                "Buddhist" = 2,
                "Other" = 3,
                "Refused" = 4,
                "Not applicable" = 5,
                "Don't know" = 6)
mydata <- ordinal_recode (variable="D_6", break_points=break_rel, missing=999, value_labels=labels_rel)

# Recode reason for moving

break_mov <- c(1,2,3, 4, 777, 888, 999)
labels_mov <- c("Family reasons (e.g., marriage)" = 1,
                "For education / training" = 2,
                "For work" = 3,
                "Other" = 4,
                "Refused to asnwer" = 5,
                "Not applicable" = 6,
                "Don't know" = 7)
mydata <- ordinal_recode (variable="CM_2", break_points=break_mov, missing=999, value_labels=labels_mov)

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age

selectedKeyVars = c('D_1','D_2','D_4') ##!!! Replace with candidate categorical demo vars
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
#mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"D_4"] <- 9

#' #Open-ends: review responses for any sensitive information, redact as necessary

report_open (list_open_ends = "HTV_1_10_TEXT")

# Remove as only verbatim variable in Nepali

mydata <- mydata[!names(mydata) %in% "HTV_1_10_TEXT"] # Drop as actually verbatim data in Nepali

#' #GPS data: Displace
# !!!No GPS

#' #Save processed data in Stata and SPSS format
# Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))