#' ---
#' title: "DOL-ILAB SDC - Nepal_HT_Study_Round2_062316"
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup and crate dictionary
#' Start Rstudio by double-clicking on "PII_remover_1.5.R"
#' Make sure the following files are in the same folder: 
#' "PII_remover_1.5.R"
#' "functions_1.5.R"
#' Dataset to be processed (e.g. "Nepal Round 3_FinalClean.dta")

filename <- "Nepal_HT_Study_Round2_062316" # !!!Update filename
source ("functions_1.5.R")

#mydata <- mydata [1:10,] # remove '#' from #mydata if you want to conduct a fast check on 10 rows. 

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .xlsx format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII

#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
#' !!!No Direct PII-team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("VDC", "ID_4") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!! No indirect PII - Ordinal

#' #Indirect PII - Categorical
# !!! No indirect PII - Categorical

#' #Matching and crosstabulations: Run automated PII check 
# !!! No indirect or direct PII

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No open-ends

#' #GPS data: Displace
# !!! No GPS

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

