#' ---
#' title: "DOL-ILAB SDC - Nepal_HT_Study_Rounds_1_2_3_Processed"
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "Nepal_HT_Study_Rounds_1_2_3_Processed" # !!!Update filename
functions_vers <-  "functions_1.6.R" # !!!Update helper functions file

#' #Setup and crate dictionary
source (functions_vers)
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Location: Small Location (<100,000) Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .xlsx format and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No direct PII

#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
#' !!!Replace vector in "variables" field below with relevant variable names

# Encode Direct PII-team

mydata <- encode_direct_PII_team (variables=c("Srvyr"))

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("dist_vdc", "ward") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

break_age <- c(0, 15,25,35,45,55,100)
labels_age <- c("Less than 15" =1, 
                "15-24" =2, 
                "25-34" =3, 
                "35-44" =4, 
                "45-54" =5, 
                "55 and older" =6, 
                "NA" = 7)
mydata <- ordinal_recode (variable="age", break_points=break_age, missing=999999, value_labels=labels_age)
mydata <- ordinal_recode (variable="ager", break_points=break_age, missing=999999, value_labels=labels_age)

break_age <- c(15,25,35,45,55,65,100)
labels_age <- c("15-24" =1, 
                "25-34" =2, 
                "35-44" =3, 
                "45-54" =4, 
                "55-64" =5, 
                "65 and older" =6, 
                "NA" = 7)
mydata <- ordinal_recode (variable="IDR3_20", break_points=break_age, missing=999999, value_labels=labels_age)

# Remove variables derivedfrom ordinal variables that have been recoded

remove_ordinals <- c("age2", "ln_hhincome", "ln_exp")
mydata <- mydata[!names(mydata) %in% remove_ordinals]

# !!!Include relevant variables in list below

indirect_PII <- c("d6",
                  "d9",
                  "inc17",
                  "inc23",
                  "em16_2",
                  "cm29",
                  "me3",
                  "me5",
                  "me13",
                  "me14",
                  "ME_16",
                  "edu2",
                  "ageg",
                  "ageg2",
                  "incomecat",
                  "inc16r",
                  "d6r",
                  "ethnic",
                  "caste",
                  "me3r",
                  "me14r",
                  "me5r",
                  "me7r",
                  "ethnicity",
                  "education",
                  "childnum")

capture_tables (indirect_PII)

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("childnum", break_point=5, missing=c(888, 999999)) # Topcode cases with 5 or more children
mydata <- top_recode ("d20", break_point=5, missing=c(888, 999999)) # Topcode cases with 5 or more children

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(mydata$inc17[mydata$inc17!=999999], probs = c(0.995)))
mydata <- top_recode (variable="inc17", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(mydata$inc23[mydata$inc23!=999999], probs = c(0.995)))
mydata <- top_recode (variable="inc23", break_point=percentile_99.5, missing=999999)

# Encode caste

mydata <- encode_location (variables= "D_3", missing=999999)
# Recode religion

break_rel <- c(1,2,3, 777, 888, 999)
labels_rel <- c("Hindu" = 1,
                "Buddhist" = 2,
                "Other" = 3,
                "Refused" = 4,
                "Not applicable" = 5,
                "Don't know" = 6)
mydata <- ordinal_recode (variable="d6", break_points=break_rel, missing=999, value_labels=labels_rel)

# Recode education into standard categories

break_edu <- c(0,6,9,11,12,13,17,18, 777, 888, 999)
labels_edu <- c("Primary or less (0-5)" = 1,
                "Lower secondary (6-8)" = 2,
                "Secondary (9-10)" = 3,
                "SLC (11)" = 4,
                "CLASS 12/Intermediate level (12)" = 5,
                "Bachelor/Postgraduate level" = 6,
                "Literate, but never attended school" = 7,
                "Illiterate, and never attended school"= 8,
                "Refused"= 9, 
                "Does not apply" = 10, 
                "Don't Know" = 11)
mydata <- ordinal_recode (variable="d4", break_points=break_edu, missing=999, value_labels=labels_edu)

# Recode into married vs "others"

break_mar <- c(1,2,1000)
labels_mar <- c("Married" =1, "Others" =2)
mydata <- ordinal_recode (variable="d9", break_points=break_mar, missing=999999, value_labels=labels_mar)

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c("D_1", "edu2", "age") ##!!! Replace with candidate categorical demo vars

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial # No cases violate 2-anonimity. 

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("HTV_1_10_TEXT", "HTV_3_11_TEXTx3", "HTV_3_11_TEXTx3_Translation")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% "HTV_1_10_TEXT"]
mydata <- mydata[!names(mydata) %in% "HTV_3_11_TEXTx3"]

#' #GPS data: Displace
# !!!No GPS data

#' #Drop duplicate variables to avoid problems when opening in SPSS

mydata <- mydata[!names(mydata) %in% "htv_1_1r"]

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

