#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "midline1" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#mydata <- mydata [1:10,] # remove '#' from #mydata if you want to conduct a fast check on 10 rows. 
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!!No Direct PII
#'
#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
# !!!No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("mid1_villagename", 
             "mid1_settlement",
             "mid1_municipality",
             "mid1_wardno", 
             "mid1_child_municipality", 
             "mid1_child_wardno", 
             "mid1_child_villagename", 
             "mid1_child_settlement") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

mydata <- top_recode ("mid1_s3q3", break_point=80, missing=999999) # Topcode cases age 80 or older
mydata <- top_recode ("mid1_s4q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("mid1_child_nhhmmbrs", break_point=10, missing=999999) # Topcode cases with 10 or more members
mydata <- top_recode ("mid1_s17q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("mid1_s4q8", break_point=60, missing=999999) # Topcode cases with 60 or longer

# !!!Include relevant variables in list below

indirect_PII <- c("mid1_occup0", 
                  "mid1_s5q6c", 
                  "mid1_occup1", 
                  "mid1_s19q4c", 
                  "mid1_ind0", 
                  "mid1_s5q6_2c", 
                  "mid1_ind1", 
                  "mid1_s19q4bc", 
                  "mid1_nhhmmbrs", 
                  "mid1_s11q7", 
                  "mid1_s3q4", 
                  "mid1_s3q7", 
                  "mid1_s3q8", 
                  "mid1_s3q9a", 
                  "mid1_s3q9d", 
                  "mid1_s4q1", 
                  "mid1_s4q2", 
                  "mid1_s4q4", 
                  "mid1_s4q6_8", 
                  "mid1_s4q6_96", 
                  "mid1_s4q9", 
                  "mid1_s4q9_5", 
                  "mid1_s4q9other", 
                  "mid1_s4q11", 
                  "mid1_s5q4b", 
                  "mid1_s5q4c", 
                  "mid1_s5q4d", 
                  "mid1_s5q4f", 
                  "mid1_s5q4g", 
                  "mid1_s5q4i", 
                  "mid1_s5q5", 
                  "mid1_s5q6a", 
                  "mid1_s5q11", 
                  "mid1_s5q16", 
                  "mid1_s5q18", 
                  "mid1_s6q2", 
                  "mid1_s6q7", 
                  "mid1_s6q8", 
                  "mid1_s17q6_8", 
                  "mid1_s17q6_96", 
                  "mid1_s17q8", 
                  "mid1_s17q8_5", 
                  "mid1_s17q9", 
                  "mid1_s19q2d", 
                  "mid1_s19q2e", 
                  "mid1_s19q2f", 
                  "mid1_s19q2h", 
                  "mid1_s19q2i", 
                  "mid1_s19q4a", 
                  "mid1_s19q10_6", 
                  "mid1_s19q10_12", 
                  "mid1_s19q12", 
                  "mid1_s19q13", 
                  "mid1_s19q14", 
                  "mid1_s20q2", 
                  "mid1_s20q5", 
                  "mid1_s20q7", 
                  "mid1_s20q8", 
                  "mid1_CLC5_11", 
                  "mid1_CLC12_13", 
                  "mid1_CLP5_11")

capture_tables (indirect_PII)

# Recode those with very specific values 
# Removed, as verbatim responses are partially or entirely in Nepali.

dropvars <- c("mid1_occup0", "mid1_occup1", "mid1_ind0", "mid1_ind1") 
mydata <- mydata[!names(mydata) %in% dropvars]  

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("mid1_nhhmmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members
mydata <- top_recode ("mid1_numhhmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
mydata$sex <- mydata$mid1_s3q2
mydata$sex [is.na(mydata$sex)] <- mydata$mid1_s3q2a[is.na(mydata$sex)]
selectedKeyVars = c('sex', 'mid1_s3q8', 'mid1_s3q3') ##!!! Replace with candidate categorical demo vars

# weight variable
# !!! No weight
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
selectedHouseholdID = c('hhid') 

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
as.data.frame(mydata[notAnon,selectedKeyVars])
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables (exclude children, as critical for analysis)

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon & mydata$mid1_s3q3 >17,"mid1_s3q3"] <- NA

#Check that 2-anonimity is now maintained

createSdcObj(dat = mydata, keyVars = selectedKeyVars, hhId = selectedHouseholdID)
mydata <- mydata[!names(mydata) %in% "sex"]  

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("mid1_s9q1_1other", 
               "mid1_s9q2_2other", 
               "mid1_s9q2_1other", 
               "mid1_s9q1_2other", 
               "mid1_s9q5other", 
               "mid1_s9q6other", 
               "mid1_s10q3other", 
               "mid1_s10q5other", 
               "mid1_s10q8other", 
               "mid1_s10q10other", 
               "mid1_s11q3other", 
               "mid1_s11q6other", 
               "mid1_s13q1other", 
               "mid1_s3q1other", 
               "mid1_s3q5other", 
               "mid1_s4q6other", 
               "mid1_s4q9other", 
               "mid1_s4q11other", 
               "mid1_s5q6", 
               "mid1_s5q6_2", 
               "mid1_s5q14other", 
               "mid1_s17q6other", 
               "mid1_s17q9other", 
               "mid1_s18q3other", 
               "mid1_s19q4", 
               "mid1_s19q4b")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% open_ends] # SDC risk could not be ascertained as all verbatims are partially or completely in Nepali.

#' #GPS data: Displace
# !!! No GPS data. 

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

#Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
