#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "baseline" # !!!Update filename
functions_vers <-  "functions_1.6.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#mydata <- mydata [1:10,] # remove '#' from #mydata if you want to conduct a fast check on 10 rows. 
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .xlsx format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII

#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
# !!!No Direct PII-team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("baseline_villagename", 
             "baseline_settlement",
             "baseline_municipality",
             "baseline_wardno", 
             "baseline_child_municipality",
             "baseline_child_wardno",
             "baseline_child_villagename",
             "baseline_child_settlement") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

mydata <- top_recode ("baseline_s3q3", break_point=80, missing=999999) # Topcode cases age 80 or older
mydata <- top_recode ("baseline_s4q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 

percentile_99.5 <- floor(quantile(mydata$baseline_s4q9, probs = c(0.995), na.rm=T))
mydata <- top_recode (variable="baseline_s4q9", break_point=percentile_99.5, missing=999999)

percentile_99.5 <- floor(quantile(mydata$baseline_s4q10, probs = c(0.995),na.rm=T))
mydata <- top_recode (variable="baseline_s4q10", break_point=percentile_99.5, missing=999999)

mydata <- top_recode ("baseline_child6", break_point=5, missing=999999) # Topcode cases with 5 or more 
mydata <- top_recode ("baseline_s17q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 

# !!!Include relevant variables in list below

indirect_PII <- c("baseline_s17q5",
                  "baseline_s17q6",
                  "baseline_s17q6_3",
                  "baseline_s17q6_4",
                  "baseline_s17q6_6",
                  "baseline_s17q6_7",
                  "baseline_s17q9",
                  "baseline_s18q1",
                  "baseline_s18q3",
                  "baseline_s19q2a",
                  "baseline_s19q2b",
                  "baseline_s19q2d",
                  "baseline_s19q2f",
                  "baseline_s19q2g",
                  "baseline_s19q3",
                  "baseline_s19q4a",
                  "baseline_s19q8",
                  "baseline_s19q9",
                  "baseline_s19q10",
                  "baseline_s19q10_4",
                  "baseline_s19q10_7",
                  "baseline_s19q10_8",
                  "baseline_s19q10_10",
                  "baseline_s19q10_11",
                  "baseline_s19q10_96",
                  "baseline_s19q10_99",
                  "baseline_s19q11",
                  "baseline_s20q3",
                  "baseline_s20q8",
                  "baseline_s5q6c",
                  "baseline_s19q4c",
                  "baseline_s5q6_2c",
                  "baseline_s19q4bc",
                  "baseline_s4q6_10",
                  "baseline_s17q6_10",
                  "baseline_ppi",
                  "baseline_madrassa",
                  "baseline_benboyt",
                  "baseline_bengirlt")
capture_tables (indirect_PII)

# Recode those with very specific values where more than half of the sample have actual data. 

break_rel <- c(1,2,3,4,999)
labels_rel <- c("Hindu" = 1,
                "Muslim" = 2,
                "Buddhist" = 3,
                "Other" = 4)
mydata <- ordinal_recode (variable="baseline_hhheadreligion", break_points=break_rel, missing=999999, value_labels=labels_rel)

break_lan <- c(1,2,3,4,5,6,7,8,999)
labels_lan <- c("Nepali" = 1,
                "Others" = 2,
                "Others" = 3,
                "Bhojpuri" = 4, 
                "Maithali" = 5, 
                "Tharu" = 6, 
                "Abadhi" = 7, 
                "Others" = 8)
mydata <- ordinal_recode (variable="baseline_hhheadmthrtongue", break_points=break_lan, missing=999999, value_labels=labels_lan)

mydata <- top_recode ("baseline_s3q0", break_point=15, missing=999999) # Topcode cases with 15 or more

# Group as "Others" labels with low frequencies

val_label(mydata$baseline_s4q11, 2) <- "Others"
val_label(mydata$baseline_s4q11, 3) <- "Others"
val_label(mydata$baseline_s4q11, 5) <- "Others"
val_label(mydata$baseline_s4q11, 6) <- "Others"
val_label(mydata$baseline_s4q11, 7) <- "Others"
val_label(mydata$baseline_s4q11, 9) <- "Others"
val_label(mydata$baseline_s4q11, 10) <- "Others"
val_label(mydata$baseline_s4q11, 12) <- "Others"
val_label(mydata$baseline_s4q11, 13) <- "Others"
val_label(mydata$baseline_s4q11, 14) <- "Others"
val_label(mydata$baseline_s4q11, 16) <- "Others"
val_label(mydata$baseline_s4q11, 17) <- "Others"

val_label(mydata$baseline_s17q9, 2) <- "Others"
val_label(mydata$baseline_s17q9, 3) <- "Others"
val_label(mydata$baseline_s17q9, 5) <- "Others"
val_label(mydata$baseline_s17q9, 6) <- "Others"
val_label(mydata$baseline_s17q9, 7) <- "Others"
val_label(mydata$baseline_s17q9, 9) <- "Others"
val_label(mydata$baseline_s17q9, 10) <- "Others"
val_label(mydata$baseline_s17q9, 12) <- "Others"
val_label(mydata$baseline_s17q9, 13) <- "Others"
val_label(mydata$baseline_s17q9, 14) <- "Others"
val_label(mydata$baseline_s17q9, 16) <- "Others"
val_label(mydata$baseline_s17q9, 17) <- "Others"

# Drop variables recoded into others

dropvars <- c("baseline_lang2",
"baseline_lang3",
"baseline_lang9",
"baseline_lang10",
"baseline_lang11",
"baseline_lang12",
"baseline_rel4",
"baseline_rel5",
"baseline_rel6",
"baseline_rel7",
"baseline_rel8")

mydata <- mydata[!names(mydata) %in% dropvars]

#' #Matching and crosstabulations: Run automated PII check 
# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('baseline_s3q2', 'baseline_s3q8', 'baseline_s3q3') ##!!! Replace with candidate categorical demo vars

# weight variable
# !!! No weight
# household id variable (cluster)
selectedHouseholdID = c('baseline_hhid') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars, hhId = selectedHouseholdID)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"baseline_s3q3"] <- NA

#Check that 2-anonimity is now maintained

createSdcObj(dat = mydata, keyVars = selectedKeyVars, hhId = selectedHouseholdID)

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("baseline_s2q4other",
               "baseline_s2q5other",
               "baseline_s2q6other",
               "baseline_s9q1_1other",
               "baseline_s9q2_2other",
               "baseline_s9q2_1other",
               "baseline_s9q1_2other",
               "baseline_s9q5other",
               "baseline_s9q6other",
               "baseline_s10q3other",
               "baseline_s10q5other",
               "baseline_s10q8other",
               "baseline_s10q10other",
               "baseline_s11q3other",
               "baseline_s11q6other",
               "baseline_s13q1other",
               "baseline_s3q1other",
               "baseline_s3q5other",
               "baseline_s4q6other",
               "baseline_s4q11other",
               "baseline_s5q6",
               "baseline_s5q6_2",
               "baseline_s5q13other",
               "baseline_s5q14other",
               "baseline_s6q8other",
               "baseline_s17q6other",
               "baseline_s17q9other",
               "baseline_s18q3other",
               "baseline_s19q4",
               "baseline_s19q4b",
               "baseline_s19q11other",
               "baseline_s20q8other")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% open_ends] # SDC risk could not be ascertained as all verbatims are partially or completely in Nepali.

#' #GPS data: Displace
# !!! No GPS data. 

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---