#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "endline" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!!No Direct PII
#'
#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
# !!!No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

mydata$endline_child_municipality <- as.numeric(mydata$endline_child_municipality)
locvars <- c("endline_villagename", 
             "endline_settlement", 
             "endline_municipality",
             "endline_wardno", 
             "endline_child_municipality", 
             "endline_child_wardno", 
             "endline_child_villagename", 
             "endline_child_settlement") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

mydata <- top_recode ("endline_s3q3", break_point=80, missing=999999) # Topcode cases age 80 or older
mydata <- top_recode ("endline_s4q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("endline_child_nhhmmbrs", break_point=10, missing=999999) # Topcode cases with 10 or more members
mydata <- top_recode ("endline_s17q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("endline_s4q8", break_point=60, missing=999999) # Topcode cases with 60 or longer

# !!!Include relevant variables in list below

indirect_PII <- c("endline_s5q6c",
                  "endline_s19q4c",
                  "endline_s5q6_2c",
                  "endline_s19q4bc",
                  "endline_nhhmmbrs",
                  "endline_s8q0",
                  "endline_s10q6b",
                  "endline_s11q2",
                  "endline_s11q3",
                  "endline_s11q4",
                  "endline_s11q5",
                  "endline_s11q6",
                  "endline_s11q7",
                  "endline_s11q8",
                  "endline_s11q9",
                  "endline_s3q2",
                  "endline_s3q2a",
                  "endline_s3q3",
                  "endline_s3q4",
                  "endline_s3q5_1",
                  "endline_onlychild",
                  "endline_s3q6",
                  "endline_s3q7",
                  "endline_s3q8",
                  "endline_s3q9a",
                  "endline_s3q9b",
                  "endline_s3q9c",
                  "endline_s3q9d",
                  "endline_s3q9e",
                  "endline_s3q10",
                  "endline_s4q1",
                  "endline_s4q2",
                  "endline_s4q3",
                  "endline_s4q3_1",
                  "endline_s4q4",
                  "endline_s4q7",
                  "endline_s4q8",
                  "endline_s4q9",
                  "endline_s5q1",
                  "endline_s5q2a",
                  "endline_s5q2b",
                  "endline_s5q2c",
                  "endline_s5q2d",
                  "endline_s5q2e",
                  "endline_s5q2f",
                  "endline_s5q2g",
                  "endline_s5q2h",
                  "endline_s5q3",
                  "endline_s5q4a",
                  "endline_s5q4b",
                  "endline_s5q4c",
                  "endline_s5q4d",
                  "endline_s5q4e",
                  "endline_s5q4f",
                  "endline_s5q4g",
                  "endline_s5q4h",
                  "endline_s5q4i",
                  "endline_s5q5",
                  "endline_s5q6a",
                  "endline_s5q7",
                  "endline_s5q8",
                  "endline_s5q9",
                  "endline_s5q11",
                  "endline_s5q12",
                  "endline_s5q15",
                  "endline_s5q16",
                  "endline_s5q18",
                  "endline_s6q2",
                  "endline_s6q7",
                  "endline_s6q8",
                  "endline_s16q3",
                  "endline_s17q1",
                  "endline_s17q2",
                  "endline_s17q3",
                  "endline_s17q4",
                  "endline_s17q7",
                  "endline_s17q8",
                  "endline_s18q2a",
                  "endline_s18q2b",
                  "endline_s18q2c",
                  "endline_s18q2d",
                  "endline_s18q2e",
                  "endline_s18q2f",
                  "endline_s18q2g",
                  "endline_s18q2h",
                  "endline_s18q4",
                  "endline_s19q1",
                  "endline_s19q2a",
                  "endline_s19q2b",
                  "endline_s19q2c",
                  "endline_s19q2d",
                  "endline_s19q2e",
                  "endline_s19q2f",
                  "endline_s19q2g",
                  "endline_s19q2h",
                  "endline_s19q2i",
                  "endline_s19q3",
                  "endline_s19q4a",
                  "endline_s19q5",
                  "endline_s19q6",
                  "endline_s19q7",
                  "endline_s19q12",
                  "endline_s19q13",
                  "endline_s19q14",
                  "endline_s20q2",
                  "endline_s20q4",
                  "endline_s20q5",
                  "endline_s20q7",
                  "endline_s20q8",
                  "endline_child_nhhmmbrs",
                  "endline_numhhmbrs",
                  "endline_female",
                  "endline_sexresp",
                  "endline_ppi1",
                  "endline_ppi2",
                  "endline_ppi3",
                  "endline_ppi4",
                  "endline_ppi5",
                  "endline_ppi6",
                  "endline_ppi7",
                  "endline_ppi8",
                  "endline_ppi9",
                  "endline_ppi10",
                  "endline_CL_P",
                  "endline_CL_C",
                  "endline_CLC5_11",
                  "endline_CLC12_13",
                  "endline_CLC14_15",
                  "endline_CLP5_11",
                  "endline_CLP12_13",
                  "endline_CLP14_15")

capture_tables (indirect_PII)

# Recode those with very specific values 
# Removed, as verbatim responses are partially or entirely in Nepali.

dropvars <- c("endline_occup0", "endline_occup1", "endline_ind0", "endline_ind1") 
mydata <- mydata[!names(mydata) %in% dropvars]  

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("endline_nhhmmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members
mydata <- top_recode ("endline_numhhmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
mydata$sex <- mydata$endline_s3q2
mydata$sex [is.na(mydata$sex)] <- mydata$endline_s3q2a[is.na(mydata$sex)]
selectedKeyVars = c('sex', 'endline_s3q8', 'endline_s3q3') ##!!! Replace with candidate categorical demo vars

# weight variable
# !!! No weight
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
selectedHouseholdID = c('hhid') 

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
as.data.frame(mydata[notAnon,selectedKeyVars])
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables (exclude children, as critical for analysis)

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon & mydata$endline_s3q3 >17,"endline_s3q3"] <- NA

#Check that 2-anonimity is now maintained

createSdcObj(dat = mydata, keyVars = selectedKeyVars, hhId = selectedHouseholdID)

# 2 cases remain that do not meet 2-anonymity. 
# Since these cases involve children, and providing 2-anonimity would require supressing their age, on further steps are implemented to maintain the integrity of the data. 

mydata <- mydata[!names(mydata) %in% "sex"]

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("occup0",
               "occup1",
               "ind0",
               "ind1",
               "endline_s9q5other",
               "endline_s9q6other",
               "endline_s10q5other",
               "endline_s10q10other",
               "endline_s11q3other",
               "endline_s11q6other",
               "endline_s13q1other",
               "endline_s3q1other",
               "endline_s3q5other",
               "endline_s4q6other",
               "endline_s4q9other",
               "endline_s4q11other",
               "endline_s5q6",
               "endline_s5q6_2",
               "endline_s17q6other",
               "endline_s17q9other",
               "endline_s18q3other",
               "endline_s19q4",
               "endline_s19q4b")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% open_ends] # SDC risk could not be ascertained as all verbatims are partially or completely in Nepali.

#' #GPS data: Displace
# !!! No GPS data. 

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))
  
#Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
