#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "midline3" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!!No Direct PII
#'
#' #Direct PII-team: Encode interviewer names, which may be useful for analysis of interviewer effects
# !!!No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

mydata$mid3_child_municipality <- as.numeric(mydata$mid3_child_municipality)
locvars <- c("mid3_villagename", 
             "mid3_settlement", 
             "mid3_municipality",
             "mid3_wardno", 
             "mid3_child_municipality", 
             "mid3_child_wardno", 
             "mid3_child_villagename", 
             "mid3_child_settlement") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" of 10 or less. 

mydata <- top_recode ("mid3_s3q3", break_point=80, missing=999999) # Topcode cases age 80 or older
mydata <- top_recode ("mid3_s4q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("mid3_child_nhhmmbrs", break_point=10, missing=999999) # Topcode cases with 10 or more members
mydata <- top_recode ("mid3_s17q7", break_point=60, missing=999999) # Topcode cases with 60 or farther 
mydata <- top_recode ("mid3_s4q8", break_point=60, missing=999999) # Topcode cases with 60 or longer

# !!!Include relevant variables in list below

indirect_PII <- c("mid3_occup0",
                  "mid3_s5q6c",
                  "mid3_occup1",
                  "mid3_s19q4c",
                  "mid3_ind0",
                  "mid3_s5q6_2c",
                  "mid3_ind1",
                  "mid3_s19q4bc",
                  "mid3_nhhmmbrs",
                  "mid3_s8q0",
                  "mid3_s10q6b",
                  "mid3_s11q2",
                  "mid3_s11q3",
                  "mid3_s11q4",
                  "mid3_s11q5",
                  "mid3_s11q6",
                  "mid3_s11q7",
                  "mid3_s11q8",
                  "mid3_s11q9",
                  "mid3_s13q1_1",
                  "mid3_s13q1_2",
                  "mid3_s13q1_3",
                  "mid3_s13q1_4",
                  "mid3_s13q1_5",
                  "mid3_s13q1_6",
                  "mid3_s13q1_7",
                  "mid3_s13q1_8",
                  "mid3_s13q1_9",
                  "mid3_s13q1_10",
                  "mid3_s13q1_11",
                  "mid3_s13q1_12",
                  "mid3_s13q1_13",
                  "mid3_s13q1_14",
                  "mid3_s13q1_96",
                  "mid3_s3q2",
                  "mid3_s3q2a",
                  "mid3_s3q3",
                  "mid3_s3q4",
                  "mid3_s3q5_1",
                  "mid3_onlychild",
                  "mid3_s3q6",
                  "mid3_s3q7",
                  "mid3_s3q8",
                  "mid3_s3q9a",
                  "mid3_s3q9b",
                  "mid3_s3q9c",
                  "mid3_s3q9d",
                  "mid3_s3q9e",
                  "mid3_s3q10",
                  "mid3_s4q1",
                  "mid3_s4q2",
                  "mid3_s4q3",
                  "mid3_s4q3_1",
                  "mid3_s4q4",
                  "mid3_s4q6_1",
                  "mid3_s4q6_2",
                  "mid3_s4q6_5",
                  "mid3_s4q6_9",
                  "mid3_s4q7",
                  "mid3_s4q8",
                  "mid3_s4q9",
                  "mid3_s4q9_1",
                  "mid3_s4q9_2",
                  "mid3_s4q9_3",
                  "mid3_s4q9_4",
                  "mid3_s4q9_5",
                  "mid3_s4q9_6",
                  "mid3_s4q9_7",
                  "mid3_s4q9_8",
                  "mid3_s4q9_96",
                  "mid3_s5q1",
                  "mid3_s5q1_1",
                  "mid3_s5q1_2",
                  "mid3_s5q1_3",
                  "mid3_s5q1_4",
                  "mid3_s5q1_5",
                  "mid3_s5q1_6",
                  "mid3_s5q1_7",
                  "mid3_s5q1_8",
                  "mid3_s5q1_9",
                  "mid3_s5q2a",
                  "mid3_s5q2b",
                  "mid3_s5q2c",
                  "mid3_s5q2d",
                  "mid3_s5q2e",
                  "mid3_s5q2f",
                  "mid3_s5q2g",
                  "mid3_s5q2h",
                  "mid3_s5q3",
                  "mid3_s5q4a",
                  "mid3_s5q4b",
                  "mid3_s5q4c",
                  "mid3_s5q4d",
                  "mid3_s5q4e",
                  "mid3_s5q4f",
                  "mid3_s5q4g",
                  "mid3_s5q4h",
                  "mid3_s5q4i",
                  "mid3_s5q5",
                  "mid3_s5q6a",
                  "mid3_s5q7",
                  "mid3_s5q8",
                  "mid3_s5q9",
                  "mid3_s5q11",
                  "mid3_s5q12",
                  "mid3_s5q15",
                  "mid3_s5q16",
                  "mid3_s5q18",
                  "mid3_s6q2",
                  "mid3_s6q7",
                  "mid3_s6q8",
                  "mid3_s16q3",
                  "mid3_s17q1",
                  "mid3_s17q2",
                  "mid3_s17q3",
                  "mid3_s17q4",
                  "mid3_s17q7",
                  "mid3_s17q8",
                  "mid3_s17q8_1",
                  "mid3_s17q8_2",
                  "mid3_s17q8_3",
                  "mid3_s17q8_4",
                  "mid3_s17q8_5",
                  "mid3_s17q8_6",
                  "mid3_s17q8_7",
                  "mid3_s17q8_8",
                  "mid3_s18q1_1",
                  "mid3_s18q1_2",
                  "mid3_s18q1_3",
                  "mid3_s18q1_4",
                  "mid3_s18q1_5",
                  "mid3_s18q1_6",
                  "mid3_s18q1_7",
                  "mid3_s18q1_8",
                  "mid3_s18q1_9",
                  "mid3_s18q2a",
                  "mid3_s18q2b",
                  "mid3_s18q2c",
                  "mid3_s18q2d",
                  "mid3_s18q2e",
                  "mid3_s18q2f",
                  "mid3_s18q2g",
                  "mid3_s18q2h",
                  "mid3_s18q3_1",
                  "mid3_s18q3_2",
                  "mid3_s18q3_3",
                  "mid3_s18q3_4",
                  "mid3_s18q3_5",
                  "mid3_s18q3_96",
                  "mid3_s18q4",
                  "mid3_s19q1",
                  "mid3_s19q2a",
                  "mid3_s19q2b",
                  "mid3_s19q2c",
                  "mid3_s19q2d",
                  "mid3_s19q2e",
                  "mid3_s19q2f",
                  "mid3_s19q2g",
                  "mid3_s19q2h",
                  "mid3_s19q2i",
                  "mid3_s19q3",
                  "mid3_s19q4a",
                  "mid3_s19q5",
                  "mid3_s19q6",
                  "mid3_s19q7",
                  "mid3_s19q12",
                  "mid3_s19q13",
                  "mid3_s19q14",
                  "mid3_s20q2",
                  "mid3_s20q4",
                  "mid3_s20q5",
                  "mid3_s20q7",
                  "mid3_s20q8",
                  "mid3_child_nhhmmbrs",
                  "mid3_numhhmbrs",
                  "mid3_female",
                  "mid3_ppi1",
                  "mid3_ppi2",
                  "mid3_ppi3",
                  "mid3_ppi4",
                  "mid3_ppi5",
                  "mid3_ppi6",
                  "mid3_ppi7",
                  "mid3_ppi8",
                  "mid3_ppi9",
                  "mid3_ppi10",
                  "mid3_CL_P",
                  "mid3_CL_C",
                  "mid3_CLC5_11",
                  "mid3_CLC12_13",
                  "mid3_CLC14_15",
                  "mid3_CLP5_11",
                  "mid3_CLP12_13",
                  "mid3_CLP14_15")

capture_tables (indirect_PII)

# Recode those with very specific values 
# Removed, as verbatim responses are partially or entirely in Nepali.

dropvars <- c("mid3_occup0", "mid3_occup1", "mid3_ind0", "mid3_ind1") 
mydata <- mydata[!names(mydata) %in% dropvars]  

# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("mid3_nhhmmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members
mydata <- top_recode ("mid3_numhhmbrs", break_point=10, missing=c(999999)) # Topcode cases with 10 or more members

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
mydata$sex <- mydata$mid3_s3q2
mydata$sex [is.na(mydata$sex)] <- mydata$mid3_s3q2a[is.na(mydata$sex)]
selectedKeyVars = c('sex', 'mid3_s3q8', 'mid3_s3q3') ##!!! Replace with candidate categorical demo vars

# weight variable
# !!! No weight
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
selectedHouseholdID = c('hhid') 

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
as.data.frame(mydata[notAnon,selectedKeyVars])
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables (exclude children, as critical for analysis)

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon & mydata$mid3_s3q3 >17,"mid3_s3q3"] <- NA

#Check that 2-anonimity is now maintained

createSdcObj(dat = mydata, keyVars = selectedKeyVars, hhId = selectedHouseholdID)
mydata <- mydata[!names(mydata) %in% "sex"]

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("mid3_s9q1_1other",
               "mid3_s9q2_2other",
               "mid3_s9q2_1other",
               "mid3_s9q1_2other",
               "mid3_s9q5other",
               "mid3_s9q6other",
               "mid3_s10q3other",
               "mid3_s10q5other",
               "mid3_s10q8other",
               "mid3_s10q10other",
               "mid3_s11q3other",
               "mid3_s11q6other",
               "mid3_s13q1other",
               "mid3_s3q1other",
               "mid3_s3q5other",
               "mid3_s4q6other",
               "mid3_s4q9other",
               "mid3_s4q11other",
               "mid3_s5q6",
               "mid3_s5q6_2",
               "mid3_s5q13other",
               "mid3_s5q14other",
               "mid3_s17q6other",
               "mid3_s17q9other",
               "mid3_s18q3other",
               "mid3_s19q4",
               "mid3_s19q4b")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata <- mydata[!names(mydata) %in% open_ends] # SDC risk could not be ascertained as all verbatims are partially or completely in Nepali.

#' #GPS data: Displace
# !!! No GPS data. 

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))
  
#Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
