*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\B_t1_schooling"
use "B_t1_schooling.dta", clear
*label save using mylabels.do

label define grade 0 `"Never Attended School or Only Attended Pre-School"', modify
label define grade 1 `"Grade 1"', modify
label define grade 2 `"Grade 2"', modify
label define grade 3 `"Grade 3"', modify
label define grade 4 `"Grade 4"', modify
label define grade 5 `"Grade 5"', modify
label define grade 6 `"Grade 6"', modify
label define grade 7 `"Grade 7"', modify
label define grade 8 `"Grade 8"', modify
label define grade 9 `"Grade 9"', modify
label define grade 10 `"Grade 10"', modify
label define grade 11 `"Grade 11"', modify
label define grade 12 `"Grade 12"', modify
label define grade 13 `"University / Not Graduate"', modify
label define grade 14 `"University / Graduate"', modify
label define grade 15 `"Post Bachelors Tertiary Education"', modify
label define grade 98 `"Don't Know"', modify
label define grade 999 `"Not Applicable"', modify
label define grade 96 `"Others"', modify
label define missing 98 `"Don't Know"', modify
label define missing 999 `"Not Applicable"', modify
label define missing 96 `"Others"', modify
label define yesno 0 `"No"', modify
label define yesno 1 `"Yes"', modify
label define yesno 98 `"Don't Know"', modify
label define yesno 999 `"Not Applicable"', modify
label define yesno 96 `"Others"', modify

recode bl_t1 bl_t1_t2 bl_t1_t2_ad1 t1_b2_class_enroll t1_b5_school_last_7_days t1_b6_school_open_days t1_b8b_home_study_times t1_final_status t1_b1_attend_school t1_b3a_same_school t1_b4_school_identical t1_b8a_home_study (".o"= 96) (".d"= 98) (".n"= 999)

label values t1_b2_class_enroll grade
label values t1_b5_school_last_7_days t1_b6_school_open_days t1_b8b_home_study_times missing
label values t1_b1_attend_school t1_b3a_same_school t1_b4_school_identical t1_b8a_home_study yesno

save "B_t1_schooling_relabelled.dta"