#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "ecsection4_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII

#' #Direct PII-team: Encode field team names
#' !!! No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
#' !!! No action as variables are critical for analysis

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("q401_wrkdne_bfresunrise",
                  "q402_prob_inadqlight",
                  "q403_loudnoise_wrk",
                  "q404_wrk_extrmtemp",
                  "q405_wrk_brickcement",
                  "q406_wrk_stonebk_crush",
                  "q407_polish_gntestone",
                  "q408_wrk_construction",
                  "q409_wrk_carryhvy_load",
                  "q410_wrk_opertmachine",
                  "q411_wrk_injured",
                  "q412_wrk_hndlchemicls",
                  "q413_wrk_werglovmsk",
                  "q414_health_inwrk",
                  "q415_wrk_danger",
                  "q416_wrk_whodecids",
                  "q417_descrb_wrksite",
                  "q418_wrk_wrksite_lst12m",
                  "q419_dayoff_ifnotwell",
                  "q420_refdngtask_atwrk",
                  "q421_leavwrk_ifwanted",
                  "q422a_wrkng_offdebt",
                  "q422b_parent_punish",
                  "q422c_emplr_punish",
                  "q422d_noothwrk_avble",
                  "q422e_notengh_mny",
                  "q422f_dk_whrtogo",
                  "q422g_resp_eldrdecisn",
                  "q422h_fear_parents",
                  "q422i_parent_illness",
                  "q422j_finshrtg_hh",
                  "q422k_helpmthr",
                  "q422l_bczmthr_wrks",
                  "q422m_lovefor_wrk",
                  "q422n_noone_wrkathome",
                  "q422o_eldsib_athome",
                  "q422p_noone_infmly_gvemny",
                  "q422q_dkntwnt_leav",
                  "q422r_noone_athome",
                  "q422s_toern_mnysupp_edu",
                  "q422t_erntofeed_cattle",
                  "q422u_assist_sis",
                  "q422v_others",
                  "q423_hrswrk_lst12m",
                  "q424a_cash",
                  "q424b_newskill",
                  "q424c_education",
                  "q424d_shelter_foodcloths",
                  "q424e_medicalsupp",
                  "q424f_nothing",
                  "q424g_toys",
                  "q424h_fruits_veg",
                  "q424i_chocolate",
                  "q424j_dryfruit",
                  "q424k_bangles",
                  "q424l_jewellery",
                  "q424m_breakfast",
                  "q424n_utensils",
                  "q424o_snacks",
                  "q425_emplr_ben_parent",
                  "q426_earn_inaweek")

capture_tables (indirect_PII)

#' !!! No action as variables are critical for analysis

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' !!! No open-ends

# Drop all, as actually verbatim data in Hindi
mydata <- mydata[!names(mydata) %in% "q416_whether_oth"]
mydata <- mydata[!names(mydata) %in% "q417_desc_site_oth"]

#' #GPS data: Displace
#' !!! No GPS data
#'
#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
