*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\ehsection4"
use "ehsection4.dta", clear
*label save using mylabels.do

label define a439 1 `"Already doing or in an year"', modify
label define a439 2 `"In the next 1 to 5 years"', modify
label define a439 3 `"In the next 5 to 7 years"', modify
label define a439 4 `"Longer than 7 years from now"', modify
label define a439 5 `"I do not expect her to do this"', modify
label define a439 999 `"Not applicable"', modify
label define a425 1 `"No further schooling"', modify
label define a425 2 `"Primary school"', modify
label define a425 3 `"Upper Primary school"', modify
label define a425 4 `"Secondary school"', modify
label define a425 5 `"Senior secondary school"', modify
label define a425 6 `"University/Technical Training/Professional studies"', modify
label define a425 7 `"Post-university degree"', modify
label define a425 98 `"Don’t know"', modify
label define a425 999 `"Not applicable"', modify
label define a424 0 `"Disagree"', modify
label define a424 1 `"Agree"', modify
label define a424 999 `"Not applicable"', modify
label define a420 1 `"None"', modify
label define a420 2 `"A little say"', modify
label define a420 3 `"A lot of say"', modify
label define a420 999 `"Not applicable"', modify
label define a418 1 `"Allowed to go alone"', modify
label define a418 2 `"Allowed to go accompanied only"', modify
label define a418 3 `"Allowed to go alone or accompanied"', modify
label define a418 4 `"Not allowed to go at all"', modify
label define a418 999 `"Not applicable"', modify
label define a417 1 `"Never"', modify
label define a417 2 `"Rarely"', modify
label define a417 3 `"Sometimes"', modify
label define a417 4 `"Fairly often"', modify
label define a417 5 `"Almost always"', modify
label define a417 98 `"Don’t know"', modify
label define a417 999 `"Not applicable"', modify
label define a416 1 `"Not true"', modify
label define a416 2 `"Somewhat true"', modify
label define a416 3 `"Certainly true"', modify
label define a416 999 `"Not applicable"', modify
label define a407 0 `"Not in labor force"', modify
label define a407 1 `"Unpaid Worker in Family Farm"', modify
label define a407 2 `"Unpaid Worker in Family Business"', modify
label define a407 3 `"Self Employed in Agriculture"', modify
label define a407 4 `"Self Employed in Outside of Agr"', modify
label define a407 5 `"Regular Wage or Salary Worker in Agr"', modify
label define a407 6 `"Regular Wage or Salary Worker Outside of Agr."', modify
label define a407 7 `"Skilled worker"', modify
label define a407 8 `"Non-skilled labourer"', modify
label define a407 98 `"Don't know"', modify
label define a407 999 `"Not applicable"', modify
label define a406 1 `"Not Literate"', modify
label define a406 2 `"Literate without Formal Schooling"', modify
label define a406 3 `"Literate Below Primary"', modify
label define a406 4 `"Primary"', modify
label define a406 5 `"Middle"', modify
label define a406 6 `"Secondary"', modify
label define a406 7 `"Higher Secondary"', modify
label define a406 8 `"Diploma / Certificate Course"', modify
label define a406 9 `"Graduate"', modify
label define a406 10 `"Post Graduate and Above"', modify
label define a406 98 `"Don't know"', modify
label define a406 999 `"Not applicable"', modify
label define a209_09 98 `"Don't know"', modify
label define a209_09 999 `"Not applicable"', modify
label define a202c 0 `"Self"', modify
label define a202c 1 `"Father"', modify
label define a202c 2 `"Mother"', modify
label define a202c 3 `"Sister"', modify
label define a202c 4 `"Brother"', modify
label define a202c 5 `"Sister-in-law"', modify
label define a202c 6 `"Brother-in-law"', modify
label define a202c 7 `"Uncle"', modify
label define a202c 8 `"Maternal uncle"', modify
label define a202c 9 `"Maternal aunt"', modify
label define a202c 10 `"Grand father"', modify
label define a202c 11 `"Grand mother"', modify
label define a202c 12 `"Aunt"', modify
label define a202c 13 `"Father’s sister"', modify
label define a202c 14 `"Uncle (husband of father’s sister)"', modify
label define a202c 15 `"Grandfather (maternal )"', modify
label define a202c 16 `"Grandmother (maternal)"', modify
label define a202c 17 `"Aunt (mother’s sister)"', modify
label define a202c 18 `"Uncle (husband of mother’s sister)"', modify
label define a202c 19 `"Neice"', modify
label define a202c 20 `"Nephew"', modify
label define a202c 21 `"Cousin"', modify
label define a202c 22 `"Great grand mother"', modify
label define a202c 23 `"Unknown relation"', modify
label define a202c 24 `"Great grand father"', modify
label define a202c 25 `"Step mother"', modify
label define a202c 999 `"Not applicable"', modify
label define q10 0 `"Rural"', modify
label define q10 1 `"Urban"', modify
label define q10 999 `"Not applicable"', modify
label define yesno 0 `"No"', modify
label define yesno 1 `"Yes"', modify
label define yesno 98 `"Don't know"', modify
label define yesno 999 `"Not applicable"', modify

recode a415b_ralation_ a404_old_girl_die_ a405_stop_liv_resid_ a411_old_girl_die_ a412_stop_liv_resid_ a406_high_edu_ a406_high_edu_oth_ a413_hig_edu_ a407_employ_status_ a414_employ_status_ a416a_feeling_ a416b_restless_ a416c_headache_ a416d_book_ a416e_temper_ a416f_alone_ a416g_adult_request_ a416h_worries_ a416i_helpful_ a416j_squirming_ a416k_good_frnd_ a416l_unhappy_ a416m_youth_ a416n_distracted_ a416o_nervous_ a416p_child_ a416q_help_oth_ a416r_think_before_ a416s_along_better_ a416t_mny_fears_ a416u_span_ a417a_point_view_ a417b_goals_ a417c_facing_diffulties_ a417d_learn_new_thing_ a417e_opinion_ a418a_school_ a418b_frnd_house_ a418c_relat_house_ a418d_temple_ a418e_healthcntr_ a418f_market_ a418g_mela_ a418h_village_ a418i_relativ_palce_ a418j_study_ a420a_free_time_ a420b_school_ a420c_friends_ a420d_home_ a420e_when_marry_ a420f_who_marry_ a420g_wrk_furture_ a420h_organized_game_ a424a_wrk_out_hme_ a424b_husband_ a424c_high_educ_ a424d_dowry_ a424e_money_scarce_ a424f_same_amt_chore_ a424g_freedom_boy_ a424h_studying_ a424i_leaders_ a426_highest_ a439a_strt_earn_ a439b_leave_ a439c_indep_parent_ a439d_married_ a439e_aftr_marriage_ a439f_leave_hh_ a010_urban a401_mthr_live_reside_ a408_father_residen_ a410_father_alive_ a418k_other_ a419a_worries_ a419b_gng_well_ a419c_eduction_ a419d_when_married_ a419e_who_marry_ a419f_wrk_future_ a419g_pbrlm_school_ a421_daugh_strt_menst_ a427_point_ a430aa_current_ a430ab_future_ a430ac_continue_ a430ba_current_ a430bb_future_ a430bc_continue_ a430ca_current_ a430cb_future_ a430cc_continue_ a430da_current_ a430db_future_ a430dc_continue_ a430ea_current_ a430eb_future_ a430ec_continue_ a430fa_current_ a430fb_future_ a430fc_continue_ a430ga_current_ a430gb_future_ a430gc_continue_ a430ha_current_ a430hb_future_ a430hc_continue_ a430ia_current_ a430ib_future_ a430ic_continue_ a430ja_current_ a430jb_future_ a430jc_continue_ a430ka_current_ a430kb_future_ a430kc_continue_ a430l_oth_ a430l_oth_entry_ a430la_current_ a430lb_future_ a430lc_continue_ a436_advant_girl_ (".d"= 98) (".n"= 999)

label values a401_mthr_live_reside_ a408_father_residen_ a410_father_alive_ a418k_other_ a419a_worries_ a419b_gng_well_ a419c_eduction_ a419d_when_married_ a419e_who_marry_ a419f_wrk_future_ a419g_pbrlm_school_ a421_daugh_strt_menst_ a427_point_ a430aa_current_ a430ab_future_ a430ac_continue_ a430ba_current_ a430bb_future_ a430bc_continue_ a430ca_current_ a430cb_future_ a430cc_continue_ a430da_current_ a430db_future_ a430dc_continue_ a430ea_current_ a430eb_future_ a430ec_continue_ a430fa_current_ a430fb_future_ a430fc_continue_ a430ga_current_ a430gb_future_ a430gc_continue_ a430ha_current_ a430hb_future_ a430hc_continue_ a430ia_current_ a430ib_future_ a430ic_continue_ a430ja_current_ a430jb_future_ a430jc_continue_ a430ka_current_ a430kb_future_ a430kc_continue_ a430l_oth_ a430l_oth_entry_ a430la_current_ a430lb_future_ a430lc_continue_ a436_advant_girl_ yesno

label values a010_urban q10
label values a439a_strt_earn_ a439b_leave_ a439c_indep_parent_ a439d_married_ a439e_aftr_marriage_ a439f_leave_hh_ a439
label values a426_highest_ a425
label values a424a_wrk_out_hme_ a424b_husband_ a424c_high_educ_ a424d_dowry_ a424e_money_scarce_ a424f_same_amt_chore_ a424g_freedom_boy_ a424h_studying_ a424i_leaders_ a424
label values a420a_free_time_ a420b_school_ a420c_friends_ a420d_home_ a420e_when_marry_ a420f_who_marry_ a420g_wrk_furture_ a420h_organized_game_ a420
label values a418a_school_ a418b_frnd_house_ a418c_relat_house_ a418d_temple_ a418e_healthcntr_ a418f_market_ a418g_mela_ a418h_village_ a418i_relativ_palce_ a418j_study_ a418
label values a417a_point_view_ a417b_goals_ a417c_facing_diffulties_ a417d_learn_new_thing_ a417e_opinion_ a417
label values a416a_feeling_ a416b_restless_ a416c_headache_ a416d_book_ a416e_temper_ a416f_alone_ a416g_adult_request_ a416h_worries_ a416i_helpful_ a416j_squirming_ a416k_good_frnd_ a416l_unhappy_ a416m_youth_ a416n_distracted_ a416o_nervous_ a416p_child_ a416q_help_oth_ a416r_think_before_ a416s_along_better_ a416t_mny_fears_ a416u_span_ a416 
label values a407_employ_status_ a414_employ_status_ a407
label values a406_high_edu_ a406_high_edu_oth_ a413_hig_edu_ a406
label values a404_old_girl_die_ a405_stop_liv_resid_ a411_old_girl_die_ a412_stop_liv_resid_ a209_09
label values a415b_ralation_ a202c

save "ehsection4_relabelled.dta"

use "ehsection4_relabelled_PU.dta", clear
savespss "ehsection4_relabelled_PU.dta.sav"
