#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames, data, functions and create dictionary for dataset review

filename <- "ehsection4_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII
#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("a006_a_block_id", "a007_a_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

break_age <- c(0,5,10,15,20)
labels_age <- c("0-4" =1, 
                "5-9" =2, 
                "10-14" =3, 
                "15-19"=4, 
                "20 or older"=5)

mydata <- ordinal_recode (variable="a404_old_girl_die_", break_points=break_age, missing=999999, value_labels=labels_age)
mydata <- ordinal_recode (variable="a405_stop_liv_resid_", break_points=break_age, missing=999999, value_labels=labels_age)
mydata <- ordinal_recode (variable="a411_old_girl_die_", break_points=break_age, missing=999999, value_labels=labels_age)
mydata <- ordinal_recode (variable="a412_stop_liv_resid_", break_points=break_age, missing=999999, value_labels=labels_age)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("a415a_guardn_child_", 
                  "a430l_oth_",
                  "a430l_oth_entry_",
                  "a430la_current_")
capture_tables (indirect_PII)

#' #Matching and crosstabulations: Run automated PII check 
# !!! No direct demographic variables available in dataset

#' #Open-ends: review responses for any sensitive information, redact as necessary

open_ends <- c("a415a_guardn_child_",
               "a418k_other_entry_",
               "a422_life_change_",
               "a423_plan_future_",
               "a428_obstacle_girl_",
               "a429_gto_school_",
               "a429_gto_school_oth_",
               "a435_situations_",
               "a437_advantages_",
               "a438_good_match_")
report_open (list_open_ends = open_ends)

dropvars <- c("a418k_other_entry_",
              "a422_life_change_",
              "a423_plan_future_",
              "a429_gto_school_oth_")

mydata <- mydata[!names(mydata) %in% dropvars] # Drop as actually verbatim data in local language

#' #GPS data: Displace
# !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
