#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "C_t2_work" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 
#
#' #Direct PII: variables to be removed
# !!!No Direct PII 
#
#' #Direct PII-team: Encode field team names
# !!!No Direct PII-team
#
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations
#
#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal
#
#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
#  !!!No Indirect PII - Categorical

indirect_PII <- c("t2_c1_family_own_farm",
"t2_c3_a_hh_agriculture",
"t2_c5_own_business",
"t2_c7_a_business_help",
"t2_c13_work_type")

capture_tables (indirect_PII)

# Recode those with very specific values. 

#' #Matching and crosstabulations: Run automated PII check
# !!!Insufficient demographic information

#' #Open-ends: review responses for any sensitive information, redact as necessary
#!!!No Open-Ends

#' #GPS data: Displace
# !!!No GPS data

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---

