#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames, data, functions and create dictionary for dataset review

filename <- "bhsection5" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII
#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q006_block_id", "q007_vlg_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata <- top_recode (variable="q501_cereals", break_point=percentile_checker ("q501_cereals"), missing=NA)
mydata <- top_recode (variable="q502_pulses", break_point=percentile_checker ("q502_pulses"), missing=NA)
mydata <- top_recode (variable="q503_milk", break_point=percentile_checker ("q503_milk"), missing=NA)
mydata <- top_recode (variable="q504_milk_products", break_point=percentile_checker ("q504_milk_products"), missing=NA)
mydata <- top_recode (variable="q505_oil", break_point=8000, missing=NA)
mydata <- top_recode (variable="q506_vegetables", break_point=percentile_checker ("q506_vegetables"), missing=NA)
mydata <- top_recode (variable="q507_fruits", break_point=percentile_checker ("q507_fruits"), missing=NA)
mydata <- top_recode (variable="q508_egg", break_point=percentile_checker ("q508_egg"), missing=NA)
mydata <- top_recode (variable="q509_sugar", break_point=percentile_checker ("q509_sugar"), missing=NA)
mydata <- top_recode (variable="q510_salt", break_point=7000, missing=NA)
mydata <- top_recode (variable="q511_tea", break_point=3000, missing=NA)
mydata <- top_recode (variable="q512_pan", break_point=percentile_checker ("q512_pan"), missing=NA)
mydata <- top_recode (variable="q513_fuel", break_point=9000, missing=NA)
mydata <- top_recode (variable="q514_cinema", break_point=percentile_checker ("q514_cinema"), missing=NA)
mydata <- top_recode (variable="q515_torch", break_point=2000, missing=NA)
mydata <- top_recode (variable="q516_paste", break_point=3000, missing=NA)
mydata <- top_recode (variable="q517_bulb", break_point=4000, missing=NA)
mydata <- top_recode (variable="q518_servant", break_point=50000, missing=NA)
mydata <- top_recode (variable="q519_disel", break_point=30000, missing=NA)
mydata <- top_recode (variable="q520_rent", break_point=percentile_checker ("q520_rent"), missing=NA)
mydata <- top_recode (variable="q521_tax", break_point=4500, missing=NA)
mydata <- top_recode (variable="q522_medicine", break_point=percentile_checker ("q522_medicine"), missing=NA)
mydata <- top_recode (variable="q523_med_institute", break_point=350000, missing=NA)
mydata <- top_recode (variable="q524_fee", break_point=60000, missing=NA)
mydata <- top_recode (variable="q525_books", break_point=percentile_checker ("q525_books"), missing=NA)
mydata <- top_recode (variable="q526_clothes", break_point=percentile_checker ("q526_clothes"), missing=NA)
mydata <- top_recode (variable="q527_shoes", break_point=percentile_checker ("q527_shoes"), missing=NA)
mydata <- top_recode (variable="q528_furniture", break_point=40000, missing=NA)
mydata <- top_recode (variable="q529_crockery", break_point=percentile_checker ("q529_crockery"), missing=NA)
mydata <- top_recode (variable="q530_electricity", break_point=30000, missing=NA)
mydata <- top_recode (variable="q531_tv", break_point=17000, missing=NA)
mydata <- top_recode (variable="q532_jewelry", break_point=450000, missing=NA)
mydata <- top_recode (variable="q533_cycle", break_point=500000, missing=NA)
mydata <- top_recode (variable="q534_therapy", 3000, missing=NA)
mydata <- top_recode (variable="q535_clock", 20000, missing=NA)
mydata <- top_recode (variable="q536_repair", break_point=percentile_checker ("q536_repair"), missing=NA)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!! No Indirect PII categorical

#' #Matching and crosstabulations: Run automated PII check 
# !!! No direct demographic variables available in dataset

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No open-ends

#' #GPS data: Displace
# !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
