#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "bcsection3_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII

#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!! No Direct PII - Ordinal

#' #Indirect PII - Categrical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("q301_own_farm",
"q302_help_farm",
"q303_paid",
"q304_own_busi",
"q305_spend_busi",
"q306_income",
"q307_work_not_fly",
"q308_paid",
"q309_accomp_mem",
"q310_type_work",
"q311_activity1",
"q311_activity2",
"q311_activity3",
"q311_activity4",
"q311_activity5",
"q311_activity6",
"q311_activity7",
"q311_activity8",
"q311_activity9",
"q311_activity10",
"q311_activity11",
"q311_activity12",
"q311_activity13",
"q311_activity14",
"q311_activity15",
"q311_activity16",
"q311_activity17",
"q311_activity18",
"q311_activity19",
"q311_activity20",
"q311_activity21",
"q311_activity22",
"q311_activity23",
"q311_activity24",
"q311_activity25",
"q311_activity26",
"q311_activity27",
"q311_activity28",
"q311_activity29",
"q311_activity30",
"q311_activity31",
"q311_activity32",
"q330_help_farm",
"q331_spend_busi",
"q332_work_not_fly")

capture_tables (indirect_PII)

#' #Matching and crosstabulations: Run automated PII check 

#!!!Demographic information available is insufficient for matching analysis. 

#' #Open-ends: review responses for any sensitive information, redact as necessary

open_ends <- c("q310_type_work_oth",
               "q311_act_oth1",
               "q311_act_oth2",
               "q311_act_oth3",
               "q311_act_oth4",
               "q311_act_oth5",
               "q311_act_oth6",
               "q311_act_oth7",
               "q311_act_oth8",
               "q311_act_oth9",
               "q311_act_oth10",
               "q311_act_oth11",
               "q311_act_oth12",
               "q311_act_oth13",
               "q311_act_oth14",
               "q311_act_oth15",
               "q311_act_oth16",
               "q311_act_oth17",
               "q311_act_oth18",
               "q311_act_oth19",
               "q311_act_oth20",
               "q311_act_oth21",
               "q311_act_oth22",
               "q311_act_oth23",
               "q311_act_oth24",
               "q311_act_oth25",
               "q311_act_oth26",
               "q311_act_oth27",
               "q311_act_oth28",
               "q311_act_oth29",
               "q311_act_oth30",
               "q311_act_oth31",
               "q311_act_oth32")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# Drop all, as actually verbatim data in Hindi
mydata <- mydata[!names(mydata) %in% "q310_type_work_oth"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth1"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth2"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth3"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth4"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth5"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth6"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth7"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth8"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth9"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth10"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth11"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth12"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth13"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth14"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth15"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth16"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth17"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth18"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth19"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth20"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth21"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth22"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth23"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth24"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth25"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth26"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth27"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth28"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth29"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth30"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth31"]
mydata <- mydata[!names(mydata) %in% "q311_act_oth32"]

#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
