*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\0_t2_gnrl_info"
use "0_t2_gnrl_info.dta", clear

local yesno t1_ch_consent t1_ch_age_aware t1_child_dob
local missing t1_a3_ch_back t1_child_age

recode `yesno' `missing' t1_a1_child_present t1_a2_ch_present_status (".d"= 98) (".n"= 99) (".o"= 96)

label define yesno2 0 "No" 1 "Yes" 96 "Other" 98 "Don't know" 99 "Not applicable"
label values `yesno' yesno2

label define missing2 96 "Other" 98 "Don't know" 99 "Not applicable"
label values `missing' missing2

label define child_present_l 0 "No" 1 "Yes" 3 "Child is dead" 96 "Other" 98 "Don't know" 99 "Not applicable"
label values t1_a1_child_present child_present_l 

label define child_status_l 1 "Have gone to Relative's place permanently" 2 "Have gone to Relative's place for a month" 3 "Migrated to other location" 96 "Other" 98 "Don't know" 99 "Not applicable"
label values t1_a2_ch_present_status child_status_l 

save "0_t2_gnrl_info_relabelled.dta"