#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "0_t2_gnrl_info_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
#!!!No Direct PII

#' #Direct PII-team: Encode field team names
# !!!No Direct PII-team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Remove date of birth

dropvars <- c("t1_dob_calculated") 
mydata <- mydata[!names(mydata) %in% dropvars]

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("t1_a1_child_present",
                  "t1_a2_ch_present_status",
                  "t1_a3_ch_back",
                  "t1_child_age")

capture_tables (indirect_PII)

#' #Matching and crosstabulations: Run automated PII check 
#!!!Not enough demographic information to conduct matching

#' #Open-ends: review responses for any sensitive information, redact as necessary
#!!!No Open-ends

#' #GPS data: Displace
#!!!NO GPS variables

#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
