#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "ecsection5_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII

#' #Direct PII-team: Encode field team names
#' !!! No Direct PII-team
#' 
#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
#' !!! No Indirect PII - Ordinal
#' 
#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("q504_areu_currmarrd",
                  "q506o_others_entry",
                  "q506o_other_access")

capture_tables (indirect_PII)

# Recode those with very specific values. 
#' !!! No action, low risk

val_labels(mydata$q506o_others_entry)
breaks <- c(1:7)
labels <- c("Small motor vehicle" = 1,
            "Water heater" = 2,
            "Fan/cooler" = 3,
            "Tape recorder" = 4,
            "Large Motor Vehicle" = 5,
            "Boxes" = 6,
            "Books" = 7)
mydata2 <- ordinal_recode (variable="q506o_others_entry", 
                          break_points=breaks, 
                          missing=999999, 
                          value_labels=labels)

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!!Identify open-end variables here: 

open_ends <- c("q509_watntobecome",
               "q512d_steps_nxtyr1",
               "q512d_steps_nxtyr2",
               "q512d_steps_nxtyr3",
               "q512g_knwtodo_1yr")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
#' !!! Drop all, as actually verbatim data in Hindi

drop_vars <- c("q512d_steps_nxtyr1",
               "q512d_steps_nxtyr2",
               "q512d_steps_nxtyr3",
               "q512g_knwtodo_1yr")
mydata <- mydata[!names(mydata) %in% drop_vars]

#' #GPS data: Displace
#' !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
