*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\ecsection5_objmeasures"
use "ecsection5_objmeasures.dta", clear
*label save using mylabels.do

label define urban 0 `"Rural"', modify
label define urban 1 `"Urban"', modify
label define q513a 98 `"Don't know"', modify
label define q513a 999 `"Not applicable"', modify
label define q519 1 `"Never"', modify
label define q519 2 `"Almost never"', modify
label define q519 3 `"Sometimes"', modify
label define q519 4 `"Fairly often"', modify
label define q519 5 `"Very often"', modify
label define q519 999 `"Not applicable"', modify
label define q520 1 `"Strongly agree"', modify
label define q520 2 `"Agree"', modify
label define q520 3 `"Disagree"', modify
label define q520 4 `"Strongly disagree"', modify
label define q520 999 `"Not applicable"', modify
label define q521b 1 `"Found"', modify
label define q521b 2 `"Attempted but not found"', modify
label define q521b 3 `"Not attempted"', modify
label define q521b 999 `"Not applicable"', modify
label define q521d 0 `"Not found"', modify
label define q521d 1 `"Found on own"', modify
label define q521d 2 `"Parent/sibling took on task"', modify
label define q521d 3 `"Negotiated with parent"', modify
label define q521d 4 `"Negotiated with other adult"', modify
label define q521d 5 `"Negotiated with peer"', modify
label define q521d 6 `"Didn’t talk to anyone"', modify
label define q521d 7 `"Negotiated with siblings"', modify
label define q521d 8 `"Negotiated with adult family members"', modify
label define q521d 9 `"Didn’t perform"', modify
label define q521d 10 `"Negotiated with teachers"', modify
label define q521d 11 `"Negotiated with grandparents"', modify
label define q521d 12 `"Negotiated with friend"', modify
label define q521d 13 `"No strategy applied"', modify
label define q521d 14 `"Negotiated with neighbours"', modify
label define q521d 999 `"Not applicable"', modify
label define q521e 1 `"Ran out of time"', modify
label define q521e 2 `"Felt scared"', modify
label define q521e 3 `"Did not know who to ask"', modify
label define q521e 4 `"Did not understand item description"', modify
label define q521e 5 `"Forget to perform activity"', modify
label define q521e 6 `"Girl was ill"', modify
label define q521e 7 `"Parent/guardian/teachers did not show interest"', modify
label define q521e 9 `"Casual behaviour"', modify
label define q521e 10 `"Child did not show interest"', modify
label define q521e 11 `"Girl is illiterate"', modify
label define q521e 12 `"Girl was not available"', modify
label define q521e 13 `"Busy with exams"', modify
label define q521e 14 `"Due to superstition/black magic"', modify
label define q521e 15 `"Did not find time to perform"', modify
label define q521e 16 `"Did not find"', modify
label define q521e 17 `"Revisit done earlier"', modify
label define q521e 18 `"Girl stays at hostel"', modify
label define q521e 19 `"Due to household conflict"', modify
label define q521e 20 `"Holidays"', modify
label define q521e 21 `"Religious issues"', modify
label define q521e 22 `"Collected but returned"', modify
label define q521e 23 `"Did not attend school"', modify
label define q521e 24 `"Item unavailable in community"', modify
label define q521e 999 `"Not applicable"', modify

recode q517_stnd_atprsnt q519_1_cntrlimpthngs q519_2_handl_persprob q519_3_thnginyurway q519_4_notovercme_diffc q520_1satwithmyself q520_2notgdatall q520_3haveno_ofgdqlts q520_4abltodothngd q520_5nthvemuch_proud q520_6feeluseless q520_7prsnwrth q520_8wishmre_respct q520_9imfailure q520_10_posattitude q521b_outcome_1 q521b_outcome_2 q521b_outcome_3 q521b_outcome_4 q521b_outcome_5 q521b_outcome_6 q521b_outcome_7 q521b_outcome_8 q521b_outcome_9 q521b_outcome_10 q521d_strgesattmp_item_1 q521d_strgesattmp_item_2 q521d_strgesattmp_item_3 q521d_strgesattmp_item_4 q521d_strgesattmp_item_5 q521d_strgesattmp_item_6 q521d_strgesattmp_item_7 q521d_strgesattmp_item_8 q521d_strgesattmp_item_9 q521d_strgesattmp_item_10 q521e_reasons_1 q521e_reasons_2 q521e_reasons_3 q521e_reasons_4 q521e_reasons_5 q521e_reasons_6 q521e_reasons_7 q521e_reasons_8 q521e_reasons_9 q521e_reasons_10 (".d"= 98) (".n"= 999)

label values q521e_reasons_1 q521e_reasons_2 q521e_reasons_3 q521e_reasons_4 q521e_reasons_5 q521e_reasons_6 q521e_reasons_7 q521e_reasons_8 q521e_reasons_9 q521e_reasons_10 q521e

label values q521d_strgesattmp_item_1 q521d_strgesattmp_item_2 q521d_strgesattmp_item_3 q521d_strgesattmp_item_4 q521d_strgesattmp_item_5 q521d_strgesattmp_item_6 q521d_strgesattmp_item_7 q521d_strgesattmp_item_8 q521d_strgesattmp_item_9 q521d_strgesattmp_item_10 q521d

label values q521b_outcome_1 q521b_outcome_2 q521b_outcome_3 q521b_outcome_4 q521b_outcome_5 q521b_outcome_6 q521b_outcome_7 q521b_outcome_8 q521b_outcome_9 q521b_outcome_10 q521b
label values q520_1satwithmyself q520_2notgdatall q520_3haveno_ofgdqlts q520_4abltodothngd q520_5nthvemuch_proud q520_6feeluseless q520_7prsnwrth q520_8wishmre_respct q520_9imfailure q520_10_posattitude q520
label values q519_1_cntrlimpthngs q519_2_handl_persprob q519_3_thnginyurway q519_4_notovercme_diffc q519
label values q517_stnd_atprsnt q513e

save "ecsection5_objmeasures_relabelled.dta"
