#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "ecsection5_objmeasures_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .csv format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!Include any Direct PII variables
# !!! No Direct PII variables


#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team variables
#
#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 
# !!! No Indirect PII - Ordinal variables

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)
# !!! No Indirect PII - Categorical variables


#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("q521f_obstacles_oth_1",
               "q521g_notes_1",
               "q521f_obstacles_oth_2",
               "q521g_notes_2",
               "q521f_obstacles_oth_3",
               "q521g_notes_3",
               "q521f_obstacles_oth_4",
               "q521g_notes_4",
               "q521f_obstacles_oth_5",
               "q521g_notes_5",
               "q521f_obstacles_oth_6",
               "q521g_notes_6",
               "q521f_obstacles_oth_7",
               "q521g_notes_7",
               "q521f_obstacles_oth_8",
               "q521g_notes_8",
               "q521f_obstacles_oth_9",
               "q521g_notes_9",
               "q521f_obstacles_oth_10",
               "q521g_notes_10")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# Drop all, as actually verbatim data in Hindi

mydata <- mydata[!names(mydata) %in% open_ends]

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
