#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "C_t1_work_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .csv format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII
#'
#' #Direct PII-team: Encode field team names
# !!!No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations
#'
#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal
#'
#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("t1_c1_work_own_farm",
                  "t1_c2_help_farm_7days",
                  "t1_c4_income_farm_7days",
                  "t1_c5_work_own_nonfarm",
                  "t1_c6_help_nonfarm_7days",
                  "t1_c8_income_nonfarm_7days",
                  "t1_c9_work_nonfamily",
                  "t1_c11_income_nonfamily_7days",
                  "t1_c13_work_type")

capture_tables (indirect_PII)


#' #Matching and crosstabulations: Run automated PII check 
#!!! Insufficient demographic information 

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! Identify open-end variables here: 
open_ends <- c("t1_c13_work_type_specify")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

dropvars <- c("t1_c13_work_type_specify") 
mydata <- mydata[!names(mydata) %in% dropvars] # Drop as actually verbatim data in Indi

#' #GPS data: Displace
# !!!No GPS data

#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
