*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\ehsection1"
use "ehsection1.dta", clear
*label save using mylabels.do

local yesno a107_b_onrent_cultivate a108_hh_job_card a110_bank_po_ac a111a_aff_earthquake a112a_res_earthquake a111b_aff_drought a112b_res_drought a111c_aff_flood a112c_res_flood a111d_aff_storms a112d_res_storms a111e_aff_cyclone a112e_res_cyclone a111f_aff_plague a112f_res_plague a111g_aff_layoff a112g_res_layoff a111h_aff_price a112h_res_price a111i_aff_protest a112i_res_protest a111j_aff_sequestrated a112j_res_sequestrated a111k_aff_infrastructure a112k_res_infrastructure a111l_aff_fodder a112l_res_fodder a111m_aff_school a112m_res_school a111n_aff_employ a112n_res_employ a111o_aff_electric a112o_res_electric a111p_aff_gen_othr a112p_res_gen_othr a113a_loss_emp a114a_loss_emp a113b_low_income a114b_low_income a113c_family_busines a114c_family_busines a113d_wrk_member a114d_wrk_member a113e_non_working a114e_non_working a113f_death a114f_death a113g_fire a114g_fire a113h_robbery a114h_robbery a113i_land_dispute a114i_land_dispute a113j_family_dispute a114j_family_dispute a113k_loss_cash a114k_loss_cash a113l_fall_price a114l_fall_price a113m_harvest a114m_harvest a113n_animal_ill a114n_animal_ill a113o_no_govt_benefit a114o_no_govt_benefit a113p_drinking a114p_drinking

local na a106_land_owned a107_a_land_cultivate a107_b_bighas a109_num_cards

recode `yesno' `na' a104_employ_type a103_social_grp a102_languange a010_urban a101_religion (".d"= 98) (".n"= 99) (".o"= 96) (-96=96)

label drop yesno q10 a103_social_grp a102_languange reli na

label define na 99 `"Not applicable"', modify

label define q10 0 `"Rural"', modify
label define q10 1 `"Urban"', modify
label define q10 99 `"Not applicable"', modify
label define yesno 0 `"No"', modify
label define yesno 1 `"Yes"', modify
label define yesno 98 `"Don't know"', modify
label define yesno 99 `"Not applicable"', modify

label define a103_social_grp 96 `"Others (specify)"', modify
label define a103_social_grp 1 `"Scheduled Tribe (ST)"', modify
label define a103_social_grp 2 `"Scheduled Caste (SC)"', modify
label define a103_social_grp 3 `"Other Backward Class/Caste (OBC)"', modify
label define a103_social_grp 4 `"General Class/Caste"', modify
label define a103_social_grp 98 `"Don’t know"', modify

label define a102_languange 96 `"Other (specify)"', modify
label define a102_languange 1 `"Hindi"', modify
label define a102_languange 2 `"Assamese"', modify
label define a102_languange 3 `"Bangla"', modify
label define a102_languange 4 `"Gujarathi"', modify
label define a102_languange 5 `"Marathi"', modify
label define a102_languange 6 `"Oriya"', modify
label define a102_languange 7 `"Kannad"', modify
label define a102_languange 8 `"Malyalam"', modify
label define a102_languange 9 `"Tamil Nadu"', modify
label define a102_languange 10 `"Telegu"', modify
label define a102_languange 11 `"English"', modify
label define a102_languange 12 `"Punjabi"', modify
label define a102_languange 13 `"Urdu"', modify
label define a102_languange 14 `"Marwadi"', modify
label define a102_languange 98 `"Don’t know"', modify

label define reli 1 `"Hinduism"', modify
label define reli 2 `"Islam"', modify
label define reli 3 `"Christian"', modify
label define reli 98 `"Don't know"', modify

label values `yesno' yesno
label values `na' na
label values a010_urban q10
label values a101_religion reli
label values a102_languange a102_languange
label values a103_social_grp a103_social_grp

save "ehsection1_relabelled.dta"