#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "ehsection1_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed

dropvars <- c("a115_hh_knwglwdge_mem", "a116_expenditure_active") 
mydata <- mydata[!names(mydata) %in% dropvars]

#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("a006_a_block_id", "a007_a_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata2 <- top_recode (variable="a106_land_owned", break_point=30, missing=NA)
mydata2 <- top_recode (variable="a107_a_land_cultivate", break_point=30, missing=NA)
mydata2 <- top_recode (variable="a107_b_bighas", break_point=15, missing=NA)
mydata <- top_recode (variable="a109_num_cards", break_point=3, missing=NA)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("a101_religion", 
                  "a102_languange", 
                  "a104_employ_type", 
                  "a105_hh_important_indus", 
                  "a105_hh_important_indus_oth", 
                  "a110_bank_po_ac", 
                  "a111j_aff_sequestrated", 
                  "a112j_res_sequestrated", 
                  "a112p_res_gen_othr")
capture_tables (indirect_PII)

# Recode those with very specific values. 

break_lan <- c(1,2,14)
labels_lan <- c("Hindi" =1, 
                "Other" =2, 
                "Marwadi" =3)
mydata <- ordinal_recode (variable="a102_languange", break_points=break_lan, missing=999999, value_labels=labels_lan)

break_rel <- c(1,2,3)
labels_rel <- c("Hinduism" =1, 
                "Islam" =2, 
                "Other" =3)
mydata2 <- ordinal_recode (variable="a101_religion", break_points=break_rel, missing=999999, value_labels=labels_rel)

dropvars <- c("a105_hh_important_indus", 
              "a105_hh_important_indus_oth", 
              "a111j_aff_sequestrated", 
              "a112j_res_sequestrated")
mydata <- mydata[!names(mydata) %in% dropvars] # Drop as strong identifier

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('a101_religion', 'a103_social_grp', 'a104_employ_type') ##!!! Replace with candidate categorical demo vars

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
selectedHouseholdID = c('hh_id') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)
                           
sdcInitial

#' Show values of key variable of records that violate k-anonymity
#mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"a104_employ_type"] <- NA

createSdcObj(dat = mydata, 
             keyVars = selectedKeyVars, 
             hhId = selectedHouseholdID)

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No further open-ends

#' #GPS data: Displace
# !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
