#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "bcsection4" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII

#' #Direct PII-team: Encode field team names
#' !!! No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
#' !!! No action as variables are critical for analysis

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("q401_work_sun", 
                  "q402_prob_light", 
                  "q403_noises", 
                  "q404_extr_temp", 
                  "q405_brick_indust", 
                  "q406_crushing", 
                  "q407_polishing", 
                  "q408_construction", 
                  "q409_loads", 
                  "q410_machinery", 
                  "q411_injured", 
                  "q412_toxic", 
                  "q413_masks", 
                  "q414_unwell", 
                  "q416_whether", 
                  "q417_desc_site", 
                  "q418_work_site", 
                  "q430_receiv_cash", 
                  "q431_receiv_skill", 
                  "q432_receiv_edu", 
                  "q433_receiv_shelt", 
                  "q434_receiv_medi", 
                  "q435_receiv_nothing", 
                  "q436_receiv_oth", 
                  "q436_receiv_oth_oth", 
                  "q437_part_parent")

capture_tables (indirect_PII)

#' !!! No action as variables are critical for analysis

#' #Open-ends: review responses for any sensitive information, redact as necessary

open_ends <- c("q416_whether_oth",
              "q417_desc_site_oth")

report_open (list_open_ends = open_ends)

# Drop all, as actually verbatim data in Hindi
mydata <- mydata[!names(mydata) %in% "q416_whether_oth"]
mydata <- mydata[!names(mydata) %in% "q417_desc_site_oth"]

#' #GPS data: Displace
#' !!! No GPS data
#'
#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
