*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\A_t1_Child_Availability"
use "A_t1_Child_Availability.dta", clear
*label save using mylabels.do

label define child_status 0 `"No"', modify
label define child_status 1 `"Yes"', modify
label define child_status 3 `"Child is Dead"', modify
label define child_status 98 `"Don't Know"', modify
label define child_status 999 `"Not Applicable"', modify
label define child_status 96 `"Others"', modify
label define child_location 1 `"Have gone to Relative’s place permanently"', modify
label define child_location 2 `"Have gone to Relative’s place for a month"', modify
label define child_location 3 `"Migrated to other location"', modify
label define child_location 98 `"Don't Know"', modify
label define child_location 999 `"Not Applicable"', modify
label define child_location 96 `"Others"', modify
label define missing 98 `"Don't Know"', modify
label define missing 999 `"Not Applicable"', modify
label define missing 96 `"Others"', modify
label define yesno 0 `"No"', modify
label define yesno 1 `"Yes"', modify
label define yesno 98 `"Don't Know"', modify
label define yesno 999 `"Not Applicable"', modify
label define yesno 96 `"Others"', modify

recode t1_a2_ch_present_status t1_a1_child_present t1_a3_ch_back t1_child_age t1_ch_consent t1_ch_age_aware t1_child_dob (".o"= 96) (".d"= 98) (".n"= 999)

label values t1_a3_ch_back t1_child_age missing
label values t1_a2_ch_present_status child_location
label values t1_a1_child_present child_status
label values t1_ch_consent t1_ch_age_aware t1_child_dob yesno

save "A_t1_Child_Availability_relabelled.dta"