*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\bhsection1"
use "bhsection1.dta", clear
*label save using mylabels.do

recode q104_employment q101_religion q103_social_grp (-96 = 96)

label drop q104_employment 
label define q104_employment 1 `"Self employed agriculture"', modify
label define q104_employment 2 `"Self employed nonagricultural"', modify
label define q104_employment 3 `"Regular wage / salary earning"', modify
label define q104_employment 4 `"Casual labor in agriculture"', modify
label define q104_employment 5 `"Casual labor in non-agriculture"', modify
label define q104_employment 6 `"Animal husbandary"', modify
label define q104_employment 96 `"Other (Specify)"', modify
label define q104_employment 99 `"Unclear information"', modify

label define q101_religion 1 `"Hinduism"', modify
label define q101_religion 2 `"Islam"', modify
label define q101_religion 3 `"Christianity"', modify
label define q101_religion 4 `"Sikhism"', modify
label define q101_religion 5 `"Jainism"', modify
label define q101_religion 6 `"Buddhism"', modify
label define q101_religion 96 `"Other"', modify

label define q103_social_grp 96 `"Others (specify)"', modify
label define q103_social_grp 1 `"Scheduled Tribe"', modify
label define q103_social_grp 2 `"Scheduled Caste"', modify
label define q103_social_grp 3 `"Other Backward Class/Caste"', modify
label define q103_social_grp 4 `"General Class/Caste"', modify

recode q106_own_land_bighas q107_culti_bighas (".d"= 98) (".n"= 99) (".o"= 96)
label define land 98 `"Don't Know"', modify
label define land 99 `"Don't know Collectively Owned"', modify
label values q106_own_land_bighas q107_culti_bighas land


save "bhsection1_relabelled.dta"