#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "bcsection5" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII

#' #Direct PII-team: Encode field team names
#' !!! No Direct PII-team
#' 
#' #Small locations: Encode locations  with pop <100,000 using random large numbers

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("q002_blckid", "q003_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
#' !!! No Indirect PII - Ordinal
#' 
#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

indirect_PII <- c("q506a_bicycle",
"q506b_mobile",
"q506c_jewelry",
"q506d_savings",
"q506e_machine",
"q506f_laptop",
"q506g_other_spcfy",
"q506g_other_access")

capture_tables (indirect_PII)

# Recode those with very specific values. 
#' !!! No action, low risk
#' 
#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!!Identify open-end variables here: 

open_ends <- c("q509_whom_become_7",
               "q509_whom_become_8",
               "q509_whom_become_9",
               "q509_whom_become_oth",
               "q512b_goal_step1",
               "q512b_goal_step2",
               "q512b_goal_step3",
               "q512c_goal_oth",
               "q512d_goal_step1",
               "q512d_goal_step2",
               "q512d_goal_step3",
               "q512g_like_know",
               "q514b_job_kind_oth",
               "q514c_amt_edu_oth",
               "q514d_high_edu_oth",
               "q514h_expect_travel_oth",
               "q514i_issues_oth")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
#' !!! Drop all, as actually verbatim data in Hindi

mydata <- mydata[!names(mydata) %in% "q509_whom_become_7"]
mydata <- mydata[!names(mydata) %in% "q509_whom_become_8"]
mydata <- mydata[!names(mydata) %in% "q509_whom_become_9"]
mydata <- mydata[!names(mydata) %in% "q509_whom_become_oth"]
mydata <- mydata[!names(mydata) %in% "q512b_goal_step1"]
mydata <- mydata[!names(mydata) %in% "q512b_goal_step2"]
mydata <- mydata[!names(mydata) %in% "q512b_goal_step3"]
mydata <- mydata[!names(mydata) %in% "q512c_goal_oth"]
mydata <- mydata[!names(mydata) %in% "q512d_goal_step1"]
mydata <- mydata[!names(mydata) %in% "q512d_goal_step2"]
mydata <- mydata[!names(mydata) %in% "q512d_goal_step3"]
mydata <- mydata[!names(mydata) %in% "q512g_like_know"]
mydata <- mydata[!names(mydata) %in% "q514b_job_kind_oth"]
mydata <- mydata[!names(mydata) %in% "q514c_amt_edu_oth"]
mydata <- mydata[!names(mydata) %in% "q514d_high_edu_oth"]
mydata <- mydata[!names(mydata) %in% "q514h_expect_travel_oth"]
mydata <- mydata[!names(mydata) %in% "q514i_issues_oth"]

#' #GPS data: Displace
#' !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
