*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\ehsection2"
use "ehsection2.dta", clear
*label save using mylabels.do

label define a209_09 98 `"Don't know"', modify
label define a209_09 999 `"Not applicable"', modify
label define a208 0 `"Not in labor force"', modify
label define a208 1 `"Unpaid Worker in Family Farm"', modify
label define a208 2 `"Unpaid Worker in Family Business"', modify
label define a208 3 `"Self Employed in Agriculture"', modify
label define a208 4 `"Self Employed in Outside of Agr"', modify
label define a208 5 `"Regular Wage or Salary Worker in Agr"', modify
label define a208 6 `"Regular Wage or Salary Worker Outside of Agr."', modify
label define a208 7 `"Skilled worker"', modify
label define a208 8 `"Daily labourer"', modify
label define a208 9 `"Paif household worker"', modify
label define a208 10 `"Pensioner"', modify
label define a208 11 `"Farm labourer"', modify
label define a208 12 `"Chef"', modify
label define a208 13 `"Priest"', modify
label define a207 0 `"Never Attended School"', modify
label define a207 1 `"Grade 1"', modify
label define a207 2 `"Grade 2"', modify
label define a207 3 `"Grade 3"', modify
label define a207 4 `"Grade 4"', modify
label define a207 5 `"Grade 5"', modify
label define a207 6 `"Grade 6"', modify
label define a207 7 `"Grade 7"', modify
label define a207 8 `"Grade 8"', modify
label define a207 9 `"Grade 9"', modify
label define a207 10 `"Grade 10"', modify
label define a207 11 `"Grade 11"', modify
label define a207 12 `"Grade 12"', modify
label define a207 13 `"University / Not Graduate"', modify
label define a207 14 `"University / Graduate"', modify
label define a207 15 `"Post Bachelors Tertiary Education"', modify
label define a207 16 `"Technical training"', modify
label define a207 17 `"Professional studies"', modify
label define a207 18 `"Pre-primary"', modify
label define a207 98 `"Don't know"', modify
label define a207 999 `"Not applicable"', modify
label define a206 1 `"Single/not committed"', modify
label define a206 2 `"Single, committed or engaged"', modify
label define a206 3 `"Currently Married and cohabitating"', modify
label define a206 4 `"Married but not cohabitating"', modify
label define a206 5 `"Divorced"', modify
label define a206 6 `"Widowed/Widower"', modify
label define a206 999 `"Not applicable"', modify
label define gender 0 `"Female"', modify
label define gender 1 `"Male"', modify
label define gender 999 `"Not applicable"', modify
label define a202c 0 `"Self"', modify
label define a202c 1 `"Father"', modify
label define a202c 2 `"Mother"', modify
label define a202c 3 `"Sister"', modify
label define a202c 4 `"Brother"', modify
label define a202c 5 `"Sister-in-law"', modify
label define a202c 6 `"Brother-in-law"', modify
label define a202c 7 `"Uncle"', modify
label define a202c 8 `"Maternal uncle"', modify
label define a202c 9 `"Maternal aunt"', modify
label define a202c 10 `"Grand father"', modify
label define a202c 11 `"Grand mother"', modify
label define a202c 12 `"Aunt"', modify
label define a202c 13 `"Father’s sister"', modify
label define a202c 14 `"Uncle (husband of father’s sister)"', modify
label define a202c 15 `"Grandfather (maternal )"', modify
label define a202c 16 `"Grandmother (maternal)"', modify
label define a202c 17 `"Aunt (mother’s sister)"', modify
label define a202c 18 `"Uncle (husband of mother’s sister)"', modify
label define a202c 19 `"Neice"', modify
label define a202c 20 `"Nephew"', modify
label define a202c 21 `"Cousin"', modify
label define a202c 22 `"Great grand mother"', modify
label define a202c 23 `"Unknown relation"', modify
label define a202c 24 `"Great grand father"', modify
label define a202c 25 `"Step mother"', modify
label define a202c 999 `"Not applicable"', modify
label define a202a 1 `"Household Head"', modify
label define a202a 2 `"Wife / husband of household head"', modify
label define a202a 3 `"Son of hosuehold head"', modify
label define a202a 4 `"Daughter of household head"', modify
label define a202a 5 `"Son-in-law of household head"', modify
label define a202a 6 `"Daughter-in-law household head"', modify
label define a202a 7 `"Father of household head"', modify
label define a202a 8 `"Mother of household head"', modify
label define a202a 9 `"Grandchild of household head"', modify
label define a202a 10 `"Brother of household head"', modify
label define a202a 11 `"Sister of household head"', modify
label define a202a 12 `"Grandfather of household head"', modify
label define a202a 13 `"Grandmother of household head"', modify
label define a202a 14 `"Neice of houshold head"', modify
label define a202a 15 `"Nephew of household head"', modify
label define a202a 16 `"Other relative"', modify
label define a202a 17 `"Adopted child of household head"', modify
label define a202a 18 `"Step-son of household head"', modify
label define a202a 19 `"Step-daughter of household head"', modify
label define a202a 20 `"Domestic employee of the household"', modify
label define a202a 21 `"Other employee of the household"', modify
label define a202a 22 `"Other non-relative member"', modify
label define a202a 23 `"Unknown"', modify
label define a202a 24 `"Father-in-law of household head"', modify
label define a202a 25 `"Mother-in-law of household head"', modify
label define a202a 26 `"Grand father-in-law of household head"', modify
label define a202a 27 `"Sister-in-law of household head"', modify
label define a202a 28 `"Brother-in-law of household head"', modify
label define a202a 29 `"Uncle of household head"', modify
label define a202a 30 `"Aunt of household head"', modify
label define a202a 31 `"Mother-in-law of household's child"', modify
label define a202a 32 `"Grand mother-in-law of household head"', modify
label define a202a 999 `"Not applicable"', modify
label define q10 0 `"Rural"', modify
label define q10 1 `"Urban"', modify
label define q10 999 `"Not applicable"', modify
label define yesno 0 `"No"', modify
label define yesno 1 `"Yes"', modify
label define yesno 98 `"Don't know"', modify
label define yesno 999 `"Not applicable"', modify


recode a202_a_hh_relation_ a202_c_girl_relation_1_ a202_c_girl_relation_2_ a202_c_girl_relation_3_ a206_relation_ a207_complete_edu_ a208_employ_status_ a203_age_ a209_hr_spent_employ_ a210_income_ a213_amt_paid_ a214_schl_edu_fess_ a215_days_to_schl_ a216_schl_open_ a217_hr_collect_activities_ a218_hr_hh_chores_ a204_gender_ a010_urban a202_b_girl_caregiver_1_ a202_b_girl_caregiver_2_ a202_b_girl_caregiver_3_ a202_d_person_listed_ a205_under_6_yrs_ a211_18_yrs_age_ a212_attd_schl_collge_ (".d"= 98) (".n"= 999)

label values a202_b_girl_caregiver_1_ a202_b_girl_caregiver_2_ a202_b_girl_caregiver_3_ a202_d_person_listed_ a205_under_6_yrs_ a211_18_yrs_age_ a212_attd_schl_collge_ yesno
label values a010_urban q10
label values a204_gender_ gender
label values a203_age_ a209_hr_spent_employ_ a210_income_ a213_amt_paid_ a214_schl_edu_fess_ a215_days_to_schl_ a216_schl_open_ a217_hr_collect_activities_ a218_hr_hh_chores_ a209_09 
label values a208_employ_status_ a208
label values a207_complete_edu_ a207
label values a206_relation_ a206
label values a202_c_girl_relation_1_ a202_c_girl_relation_2_ a202_c_girl_relation_3_ a202c
label values a202_a_hh_relation_ a202a

save "ehsection2_relabelled.dta"
