#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "ehsection2_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII
#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("a006_a_block_id", "a007_a_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata <- top_recode (variable="a203_age_", break_point=80, missing=NA)
mydata <- top_recode (variable="a210_income_", break_point=8000, missing=NA)
mydata <- top_recode (variable="a213_amt_paid_", break_point=15000, missing=NA)
mydata <- top_recode (variable="a214_schl_edu_fess_", break_point=20000, missing=NA)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("a206_relation_",
                  "a207_complete_edu_",
                  "a208_employ_status_")
capture_tables (indirect_PII)

# Recode those with very specific values. 

break_rel <- c(1,2,3,4,5,99)
labels_rel <- c("Single/not committed" =1, 
                "Single, committed or engaged" =2, 
                "Currently Married and cohabitating" =3, 
                "Married but not cohabitating" =4, 
                "Divorced/Widowed/Widower" =5)
mydata <- ordinal_recode (variable="a206_relation_", break_points=break_rel, missing=999999, value_labels=labels_rel)

val_labels(mydata$a207_complete_edu_)
break_edu <- c(0:14,18,19)
labels_edu <- c("Never Attended School or Only Attended Pre-School" = 1,
                "Grade 1" = 2,
                "Grade 2" = 3,
                "Grade 3" = 4,
                "Grade 4" = 5,
                "Grade 5" = 6,
                "Grade 6" = 7,
                "Grade 7" = 8,
                "Grade 8" = 9,
                "Grade 9" = 10,
                "Grade 10" = 11,
                "Grade 11" = 12,
                "Grade 12" = 13,
                "University / Not Graduate" = 14,
                "University / Graduate or higher" = 15,
                "Below primary" = 16)
mydata <- ordinal_recode (variable="a207_complete_edu_", 
                          break_points=break_edu, 
                          missing=999999, 
                          value_labels=labels_edu)

val_labels(mydata$a208_employ_status_)
break_edu <- c(0:9,11,12)
labels_edu <- c("Not in labor force" = 0,
                "Unpaid Worker in Family Farm" = 1,
                "Unpaid Worker in Family Business" = 2,
                "Self Employed in Agriculture" = 3,
                "Self Employed in Outside of Agr" = 4,
                "Regular Wage or Salary Worker in Agr" = 5,
                "Regular Wage or Salary Worker Outside of Agr" = 6,
                "Skilled worker" = 7,
                "Daily labourer" = 8,
                "Other" = 9,
                "Farm Labourer" = 10,
                "Other" = 11)
mydata <- ordinal_recode (variable="a208_employ_status_", 
                          break_points=break_edu, 
                          missing=999999, 
                          value_labels=labels_edu)

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('a204_gender_', 'a203_age_', 'a207_complete_edu_') ##!!! Replace with candidate categorical demo vars

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
selectedHouseholdID = c('hh_id') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)
                           
sdcInitial

#' Show values of key variable of records that violate k-anonymity
#mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"a203_age_"][mydata[notAnon,"a203_age_"]>17] <- NA

sdcInitial <- createSdcObj(dat = mydata, 
                           keyVars = selectedKeyVars, 
                           hhId = selectedHouseholdID)

#mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"a204_gender_"] <- NA

createSdcObj(dat = mydata, 
             keyVars = selectedKeyVars, 
             hhId = selectedHouseholdID)


#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No open-ends

#' #GPS data: Displace
# !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
