*** Stata label pre-processing
* Author: Pablo Diego-Rosell, PhD
* Email: "pablo_diego_rosell@yahoo.com"

cd "C:\QC\B_t2_schooling"
use "B_t2_schooling.dta", clear
*label save using mylabels.do

label define _merge 1 `"master only (1)"', modify
label define _merge 2 `"using only (2)"', modify
label define _merge 3 `"matched (3)"', modify
label define _merge 4 `"missing updated (4)"', modify
label define _merge 5 `"nonmissing conflict (5)"', modify
label define status 1 `"complete"', modify
label define status 2 `"no one was at home"', modify
label define status 3 `"partial"', modify
label define status 4 `"refused"', modify
label define status 5 `"household not found"', modify
label define status 6 `"household migrated"', modify
label define status 7 `"child migrated permanently"', modify
label define status 8 `"child migrated temporarily"', modify
label define status 9 `"child is dead"', modify
label define status 10 `"complete-child migrated"', modify
label define status 11 `"complete-household migrated"', modify
label define status 12 `"child mentally challenged"', modify
label define status 13 `"Others"', modify

recode bl_t1 bl_t1_t2 bl_t1_t2_ad1 t2_status (".o"= 96) (".d"= 98) (".n"= 999)

label values bl_t1 bl_t1_t2 bl_t1_t2_ad1 _merge
label values t2_status status

save "B_t2_schooling_relabelled.dta"

cd "C:\QC\B_t2_schooling"
import spss "B_t2_schooling_relabelled_PU.sav", clear
savespss "B_t2_schooling_relabelled_PU.sav", replace
