#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "B_t2_schooling_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!!Include any Direct PII variables

dropvars <- c("t2_b3_b_schl_name_17_18") 
mydata <- mydata[!names(mydata) %in% dropvars]

#' #Direct PII-team: Encode field team names
# !!!No Direct PII-team

#' #Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Recode school schedules into groups

table(mydata$t2_b6_hr_schl_attend_from)
mydata$t2_b6_hr_schl_attend_from <- labelled(mydata$t2_b6_hr_schl_attend_from, c("1:00:00 PM" ="1:00:00 PM" ,
                                                                           "10:00:00 AM"="10:00:00 AM",
                                                                           "10:15:00 AM"="10:15:00 AM",
                                                                           "12:00:00 PM"="12:00:00 PM",
                                                                           "12:30:00 PM"="12:30:00 PM",
                                                                           "3:30:00 PM"="3:30:00 PM",
                                                                           "7:00:00 AM"="7:00:00 AM",
                                                                           "7:30:00 AM"="7:30:00 AM",
                                                                           "8:00:00 AM"="8:00:00 AM",
                                                                           "8:18:00 AM"="8:18:00 AM",
                                                                           "8:30:00 AM"="8:30:00 AM",
                                                                           "8:35:00 AM"="8:35:00 AM",
                                                                           "8:45:00 AM"="8:45:00 AM",
                                                                           "9:00:00 AM"="9:00:00 AM",
                                                                           "9:01:00 AM"="9:01:00 AM",
                                                                           "9:05:00 AM"="9:05:00 AM",
                                                                           "9:10:00 AM"="9:10:00 AM",
                                                                           "9:13:00 AM"="9:13:00 AM",
                                                                           "9:15:00 AM"="9:15:00 AM",
                                                                           "9:20:00 AM"="9:20:00 AM",
                                                                           "9:25:00 AM"="9:25:00 AM",
                                                                           "9:29:00 AM"="9:29:00 AM",
                                                                           "9:30:00 AM"="9:30:00 AM",
                                                                           "9:32:00 AM"="9:32:00 AM",
                                                                           "9:35:00 AM"="9:35:00 AM",
                                                                           "9:40:00 AM"="9:40:00 AM",
                                                                           "9:45:00 AM"="9:45:00 AM"))

mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "7:00:00 AM"] <- "6:01:00-7:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "7:30:00 AM"] <- "7:01:00-8:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "8:00:00 AM"] <- "7:01:00-8:00:00 AM"

mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "8:18:00 AM"] <- "8:01:00-9:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "8:30:00 AM"] <- "8:01:00-9:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "8:35:00 AM"] <- "8:01:00-9:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "8:45:00 AM"] <- "8:01:00-9:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:00:00 AM"] <- "8:01:00-9:00:00 AM"

mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:01:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:05:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:10:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:13:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:15:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:20:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:25:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:29:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:30:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:32:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:35:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:40:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "9:45:00 AM"] <- "9:01:00-10:00:00 AM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "10:00:00 AM"] <- "9:01:00-10:00:00 AM"

mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "10:15:00 AM"] <- "10:01:00-11:00:00 AM"

mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "12:00:00 PM"] <- "11:01:00 AM-12:00:00 PM"


mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "12:30:00 PM"] <- "12:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "1:00:00 PM"] <- "12:01:00-4:00:00 PM"



mydata$t2_b6_hr_schl_attend_from[mydata$t2_b6_hr_schl_attend_from == "3:30:00 PM"] <- "12:01:00-4:00:00 PM"
table(mydata$t2_b6_hr_schl_attend_from)

table(mydata$t2_b6_hr_schl_attend_to)
mydata$t2_b6_hr_schl_attend_to <- labelled(mydata$t2_b6_hr_schl_attend_to, c("9:30:00 AM"="9:30:00 AM",
                                                                                 "10:40:00 AM"="10:40:00 AM",
                                                                                 "11:00:00 AM"="11:00:00 AM",
                                                                                 "12:00:00 PM"="12:00:00 PM",
                                                                                 "12:30:00 PM"="12:30:00 PM",
                                                                             "1:00:00 PM" ="1:00:00 PM",
                                                                             "1:30:00 PM" ="1:30:00 PM",
                                                                             "1:40:00 PM" ="1:40:00 PM",
                                                                             "2:00:00 PM"="2:00:00 PM",
                                                                             "2:10:00 PM"="2:10:00 PM",
                                                                             "2:25:00 PM"="2:25:00 PM",
                                                                             "2:30:00 PM"="2:30:00 PM",
                                                                             "2:40:00 PM"="2:40:00 PM",
                                                                             "3:00:00 PM"="3:00:00 PM",
                                                                             "3:10:00 PM"="3:10:00 PM",
                                                                             "3:15:00 PM"="3:15:00 PM",
                                                                             "3:16:00 PM"="3:16:00 PM",
                                                                             "3:20:00 PM"="3:20:00 PM",
                                                                             "3:24:00 PM"="3:24:00 PM",
                                                                             "3:25:00 PM"="3:25:00 PM",
                                                                             "3:27:00 PM"="3:27:00 PM",
                                                                            "3:30:00 PM"="3:30:00 PM",
                                                                             "3:35:00 PM"="3:35:00 PM",
                                                                             "3:40:00 PM"="3:40:00 PM",
                                                                             "3:45:00 PM"="3:45:00 PM",
                                                                             "3:50:00 PM"="3:50:00 PM",
                                                                             "4:00:00 PM"="4:00:00 PM",
                                                                             "4:10:00 PM"="4:10:00 PM",
                                                                             "4:15:00 PM"="4:15:00 PM",
                                                                             "4:16:00 PM"="4:16:00 PM",
                                                                             "4:20:00 PM"="4:20:00 PM",
                                                                             "4:25:00 PM"="4:25:00 PM",
                                                                             "4:30:00 PM"="4:30:00 PM",
                                                                             "4:38:00 PM"="4:38:00 PM",
                                                                             "4:40:00 PM"="4:40:00 PM",
                                                                             "4:52:00 PM"="4:52:00 PM",
                                                                             "5:00:00 PM"="5:00:00 PM",
                                                                             "5:30:00 PM"="5:30:00 PM",
                                                                             "6:00:00 PM"="6:00:00 PM"))

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "9:30:00 AM"] <- "9:01:00 AM-12:00:00 PM"


mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "10:40:00 AM"] <- "9:01:00 AM-12:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "11:00:00 AM"] <- "9:01:00 AM-12:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "12:00:00 PM"] <- "9:01:00 AM-12:00:00 PM"


mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "12:30:00 PM"] <- "12:01:00-1:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "1:00:00 PM"] <- "12:01:00-1:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "1:30:00 PM"] <- "1:01:00-2:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "1:40:00 PM"] <- "1:01:00-2:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "2:00:00 PM"] <- "1:01:00-2:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "2:10:00 PM"] <- "2:01:00-3:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "2:25:00 PM"] <- "2:01:00-3:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "2:30:00 PM"] <- "2:01:00-3:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "2:40:00 PM"] <- "2:01:00-3:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:00:00 PM"] <- "2:01:00-3:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:10:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:15:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:16:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:20:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:24:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:25:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:27:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:30:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:35:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:40:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:10:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:45:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "3:50:00 PM"] <- "3:01:00-4:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:00:00 PM"] <- "3:01:00-4:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:10:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:15:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:16:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:20:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:25:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:30:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:38:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:40:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "4:52:00 PM"] <- "4:01:00-5:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "5:00:00 PM"] <- "4:01:00-5:00:00 PM"

mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "5:30:00 PM"] <- "5:01:00-10:00:00 PM"
mydata$t2_b6_hr_schl_attend_to[mydata$t2_b6_hr_schl_attend_to == "6:00:00 PM"] <- "5:01:00-10:00:00 PM"

table(mydata$t2_b6_hr_schl_attend_to)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("t2_b3_a_same_schl_16_17",
                  "t2_b3_a_same_schl_17_18"
)

capture_tables (indirect_PII)

#' #Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No Open-Ends
#
#' #GPS data: Displace
# !!!No GPS data
#
#' #Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
