#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames, data, functions and create dictionary for dataset review

filename <- "ehsection5" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#' #Direct PII: variables to be removed
# !!! No Direct PII
#' #Direct PII-team: Encode field team names
# !!! No Direct PII-team
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
#'  !!!Include relevant variables, but check their population size first to confirm they are <100,000

dropvars <- c("dise") 
mydata <- mydata[!names(mydata) %in% dropvars]

locvars <- c("a006_a_block_id", "a007_a_vill_id") 
mydata <- encode_location (variables= locvars, missing=999999)

#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata <- top_recode (variable="a501_cereal", break_point=12000, missing=NA)
mydata <- top_recode (variable="a502_pulse", break_point=percentile_checker ("a502_pulse"), missing=NA)
mydata <- top_recode (variable="a503_milk", break_point=percentile_checker ("a503_milk"), missing=NA)
mydata <- top_recode (variable="a504_milk_prod", break_point=percentile_checker ("a504_milk_prod"), missing=NA)
mydata <- top_recode (variable="a505_edible_oil", break_point=8000, missing=NA)
mydata <- top_recode (variable="a506_vegetable", break_point=percentile_checker ("a506_vegetable"), missing=NA)
mydata <- top_recode (variable="a507_fruit", break_point=percentile_checker ("a507_fruit"), missing=NA)
mydata <- top_recode (variable="a508_egg", break_point=3500, missing=NA)
mydata <- top_recode (variable="a509_honey", break_point=percentile_checker ("a509_honey"), missing=NA)
mydata <- top_recode (variable="a510_salt", break_point=7000, missing=NA)
mydata <- top_recode (variable="a511_other_food", break_point=3000, missing=NA)
mydata <- top_recode (variable="a512_pan", break_point=percentile_checker ("a512_pan"), missing=NA)
mydata <- top_recode (variable="a513_fuel", break_point=9000, missing=NA)
mydata <- top_recode (variable="a514_cinema", break_point=2000, missing=NA)
mydata <- top_recode (variable="a515_torch", break_point=2000, missing=NA)
mydata <- top_recode (variable="a516_toilet", break_point=3000, missing=NA)
mydata <- top_recode (variable="a517_bulb", break_point=4000, missing=NA)
mydata <- top_recode (variable="a518_consu_service", break_point=50000, missing=NA)
mydata <- top_recode (variable="a519_petrol", break_point=30000, missing=NA)
mydata <- top_recode (variable="a520_rent", break_point=percentile_checker ("a520_rent"), missing=NA)
mydata <- top_recode (variable="a521_taxes", break_point=4500, missing=NA)
mydata <- top_recode (variable="a522_medical_expenses", break_point=42000, missing=NA)
mydata <- top_recode (variable="a523_medical", break_point=350000, missing=NA)
mydata <- top_recode (variable="a524_tution", break_point=60000, missing=NA)
mydata <- top_recode (variable="a525_schl_book", break_point=percentile_checker ("a525_schl_book"), missing=NA)
mydata <- top_recode (variable="a526_cloth", break_point=60000, missing=NA)
mydata <- top_recode (variable="a527_footwear", break_point=16000, missing=NA)
mydata <- top_recode (variable="a528_furniture", break_point=40000, missing=NA)
mydata <- top_recode (variable="a529_crockery", break_point=percentile_checker ("a529_crockery"), missing=NA)
mydata <- top_recode (variable="a530_cooking", break_point=30000, missing=NA)
mydata <- top_recode (variable="a531_tv_radio", break_point=17000, missing=NA)
mydata <- top_recode (variable="a532_jewelry", break_point=450000, missing=NA)
mydata <- top_recode (variable="a533_transport", break_point=500000, missing=NA)
mydata <- top_recode (variable="a534_hearing_aids", 3000, missing=NA)
mydata <- top_recode (variable="a535_oth_pers_good", 20000, missing=NA)
mydata <- top_recode (variable="a536_repairs", break_point=percentile_checker ("a536_repairs"), missing=NA)
mydata <- top_recode (variable="a525_schl_book", break_point=20000, missing=NA)

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!! No Indirect PII categorical

#' #Matching and crosstabulations: Run automated PII check 
# !!! No direct demographic variables available in dataset

#' #Open-ends: review responses for any sensitive information, redact as necessary
# !!! No open-ends

#' #GPS data: Displace
# !!! No GPS data
#' 
#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
