#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_4" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("ec_s4q10",
               "ec_s4q12",
               "ec_s4q20",
               "ec_s4q22",
               "ec_s4q24",
               "ec_s4q27",
               "ec_s4q49",
               "ec_s4q76")

report_open (list_open_ends = open_ends)


# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$ec_s4q10[9] <- "[language]"
mydata$ec_s4q10[600] <- "[language]"
mydata$ec_s4q10[1112] <- "[language]"
mydata$ec_s4q10[1151] <- "[language]"
mydata$ec_s4q10[1264] <- "[language]"
mydata$ec_s4q10[1494] <- "[language]"
mydata$ec_s4q10[1838] <- "[language]"
mydata$ec_s4q10[2155] <- "[language]"
mydata$ec_s4q10[2284] <- "[language]"
mydata$ec_s4q10[3229] <- "[language]"

mydata$ec_s4q10[894] <- "To go to Mall"
mydata$ec_s4q10[917] <- "To visit her granmother in [province]"
mydata$ec_s4q10[3583] <- "She wants to practice dancing for her graduation on [date]"

mydata$ec_s4q12[9] <- "[language]"
mydata$ec_s4q12[688] <- "[language]"
mydata$ec_s4q12[1151] <- "[language]"
mydata$ec_s4q12[1264] <- "[language]"
mydata$ec_s4q12[1494] <- "[language]"
mydata$ec_s4q12[1762] <- "[language]"
mydata$ec_s4q12[1838] <- "[language]"
mydata$ec_s4q12[2155] <- "[language]"
mydata$ec_s4q12[2284] <- "[language]"

mydata$ec_s4q20[100] <- "[language]"
mydata$ec_s4q20[2146] <- "[language]"
mydata$ec_s4q20[2540] <- "[language]"
mydata$ec_s4q20[2668] <- "[language]"

# !!!Removed, as it contains sensitive information 
mydata <- mydata[!names(mydata) %in% "ec_s4q49"] 
mydata <- mydata[!names(mydata) %in% "ec_s4q76"]


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
