#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_8" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)


#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small Locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
#!!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("eh_s8q1",
                  "eh_s8q2",
                  "eh_s8q3",
                  "eh_s8q4",
                  "eh_s8q5",
                  "eh_s8q6",
                  "eh_s8q7",
                  "eh_s8q8",
                  "eh_s8q9",
                  "eh_s8q10",
                  "eh_s8q11",
                  "eh_s8q12",
                  "eh_s8q13",
                  "eh_s8q14",
                  "eh_s8q15",
                  "eh_s8q16",
                  "eh_s8q29",
                  "eh_s8q30",
                  "eh_s8q32",
                  "eh_s8q33")

capture_tables (indirect_PII)


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 

open_ends <- c("eh_s8q31",
               "eh_s8q34")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$eh_s8q31[1575] <- "[language]"
mydata$eh_s8q31[1580] <- "[language]"
mydata$eh_s8q31[1680] <- "[language]"
mydata$eh_s8q31[1715] <- "[language]"
mydata$eh_s8q31[1796] <- "[language]"
mydata$eh_s8q31[1799] <- "[language]"
mydata$eh_s8q31[2208] <- "[language]"
mydata$eh_s8q31[2252] <- "[language]"
mydata$eh_s8q31[2369] <- "[language]"
mydata$eh_s8q31[2406] <- "[language]"
mydata$eh_s8q31[3053] <- "[language]"
mydata$eh_s8q31[3289] <- "[language]"
mydata$eh_s8q31[3594] <- "[language]"
mydata$eh_s8q31[3680] <- "[language]"
mydata$eh_s8q31[3682] <- "[language]"
mydata$eh_s8q31[3836] <- "[language]"
mydata$eh_s8q31[4351] <- "[language]"
mydata$eh_s8q31[4843] <- "[language]"
mydata$eh_s8q31[4857] <- "[language]"
mydata$eh_s8q31[5212] <- "[language]"
mydata$eh_s8q31[6941] <- "[language]"
mydata$eh_s8q31[8190] <- "[language]"
mydata$eh_s8q31[8195] <- "[language]"
mydata$eh_s8q31[9662] <- "President of [place]"
mydata$eh_s8q31[3652] <- "President of [place]"


mydata$eh_s8q34[2369] <- "[language]"
mydata$eh_s8q34[3594] <- "[language]"
mydata$eh_s8q34[3652] <- "[language]"
mydata$eh_s8q34[3680] <- "[language]"
mydata$eh_s8q34[4857] <- "[language]"
mydata$eh_s8q34[7675] <- "[language]"

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
