#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_2" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)


#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical

indirect_PII <- c("ec_s2q1",
                  "ec_s2q4",
                  "ec_s2q7",
                  "ec_s2q10",
                  "ec_s2q13",
                  "ec_s2q16",
                  "ec_s2q19",
                  "ec_s2q22",
                  "ec_s2q25",
                  "ec_s2q28",
                  "ec_s2q31",
                  "ec_s2q34",
                  "ec_s2q37",
                  "ec_s2q40",
                  "ec_s2q43",
                  "ec_s2q46",
                  "ec_s2q49",
                  "ec_s2q52",
                  "ec_s2q54",
                  "ec_s2q56",
                  "ec_s2q58",
                  "ec_s2q62",
                  "ec_s2q63",
                  "ec_s2q65",
                  "ec_s2q66",
                  "ec_s2q67",
                  "ec_s2q68")

capture_tables(indirect_PII)

# Recode those with very specific values. 
# !!!No specific values

#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("ec_s2q53",
              "ec_s2q55",
              "ec_s2q57",
              "ec_s2q59")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$ec_s2q53[787] <- "[language]"
mydata$ec_s2q53[1240] <- "[language]"
mydata$ec_s2q53[1336] <- "[language]"
mydata$ec_s2q53[1828] <- "[language]"
mydata$ec_s2q53[1875] <- "[language]"
mydata$ec_s2q53[2119] <- "[language]"
mydata$ec_s2q53[2195] <- "[language]"
mydata$ec_s2q53[2434] <- "[language]"
mydata$ec_s2q53[2445] <- "[language]"
mydata$ec_s2q53[2483] <- "[language]"
mydata$ec_s2q53[2536] <- "[language]"
mydata$ec_s2q53[2537] <- "[language]"
mydata$ec_s2q53[2755] <- "[language]"
mydata$ec_s2q53[2812] <- "[language]"
mydata$ec_s2q53[2898] <- "[language]"
mydata$ec_s2q53[3005] <- "[language]"
mydata$ec_s2q53[3119] <- "[language]"
mydata$ec_s2q53[3211] <- "[language]"
mydata$ec_s2q53[3223] <- "[language]"
mydata$ec_s2q53[3225] <- "[language]"
mydata$ec_s2q53[3282] <- "[language]"
mydata$ec_s2q53[3925] <- "[language]"
mydata$ec_s2q53[4082] <- "[language]"
mydata$ec_s2q53[4143] <- "[language]"

mydata$ec_s2q55[97] <- "[language]"
mydata$ec_s2q55[966] <- "[language]"
mydata$ec_s2q55[1108] <- "[language]"
mydata$ec_s2q55[1240] <- "[language]"
mydata$ec_s2q55[1276] <- "[language]"
mydata$ec_s2q55[1406] <- "[language]"
mydata$ec_s2q55[1448] <- "[language]"
mydata$ec_s2q55[1875] <- "[language]"
mydata$ec_s2q55[2434] <- "[language]"
mydata$ec_s2q55[2445] <- "[language]"
mydata$ec_s2q55[2537] <- "[language]"
mydata$ec_s2q55[2755] <- "[language]"
mydata$ec_s2q55[2812] <- "[language]"
mydata$ec_s2q55[2883] <- "[language]"
mydata$ec_s2q55[3199] <- "[language]"
mydata$ec_s2q55[3925] <- "[language]"
mydata$ec_s2q55[4082] <- "[language]"
mydata$ec_s2q55[4086] <- "[language]"

mydata$ec_s2q57[275] <- "[language]"
mydata$ec_s2q57[1035] <- "[language]"
mydata$ec_s2q57[1653] <- "[language]"
mydata$ec_s2q57[2196] <- "[language]"
mydata$ec_s2q57[2299] <- "[language]"
mydata$ec_s2q57[2764] <- "[language]"
mydata$ec_s2q57[2929] <- "[language]"
mydata$ec_s2q57[2931] <- "[language]"
mydata$ec_s2q57[4449] <- "[language]"

mydata$ec_s2q59[1653] <- "[language]"
mydata$ec_s2q59[1915] <- "[language]"
mydata$ec_s2q59[2006] <- "[language]"
mydata$ec_s2q59[2135] <- "[language]"
mydata$ec_s2q59[2283] <- "[language]"
mydata$ec_s2q59[2479] <- "[language]"
mydata$ec_s2q59[3515] <- "[language]"
mydata$ec_s2q59[3625] <- "[language]"



#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
