#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_11" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

# Top code high income to the 99.5 percentile

percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q3)[na.exclude(mydata$eh_s11q3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q4)[na.exclude(mydata$eh_s11q4)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q4", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q6)[na.exclude(mydata$eh_s11q6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q7)[na.exclude(mydata$eh_s11q7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q9)[na.exclude(mydata$eh_s11q9)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q9", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q10)[na.exclude(mydata$eh_s11q10)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q10", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q12)[na.exclude(mydata$eh_s11q12)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q12", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q13)[na.exclude(mydata$eh_s11q13)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q13", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q15)[na.exclude(mydata$eh_s11q15)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q15", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q16)[na.exclude(mydata$eh_s11q16)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q16", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q18)[na.exclude(mydata$eh_s11q18)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q18", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q19)[na.exclude(mydata$eh_s11q19)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q19", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q21)[na.exclude(mydata$eh_s11q21)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q21", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q22)[na.exclude(mydata$eh_s11q22)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q22", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q24)[na.exclude(mydata$eh_s11q24)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q24", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q26)[na.exclude(mydata$eh_s11q26)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q26", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q27)[na.exclude(mydata$eh_s11q27)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q27", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q28)[na.exclude(mydata$eh_s11q28)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q28", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q30)[na.exclude(mydata$eh_s11q30)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q30", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q32)[na.exclude(mydata$eh_s11q32)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q32", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q33)[na.exclude(mydata$eh_s11q33)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q33", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q34)[na.exclude(mydata$eh_s11q34)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q34", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q36)[na.exclude(mydata$eh_s11q36)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q36", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q38)[na.exclude(mydata$eh_s11q38)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q38", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q39)[na.exclude(mydata$eh_s11q39)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q39", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q40)[na.exclude(mydata$eh_s11q40)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q40", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q42)[na.exclude(mydata$eh_s11q42)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q42", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q44)[na.exclude(mydata$eh_s11q44)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q44", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q45)[na.exclude(mydata$eh_s11q45)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q45", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q46)[na.exclude(mydata$eh_s11q46)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q46", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$eh_s11q48)[na.exclude(mydata$eh_s11q48)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="eh_s11q48", break_point=percentile_99.5, missing=999999)

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("eh_s11q1",
                  "eh_s11q2",
                  "eh_s11q5",
                  "eh_s11q8",
                  "eh_s11q11",
                  "eh_s11q14",
                  "eh_s11q17",
                  "eh_s11q20",
                  "eh_s11q23",
                  "eh_s11q25",
                  "eh_s11q29",
                  "eh_s11q31",
                  "eh_s11q35",
                  "eh_s11q37",
                  "eh_s11q41",
                  "eh_s11q43",
                  "eh_s11q47")

capture_tables (indirect_PII)

# Recode those with very specific values. 
# !!!No very specific values


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
# !!!No Open-ends


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
