#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_0" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)


#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("eh_s0q8","eh_s0q18") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("eh_s0q30",
                  "eh_s0q35",
                  "eh_s0q38")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_reason <- c(1,2,5)
labels_reason <- c("At work" = 1,
                "Other - specify" = 2,
                "Other - specify" = 3)
mydata <- ordinal_recode (variable="eh_s0q30", break_points=break_reason, missing=999999, value_labels=labels_reason)


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("eh_s0q17",
               "eh_s0q19",
               "eh_s0q31",
               "eh_s0q36",
               "eh_s0q40")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$eh_s0q19[226] <- "[municipality]"
mydata$eh_s0q19[528] <- "[municipality]"
mydata$eh_s0q19[547] <- "[municipality]"
mydata$eh_s0q19[642] <- "[municipality]"
mydata$eh_s0q19[736] <- "[municipality]"
mydata$eh_s0q19[813] <- "[municipality]"
mydata$eh_s0q19[867] <- "[municipality]"
mydata$eh_s0q19[905] <- "[municipality]"
mydata$eh_s0q19[1023] <- "[municipality]"

mydata$eh_s0q31[22] <- "[other]"
mydata$eh_s0q31[47] <- "[other]"
mydata$eh_s0q31[85] <- "[other]"
mydata$eh_s0q31[126] <- "[other]"
mydata$eh_s0q31[136] <- "[other]"
mydata$eh_s0q31[196] <- "[other]"
mydata$eh_s0q31[233] <- "[other]"
mydata$eh_s0q31[238] <- "[other]"
mydata$eh_s0q31[259] <- "[other]"
mydata$eh_s0q31[278] <- "[other]"
mydata$eh_s0q31[294] <- "[other]"
mydata$eh_s0q31[295] <- "[other]"
mydata$eh_s0q31[333] <- "[other]"
mydata$eh_s0q31[348] <- "[other]"
mydata$eh_s0q31[379] <- "[other]"
mydata$eh_s0q31[396] <- "[other]"
mydata$eh_s0q31[617] <- "[other]"
mydata$eh_s0q31[628] <- "[other]"
mydata$eh_s0q31[632] <- "[other]"
mydata$eh_s0q31[728] <- "[other]"
mydata$eh_s0q31[904] <- "[other]"
mydata$eh_s0q31[920] <- "[other]"
mydata$eh_s0q31[978] <- "[other]"
mydata$eh_s0q31[1010] <- "[other]"
mydata$eh_s0q31[1020] <- "[other]"
mydata$eh_s0q31[1086] <- "[other]"
mydata$eh_s0q31[1121] <- "[other]"
mydata$eh_s0q31[1165] <- "[other]"
mydata$eh_s0q31[1195] <- "[other]"
mydata$eh_s0q31[1250] <- "[other]"
mydata$eh_s0q31[1361] <- "[other]"
mydata$eh_s0q31[1364] <- "[other]"
mydata$eh_s0q31[1380] <- "[other]"
mydata$eh_s0q31[1428] <- "[other]"
mydata$eh_s0q31[1441] <- "[other]"
mydata$eh_s0q31[1444] <- "[other]"
mydata$eh_s0q31[1770] <- "[other]"
mydata$eh_s0q31[1903] <- "[other]"
mydata$eh_s0q31[2014] <- "[other]"
mydata$eh_s0q31[2137] <- "[other]"

mydata$eh_s0q40[22] <- "The baseline respondent together with her other children is in [city] because her daughter will give birth."
mydata$eh_s0q40[346] <- "[name] is currently  working overseas"
mydata$eh_s0q40[573] <- "The respondent [name]is busy t his work no time to be interviewed"
mydata$eh_s0q40[603] <- "Her husband [name] is busy at the  farm no time for interview"
mydata$eh_s0q40[806] <- "Live before at the upper part of brgy [neighborhood name]"
mydata$eh_s0q40[819] <- "The respondent is the husband of [name]"
mydata$eh_s0q40[958] <- "The interview was done at the brgy [site] since the respondent could not go home because of her work."
mydata$eh_s0q40[990] <- "Interview  the wife of [names]"
mydata$eh_s0q40[1004] <- "She is with her 2 year old son, [name]."
mydata$eh_s0q40[1053] <- "Near [site]"
mydata$eh_s0q40[1118] <- "Address: [address] Correct name; [name]"
mydata$eh_s0q40[1171] <- "Correct name: [name]"
mydata$eh_s0q40[1235] <- "[name] is working abroad ([country])"
mydata$eh_s0q40[1262] <- "Land mark:[land mark]"
mydata$eh_s0q40[1263] <- "Near the house of the late Barangay [barangay name] at Sitio [site]"
mydata$eh_s0q40[1287] <- "Sitio [site] at the back of Barangay Hall"
mydata$eh_s0q40[1313] <- "[name] is not available during interview."
mydata$eh_s0q40[1322] <- "Sitio [site]  "
mydata$eh_s0q40[1324] <- "Sitio [site]"
mydata$eh_s0q40[1326] <- "[site]"
mydata$eh_s0q40[1328] <- "Correct name [name]"
mydata$eh_s0q40[1334] <- "[name] is not available right now,his Wife is [name]who was the respondent in baseline and midline"
mydata$eh_s0q40[1342] <- "The respondent got married to her new husband..so that her new surname is [name]."
mydata$eh_s0q40[1343] <- "The baseline is not available and working in [site]and his wife is also not available working in [city] so that the most knowledgeable to interview is the mother in law of the baseline. [name]"
mydata$eh_s0q40[1472] <- "Interview conducted at [site]"
mydata$eh_s0q40[1503] <- "Interview conducted at the respondent's work in [municipality]"
mydata$eh_s0q40[1558] <- "The baseline respondent is working in [city]. He will go home on October for vacation. The respondent for this endline survey is the wife of the baseline respondent."
mydata$eh_s0q40[1561] <- "The baseline respondent is working abroad in [country] and the husband is unable to interview because of his [disease]. The most knowledgeable respondent will be the first child of the family <U+F46A>"
mydata$eh_s0q40[1675] <- "He is with his spouse named [name]."
mydata$eh_s0q40[1822] <- "[phone number]"
mydata$eh_s0q40[1973] <- "Respondent [name] was not interviewed alone beacause she was hearing impared, so she was accompanied by her husband."
mydata$eh_s0q40[1997] <- "Interviewed with wife, [name], as she was more knowledgeable of their economic activities."
mydata$eh_s0q40[2084] <- "Interviewing wife, [name], because [name] (with his son [name]) is currently employed in [site] as [work]. They will be back on the last week of March at the earliest."
mydata$eh_s0q40[2181] <- "Respondent is a bit hearing impaired and is more fluent in [language] so her mother (non-household member)  is with us to help translate."
mydata$eh_s0q40[2191] <- "[name] was the main respondent. [names] were interviewed for their respective economic activities."
mydata$eh_s0q40[379] <- "[name] is an ofw now"
mydata$eh_s0q40[1029] <- "[language]"

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
