#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_1" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers

locvars <- c("ec_s1q9") 
mydata <- encode_location (variables= locvars, missing=999999)


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata$ec_s1q13<- as.factor(mydata$ec_s1q13)

mydata$ec_s1q13=factor(mydata$ec_s1q13,
                       levels=levels(mydata$ec_s1q13),
                       labels=c("-998", "1-6", "1-6", "1-6", "7-10","7-10","11-12","11-12","14", "17", "23","24","25 or more", "96"),
                       ordered=F)
mydata$ec_s1q15<- as.factor(mydata$ec_s1q15)

mydata$ec_s1q15=factor(mydata$ec_s1q15,
                       levels=levels(mydata$ec_s1q15),
                       labels=c("-998", "1-6", "1-6", "1-6", "7-10","7-10","7-10", "7-10","11-12","11-12","13", "15", "16","17","19", "20","21","22","23","24","25","96"),
                       ordered=F)

# Top code open school days with large unusual numbers

mydata <- top_recode ("ec_s1q21", break_point=6, missing=c(888, 999999)) 


# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("ec_s1q23", break_point=13, missing=c(888, 999999)) # Topcode cases with 13 or more siblings. 


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("ec_s1q2",
                  "ec_s1q3",
                  "ec_s1q5",
                  "ec_s1q12",
                  "ec_s1q17",
                  "ec_s1q18",
                  "genderfix",
                  "ec_female")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_activity <- c(-999,	-998,	1,	3,	4,	5,	6,	7,	8,	9,	10,	11,	12,	13,	15,	16,	22)
labels_activity <- c("Refused to answer"=1,
                     "Dont know"=2,
                     "Other"=3,
                     "Own child"=4,
                     "Other"=5,
                     "Other"=6,
                     "Other"=7,
                     "Other"=8,
                     "Grandchild"=9,
                     "Other"=10,
                     "Nephew/niece"=11,
                     "Other"=12,
                     "Other"=13,
                     "Other"=14,
                     "Other"=15,
                     "Other"=16,
                     "Other/Unrelated "=17)
mydata <- ordinal_recode (variable="ec_s1q2", break_points=break_activity, missing=999999, value_labels=labels_activity)


break_activity <- c(-999,-998,1,2,3,4,5,6)
labels_activity <- c("Refused to answer"=1,
                     "Dont know"=2,
                     "Private-Catholic"=3,
                     "Private-Non-Catholic"=4,
                     "Public"=5,
                     "Other"=6,
                     "Other"=7,
                     "Other"=8) 

mydata <- ordinal_recode (variable="ec_s1q12", break_points=break_activity, missing=999999, value_labels=labels_activity)



#'# Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('ec_s1q3', 'ec_s1q5', 'ec_s1q4') ##!!! Replace with candidate categorical demo vars


# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata [notAnon,"ec_s1q3"] <- NA

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 

open_ends <- c("ec_s1q6",
              "ec_s1q14",
              "ec_s1q16",
              "ec_s1q19")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# !!!No variables to be deleted or redacted 


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
