#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_C" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

mydata$household_id <- zap_labels(mydata$household_id)

#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

# !!! Identify open-end variables here: 
open_ends <- c("m_scq2",
               "m_scq4",
               "m_endnotec")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$m_endnotec[18] <- "Interview conducted via phone because when we arrived at their house, no one is home and a neighbor gave a contact number. Upon calling [name] to asked for a schedule, she requested to be interviewed that moment at the phone."
mydata$m_endnotec[335] <- "[name] is the correct spellkng of the family name of the housenold"
mydata$m_endnotec[851] <- "[small location]"
mydata$m_endnotec[1022] <- "The respondent is one of [name 1] son name [name 2], who is  the available adult during my second visit."
mydata$m_endnotec[1344] <- "She just got home from [small location]"
mydata$m_endnotec[1352] <- "Their house is located at Sitio [small location] but interview were conducted in Sitio [small location], where their eatery located. (Near the elementary school)"
mydata$m_endnotec[1414] <- "Baseline respondent [name 1] is now working abroad while her partner  [name 2] is at work and he arrives too late every saturday. Since their 21 yrs old  son is the only available adult I decided to interviewed him."


#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
