#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_2" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers

locvars <- c("eh_s2q15") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("eh_s2q1",
                  "eh_s2q3",
                  "eh_s2q4",
                  "eh_s2q5",
                  "eh_s2q6",
                  "eh_s2q7",
                  "eh_s2q8",
                  "eh_s2q9")

capture_tables (indirect_PII)

#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 

open_ends <- c("eh_s2q2",
               "eh_s2q14",
               "eh_s2q16",
               "eh_s2q19",
               "eh_s2q20",
               "eh_s2q21")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$eh_s2q2[3] <- "[language]"
mydata$eh_s2q2[4] <- "[language]"
mydata$eh_s2q2[5] <- "[language]"
mydata$eh_s2q2[59] <- "Lived with his mother at [small location]"
mydata$eh_s2q2[75] <- "Now staying in [Large location]"
mydata$eh_s2q2[108] <- "[language]"
mydata$eh_s2q2[140] <- "Too old and having vacation at [province]"
mydata$eh_s2q2[193] <- "[situation]"
mydata$eh_s2q2[219] <- "[situation]"
mydata$eh_s2q2[239] <- "Son of [name]"
mydata$eh_s2q2[240] <- "Daugther of [name]"
mydata$eh_s2q2[278] <- "Daughter of [names]"
mydata$eh_s2q2[293] <- "[name] is not part of the family"
mydata$eh_s2q2[328] <- "Moved with his mother [name]"
mydata$eh_s2q2[329] <- "Moved with his mother [name]"
mydata$eh_s2q2[367] <- "They transferred to other house in [small location]"
mydata$eh_s2q2[388] <- "Living with parents in [province]"
mydata$eh_s2q2[390] <- "[language]"
mydata$eh_s2q2[422] <- "[language]"
mydata$eh_s2q2[426] <- "He is now living with her mother [name] and her father on separate house"
mydata$eh_s2q2[435] <- "[language]"
mydata$eh_s2q2[450] <- "Separated. Daughter [name]"
mydata$eh_s2q2[471] <- "Moved together with her mother [name]"
mydata$eh_s2q2[472] <- "[name] and [name] is a the same person, it just happened that his mother changed the name from [name] to [name] because his mother has s belief that when her son got sick she should change the name of her son, which is [name]"
mydata$eh_s2q2[474] <- "[name] has already his own family, and she still leave on the house but they have separate room for sleeping and preparation of foods."
mydata$eh_s2q2[476] <- "Still leave together with his mother [name]"
mydata$eh_s2q2[535] <- "[language]"
mydata$eh_s2q2[541] <- "[name]son"
mydata$eh_s2q2[551] <- "Daughter of [name] who transfer in malabon"
mydata$eh_s2q2[583] <- "[language]"
mydata$eh_s2q2[584] <- "[language]"
mydata$eh_s2q2[616] <- "They have their own house now in [small location], thats why her mother get him there"
mydata$eh_s2q2[640] <- "Move to brgy [small location]"
mydata$eh_s2q2[643] <- "[name] now is living with his mother sister in law for almost 2 years"
mydata$eh_s2q2[669] <- "Son of [name]"
mydata$eh_s2q2[679] <- "Her mother, [name],took her to [small location]."
mydata$eh_s2q2[680] <- "His mother, [name], took him under her care. They are living in [small location] currently."
mydata$eh_s2q2[686] <- "They moved to [small location]"
mydata$eh_s2q2[687] <- "They moved to [small location]"
mydata$eh_s2q2[688] <- "They moved to [small location]"
mydata$eh_s2q2[715] <- "Moved to [small location]"
mydata$eh_s2q2[717] <- "Moved to [small location]"
mydata$eh_s2q2[719] <- "Moved to [small location]"
mydata$eh_s2q2[724] <- "Her father, [name], brought her back with him. They lived in [small location] currently."
mydata$eh_s2q2[726] <- "She is now with his mother at [large location]"
mydata$eh_s2q2[730] <- "[language]"
mydata$eh_s2q2[732] <- "[language]"
mydata$eh_s2q2[736] <- "She lives with the respondent's sibling in [small location]."
mydata$eh_s2q2[738] <- "With her mother [name]"
mydata$eh_s2q2[741] <- "Moved to her parents in [location]"
mydata$eh_s2q2[751] <- "[name]'s partner"
mydata$eh_s2q2[752] <- "[name]'s son"
mydata$eh_s2q2[754] <- "[name]'s son"
mydata$eh_s2q2[757] <- "[language]"
mydata$eh_s2q2[760] <- "[situation]"
mydata$eh_s2q2[782] <- "[language]"
mydata$eh_s2q2[784] <- "Went to [location] since [date]"
mydata$eh_s2q2[785] <- "Went to [location] since [date]"
mydata$eh_s2q2[790] <- "Moved to [location]"
mydata$eh_s2q2[796] <- "[language]"
mydata$eh_s2q2[805] <- "Moved to Barangay [location]"
mydata$eh_s2q2[807] <- "Moved to Barangay [location]"
mydata$eh_s2q2[815] <- "[language]"
mydata$eh_s2q2[816] <- "[language]"
mydata$eh_s2q2[817] <- "[language]"
mydata$eh_s2q2[819] <- "[language]"
mydata$eh_s2q2[821] <- "[language]"
mydata$eh_s2q2[822] <- "[language]"
mydata$eh_s2q2[830] <- "[language]"
mydata$eh_s2q2[838] <- "[language]"
mydata$eh_s2q2[847] <- "The mother came back and brought the children ([names]) with her, and lived separately away from their grandparents house"
mydata$eh_s2q2[848] <- "The mother came back and brought them ([names]) back with her, and lived separately away from their grandparents house"
mydata$eh_s2q2[849] <- "Living with [name] and her children [names]"
mydata$eh_s2q2[852] <- "Shes the mother of [names]. Living with her partner, [name], and her children away from her parents house"
mydata$eh_s2q2[856] <- "Move to [location] to his grandpa"
mydata$eh_s2q2[860] <- "Move to other house with [name]"
mydata$eh_s2q2[861] <- "Move to other house with [name]"
mydata$eh_s2q2[865] <- "[language]"
mydata$eh_s2q2[866] <- "[language]"
mydata$eh_s2q2[867] <- "[language]"
mydata$eh_s2q2[869] <- "[language]"
mydata$eh_s2q2[888] <- "Her mother, [name], brought her with her when they moved to [location] to run from her debtors"
mydata$eh_s2q2[900] <- "Moved to [name]'s daughter in [location]"
mydata$eh_s2q2[902] <- "[language]"
mydata$eh_s2q2[903] <- "[language]"
mydata$eh_s2q2[906] <- "[situation]"
mydata$eh_s2q2[915] <- "[language]"
mydata$eh_s2q2[916] <- "[language]"
mydata$eh_s2q2[920] <- "[language]"
mydata$eh_s2q2[921] <- "[language]"
mydata$eh_s2q2[927] <- "[name]'s daughter"
mydata$eh_s2q2[932] <- "[language]"
mydata$eh_s2q2[947] <- "[language]"
mydata$eh_s2q2[953] <- "[language]"
mydata$eh_s2q2[954] <- "[language]"
mydata$eh_s2q2[955] <- "[language]"
mydata$eh_s2q2[963] <- "Living with [name], her Aunt."
mydata$eh_s2q2[966] <- "After giving birth of her wife, they decided to live with [name] family"
mydata$eh_s2q2[973] <- "Moved to [province] province"
mydata$eh_s2q2[978] <- "Daugther of [name]"
mydata$eh_s2q2[991] <- "[situation]"
mydata$eh_s2q2[992] <- "[language]"
mydata$eh_s2q2[993] <- "[language]"
mydata$eh_s2q2[994] <- "[language]"
mydata$eh_s2q2[997] <- "[language]"
mydata$eh_s2q2[1013] <- "[language]"
mydata$eh_s2q2[1019] <- "[language]"
mydata$eh_s2q2[1022] <- "[language]"
mydata$eh_s2q2[1024] <- "[language]"
mydata$eh_s2q2[1035] <- "She is with her parents in [location]-[names]"
mydata$eh_s2q2[1080] <- "[name] miced to brgy. [location]"
mydata$eh_s2q2[1081] <- "[name] moved to brgy. [location]"
mydata$eh_s2q2[1082] <- "[name] transfer to another brgy"
mydata$eh_s2q2[1083] <- "[language]"
mydata$eh_s2q2[1094] <- "Working abroad [location]"
mydata$eh_s2q2[1097] <- "[language]"
mydata$eh_s2q2[1098] <- "She lives in [location] with her daugther"
mydata$eh_s2q2[1099] <- "She lives in [location] with her daughter"
mydata$eh_s2q2[1100] <- "Moved to her grandma in [location]"
mydata$eh_s2q2[1109] <- "Since the respondent died, [name] lives with his real father (respondent's son)"
mydata$eh_s2q2[1148] <- "He is [situation] since [date]"
mydata$eh_s2q2[1153] <- "[language]"
mydata$eh_s2q2[1154] <- "[language]"
mydata$eh_s2q2[1161] <- "[language]"
mydata$eh_s2q2[1162] <- "[name]'s husband"
mydata$eh_s2q2[1163] <- "Separation "
mydata$eh_s2q2[1181] <- "[name] is now sleeping at her grandmother's house."
mydata$eh_s2q2[1192] <- "[name] moved to the other house."
mydata$eh_s2q2[1193] <- "[name] moved to the other house."
mydata$eh_s2q2[1194] <- "[name] moved to the other house"
mydata$eh_s2q2[1195] <- "[name] move from the others house."
mydata$eh_s2q2[1196] <- "[name] moved to the other house."
mydata$eh_s2q2[1221] <- "Transfer to [location]"
mydata$eh_s2q2[1291] <- "[language]"
mydata$eh_s2q2[1292] <- "[language]"
mydata$eh_s2q2[1336] <- "Moved in his parent's house at [location]"
mydata$eh_s2q2[1382] <- "He stay with his other children in [location]"
mydata$eh_s2q2[1396] <- "Moved in [location]"
mydata$eh_s2q2[1410] <- "Move to another house in [location]"
mydata$eh_s2q2[1411] <- "She was diagnosed with [illness] and brought back to [location]"
mydata$eh_s2q2[1458] <- "Went with [name] in [location]"
mydata$eh_s2q2[1459] <- "Went back to [location] to their own house with [name] as his wife"
mydata$eh_s2q2[1466] <- "He is staying with his live in partner in [location], [name]"
mydata$eh_s2q2[1469] <- "[name]'s household just stayed in [name] hh for a while and then they decided to moved out and just rent in another house."
mydata$eh_s2q2[1470] <- "[name]'s hh just stayed in [name] house for a while and then they decided to moved out and rent in another house"
mydata$eh_s2q2[1472] <- "[name]'s biological father  decided to take a full custody of him and decided for  the two 0f them to be together for good."
mydata$eh_s2q2[1473] <- "Vacation in her aunt [name].She will be back home on [date]"
mydata$eh_s2q2[1474] <- "Moved to [location] with her father"
mydata$eh_s2q2[1515] <- "Moved to [location]"
mydata$eh_s2q2[1516] <- "Moved to [location]"
mydata$eh_s2q2[1538] <- "Moved house with her parents [names]"
mydata$eh_s2q2[1550] <- "Moved house in [location]"
mydata$eh_s2q2[1553] <- "Moved back to his mother in [location]"
mydata$eh_s2q2[1557] <- "Moved to another household with his mother [name]."
mydata$eh_s2q2[1559] <- "Moved to another household with her mother [name]."
mydata$eh_s2q2[1560] <- "Moved to another household together with her mother [name]."
mydata$eh_s2q2[1569] <- "Moved away to Brgy. [location]"
mydata$eh_s2q2[1570] <- "Moved away with his parents in Brgy. [location]"
mydata$eh_s2q2[1585] <- "Living with her spouse in [location]"
mydata$eh_s2q2[1586] <- "Living with her parents in [location]"
mydata$eh_s2q2[1592] <- "Moved with parents, [names]"
mydata$eh_s2q2[1596] <- "Moved in with youngest son, [name]"
mydata$eh_s2q2[1597] <- "Moved in with parents, [names]"
mydata$eh_s2q2[1599] <- "Moved in with sister,[name]"
mydata$eh_s2q2[1606] <- "Went to [location]to spent his vacation."
mydata$eh_s2q2[1615] <- "He is currently staying with his mother [name] and belongs to same household."
mydata$eh_s2q2[1625] <- "Now  living in [location] with her common-law husband and 3 children."
mydata$eh_s2q2[1626] <- "Now living with her mother [name] in [location]"
mydata$eh_s2q2[1627] <- "Now living with her mother [name] in [location]"
mydata$eh_s2q2[1629] <- "Now living with her mother [name] in [location]"
mydata$eh_s2q2[1632] <- "Now living with her mother in [location]."
mydata$eh_s2q2[1635] <- "Living with her husband in [location] 6 months"
mydata$eh_s2q2[1638] <- "Living with her Grandmother in the same barangay at [location].She is one year there together with her husband."
mydata$eh_s2q2[1643] <- "Went home to [location]"
mydata$eh_s2q2[1650] <- "With his family [name] and [name] in [location]"
mydata$eh_s2q2[1669] <- "Now living with her mother [name] and brother [name], in [province] province."
mydata$eh_s2q2[1671] <- "Now living in [location], [location] together with her common-law spouse."
mydata$eh_s2q2[1672] <- "Now living in [location] together with her mother [name]."
mydata$eh_s2q2[1676] <- "Moved with mother , [name]"
mydata$eh_s2q2[1681] <- "[language]"
mydata$eh_s2q2[1702] <- "He is in [location] because his brother is died .His wife do not know when he is going home."
mydata$eh_s2q2[1722] <- "[language]"
mydata$eh_s2q2[1726] <- "Moved for house with her mother [name] and his father in [location]"
mydata$eh_s2q2[1727] <- "Moved for house with his husband last April 3, 2017 in [location]"
mydata$eh_s2q2[1753] <- "Moved to other house with spouse name [name] to have their own family"
mydata$eh_s2q2[1754] <- "[name] and her husband decided to move to another house so as to start their own family"
mydata$eh_s2q2[1758] <- "[language]"
mydata$eh_s2q2[1766] <- "He is leaving with her family at [location]"
mydata$eh_s2q2[1770] <- "Is now living with her mother [name] in a different household in the same barangay."
mydata$eh_s2q2[1773] <- "Is now living with his mother in [location] and studying there."
mydata$eh_s2q2[1781] <- "[language]"
mydata$eh_s2q2[1784] <- "Move to other house to her siblings  [name]"
mydata$eh_s2q2[1796] <- "[language]"
mydata$eh_s2q2[1800] <- "[situation]"
mydata$eh_s2q2[1810] <- "[language]"
mydata$eh_s2q2[1835] <- "Move her own house and family at [province] province and she did not come here again at [location] ,accrding to her grandchild [name]."
mydata$eh_s2q2[1849] <- "[language]"
mydata$eh_s2q2[1851] <- "[language]"
mydata$eh_s2q2[1864] <- "Moved in with his parents, [names]."
mydata$eh_s2q2[1865] <- "[name] is now living with her husband [name] and son, in a different household. According to the respondent, the two are now married."
mydata$eh_s2q2[1866] <- "[name]., now lives in a different household together with his wife [name]and son. According to the respondent the two are now married."
mydata$eh_s2q2[1904] <- "[name]'s legitimate mother is now taking care of her."
mydata$eh_s2q2[1908] <- "Moved to Brgy. [location]within the same municipality together with his common-law wife, [name] whose parents has a house in the said barangay."
mydata$eh_s2q2[1909] <- "Moved to her parents house in Brgy. [location] within the same municipality, together with her common-law husband, [name] and their new-born child."
mydata$eh_s2q2[1912] <- "Living with older sibling ever since his mother [name] died"
mydata$eh_s2q2[1923] <- "[name] living with his grandmother"
mydata$eh_s2q2[1924] <- "He is in [location] have a disease in liver"
mydata$eh_s2q2[1941] <- "Stay in their old house . In barangay [location]"
mydata$eh_s2q2[1942] <- "Stay in their old house in brgy. [location]"
mydata$eh_s2q2[1943] <- "Move in [location] with mother"
mydata$eh_s2q2[1944] <- "Move in [location] with [name]"
mydata$eh_s2q2[1972] <- "Visits her sister in [location]"
mydata$eh_s2q2[1973] <- "[language]"
mydata$eh_s2q2[1984] <- "Living with his wife in [location]"
mydata$eh_s2q2[1998] <- "[language]"
mydata$eh_s2q2[2005] <- "[language]"
mydata$eh_s2q2[2015] <- "Husband was assigned to [location] for work"
mydata$eh_s2q2[2027] <- "Move with her mom [name]"
mydata$eh_s2q2[2036] <- "Daughter of [name] and thereforw also lives in [location]"
mydata$eh_s2q2[2050] <- "Resides in [location]."
mydata$eh_s2q2[2061] <- "Living with her husband in [location]  "
mydata$eh_s2q2[2063] <- "Living with his wife in [location]"
mydata$eh_s2q2[2066] <- "[language]"
mydata$eh_s2q2[2073] <- "Living with her husband in [location] for 2 years"
mydata$eh_s2q2[2074] <- "Living with her husband in [location] for 3 years"
mydata$eh_s2q2[2075] <- "Living with his wife in [location] for 3 years"
mydata$eh_s2q2[2083] <- "[language]"
mydata$eh_s2q2[2099] <- "Transfer to husbands plsce in [location]"
mydata$eh_s2q2[2101] <- "[language]"
mydata$eh_s2q2[2104] <- "Is now living in a separate household with common-law wife, [name] and a baby daughter."
mydata$eh_s2q2[2106] <- "Has been incarcerated for 6 years in [location]."
mydata$eh_s2q2[2109] <- "Son of [name] who now lives with his parents in a different household."
mydata$eh_s2q2[2110] <- "Common-law spouse of [name] who now lives with [name] and their son [name] in a different household."
mydata$eh_s2q2[2111] <- "Working abroad in [country] and she will come back home in dec.2019"
mydata$eh_s2q2[2113] <- "Child is now living in [location] with her biological mother."
mydata$eh_s2q2[2114] <- "Goes back home to his parents in [location]"
mydata$eh_s2q2[2118] <- "Moved house with [name]"
mydata$eh_s2q2[2119] <- "Moved house with [name]"
mydata$eh_s2q2[2120] <- "Moved house with [name]"
mydata$eh_s2q2[2140] <- "Moved house with his parents [names]"

mydata$eh_s2q2[2168] <- "He was being taking cared by his uncle who livea in [location] and will be enrolled next school year"

mydata$eh_s2q2[2189] <- "[name] is now living with a common-law wife and has a son. They live in a room (separate space) with a partition from his parents' house and has a separate arrangement in the food consumption."
mydata$eh_s2q2[2198] <- "With [name]"
mydata$eh_s2q2[2199] <- "With [name]"
mydata$eh_s2q2[2200] <- "His with [name]"
mydata$eh_s2q2[2202] <- "She is currently on vacation and is staying with her aunt, [name and phone number], in [location]. She left Apr 3, and is expected to be back when school starts in [date]"
mydata$eh_s2q2[2203] <- "She is currently on vacation and is staying with her aunt, [name] [phone number], in Sanctuarium (across cemetery), [location]. She left [date] and is expected to be back when school starts in June 2018."
mydata$eh_s2q2[2204] <- "He is currently on vacation and is staying with his aunt,[name and phone number], in [location]. He left [date] and is expected to be back when school starts in [date]"
mydata$eh_s2q2[2212] <- "[language]"
mydata$eh_s2q2[2218] <- "Has moved in a separate household with his common-law wife - [name] and daughter [name] and another daughter. House is beside his parents' house (respondent's) with a different door and a wall that divide the two households, and with separate arrangement in food consumption. He is currently working in [location]."
mydata$eh_s2q2[2262] <- "Child of [name], he is with his mother in [location]"

mydata <- mydata[!names(mydata) %in% "eh_s2q16"]
mydata <- mydata[!names(mydata) %in% "eh_s2q19"]
mydata <- mydata[!names(mydata) %in% "eh_s2q20"]
mydata <- mydata[!names(mydata) %in% "eh_s2q21"]

#'# GPS data: Displace
# !!!No GPS data
#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
#'