#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_3" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values

# Top code high income to the 99.5 percentile

percentile_99.5 <-floor(quantile(na.exclude(mydata$eh_s3q14)[na.exclude(mydata$eh_s3q14)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="eh_s3q14", break_point=percentile_99.5, missing=-97)

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values

break_edu <- c(-998,1,2,4,6,7,8,99)
labels_edu <- c("-998" = 1,
                "1" = 2,
                "2" = 3,
                "4 or 5" = 4,
                "6" = 5,
                "7" = 6,
                "8" = 7,
                "99"= 8)
mydata <- ordinal_recode (variable="eh_s3q5", break_points=break_edu, missing=999999, value_labels=labels_edu)


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

# !!! Identify open-end variables here: 
open_ends <- c("eh_s3q6",
               "eh_s3q10")


report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$eh_s3q6[8975] <- "other"
mydata$eh_s3q6[13940] <- "other"

#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
