#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_0" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("ec_s0q13",
              "ec_scq2",
              "ec_scq4")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# !!!Remove, as it contains a lot of sensitive information and some information is in Tagalog.
mydata$ec_s0q13[1664] <- "Move to [small location redacted] in his Grand Mother"
mydata$ec_s0q13[1672] <- "[language]"
mydata$ec_s0q13[1675] <- "At [small location], (guardian [name redacted]) can ask to brgy hall"
mydata$ec_s0q13[1898] <- "Working at [small location] unavable to contact"
mydata$ec_s0q13[3058] <- "[name redacter], is there in [small location]."
mydata$ec_s0q13[3287] <- "He is working at sari-sari store in [small location],her mother she dont know where in  [small location], [cp no redacted] hes only available at night."
mydata$ec_s0q13[3465] <- "She lives and studies at [name of school redacted] since 2016. She went home once a year only every month of january. The child was prohibited accepting visitors even her family. She will visit her family on January 2019. The HH and family will visit her on the 1st Saturday of September 2018.  This is the HH's new [cp redacted] ([name of interviewer redacted])"
mydata$ec_s0q13[3616] <- "Child is living with his father in [small location] where the household survey was conducted, while the other 3 children interviewed herein lives with their grandfather in [small location]. The original FOs who conducted the household survey and first child survey who have met Role in person said that this child should not be part of the child survey since he is just 9 years old and there was a mistake due to the father's (household reapondent) wrong information given to the FOs. FO who conducted the interview on the 3 children did not meet Role in person."
mydata$ec_s0q13[3645] <- "He's working as sales boy in [small location]. He will go home on 25th of May 2018 for the opening of classes. His celphone number [celphone number]"
mydata$ec_scq4[177] <- "First attempt may 5 she want to participate but when I call again she is already hiding because her cousin answer the phone and [name redacted] is whispering to her cousin that she don't to be interviewed last attempt may 7"
mydata$ec_scq4[2430] <- "The auntie dont want the child to be interviewed. At first attemp she said that [name redacted] is in travel going to bicol but i saw him outside so on the 2nd attemp i tried to convince them again to talk  to child but the auntie said [name redacted] already packed his thing and he dont want to talk with me. At the 3rd attemp i saw the child outside and asked him if he is willing to be interviewed but he refused."
mydata$ec_scq4[2596] <- "The child always avoid to the interview. He is always hiding from the fo's because he doesn't want to be interviewed. The child doesn't want to talk with us, he keep hiding, we did 5th attemp with the SFO([name redacted]) and he's gestures shows not interested at all."
mydata$ec_scq4[3092] <- "[name redacted] refused to cooperate with the interview, he didn't talk to us and run away."
mydata$ec_scq4[3138] <- "[name redacted] dont want to be interview, we really try our best to interview him but he run away and went to the farm. His mother didn't intertaine us regarding on his son's refusal."
mydata$ec_scq4[3196] <- "[name redacted] refused to be interviewed, he don't want to speak to us and he just remain quiet. Even his parent try to convince him to cooperate but he didn't  talk and cry."
mydata$ec_scq4[3220] <- "[name redacted]  is very shy. He will not even meet me despite all cajoling from his grandparents, mom, and siblings."
mydata$ec_s0q13[170] <- "The child is in [small location] according to their mother their might study there.  She don't have any contact number to her relatives in Leyte because her cellphone fell from water and the SIM was damaged."



#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
