#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_12" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed

dropvars <- c("m_s12q5") 
mydata <- mydata[!names(mydata) %in% dropvars]

mydata$household_id <- zap_labels(mydata$household_id)

#'# Direct PII-team: Encode field team names


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Include relevant variables, but check their population size first to confirm they are <100,000

locvars <- c("m_s12q9", "m_s12q20") 
mydata <- encode_location (variables= locvars, missing=999999)


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

# !!! Identify open-end variables here: 
open_ends <- c("m_s12q8_other",
              "m_s12q10",
              "m_s12q21")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$m_s12q8_other[1636] <- "[small location]"
mydata$m_s12q10[1056] <- "[small location]"
mydata$m_s12q10[1059] <- "[small location]"
mydata$m_s12q10[1067] <- "[small location]"
mydata$m_s12q10[1143] <- "[small location]"
mydata$m_s12q10[1225] <- "[small location]"
mydata$m_s12q10[1231] <- "[small location]"
mydata$m_s12q10[1249] <- "[small location]"
mydata$m_s12q10[1276] <- "[small location]"
mydata$m_s12q10[1306] <- "[small location]"
mydata$m_s12q10[1317] <- "[small location]"
mydata$m_s12q10[1328] <- "[small location]"
mydata$m_s12q10[1392] <- "[small location]"
mydata$m_s12q10[1562] <- "[small location]"
mydata$m_s12q10[1608] <- "[small location]"
mydata$m_s12q10[1636] <- "[small location]"
mydata$m_s12q10[1971] <- "[small location]"
mydata$m_s12q10[2015] <- "[small location]"
mydata$m_s12q10[2082] <- "[small location]"
mydata$m_s12q10[2201] <- "[small location]"
mydata$m_s12q21[948] <- "[small location]"
mydata$m_s12q21[990] <- "[small location]"
mydata$m_s12q21[1059] <- "[small location]"
mydata$m_s12q21[1119] <- "[small location]"
mydata$m_s12q21[1231] <- "[small location]"
mydata$m_s12q21[1249] <- "[small location]"
mydata$m_s12q21[1495] <- "[small location]"
mydata$m_s12q21[1529] <- "[small location]"
mydata$m_s12q21[1683] <- "[small location]"
mydata$m_s12q21[2274] <- "[small location]"



#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
