#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_C" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII 


#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team


#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No Small locations


#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# !!!No Indirect PII - Ordinal


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!No Indirect PII - Categorical


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data

# !!! Identify open-end variables here: 
open_ends <- c("eh_scq3", "eh_scq5", "eh_scq6")
report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$eh_scq3[1121] <- "for the 2nd attempt. We've tried to convince the respondent with the SFO ([name]) but she refused again and she said that she didnt need the survey. her gestures showed that she is not interested."
mydata$eh_scq6[115] <- "Interview conducted at her work ([small location])"
mydata$eh_scq6[236] <- "She transferred From [small location] to [small location]"
mydata$eh_scq6[651] <- "[name] is at work no time to be interviewed"
mydata$eh_scq6[1187] <- "Transferred to [small location] (10 months) She is 4 months pregnant to her present partner"
mydata$eh_scq6[1326] <- "Its [name] not [name]"

#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
