#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_6" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

mydata$household_id <- zap_labels(mydata$household_id)

#'# Direct PII-team: Encode field team names
# !!!No Direct PII - team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!Small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

# Top code high income to the 99.5 percentile
percentile_99.5 <- floor(quantile(na.exclude(mydata$m_s6q3)[na.exclude(mydata$m_s6q3)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="m_s6q3", break_point=percentile_99.5, missing=-97)

percentile_99.5 <- floor(quantile(na.exclude(mydata$m_s6q12)[na.exclude(mydata$m_s6q12)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="m_s6q12", break_point=percentile_99.5, missing=-97)

mydata$m_farm_expenses <- as.numeric(mydata$m_farm_expenses)
percentile_99.5 <- floor(quantile(na.exclude(mydata$m_farm_expenses)[na.exclude(mydata$m_farm_expenses)!=-97], probs = c(0.995)))
mydata <- top_recode (variable="m_farm_expenses", break_point=percentile_99.5, missing=-97)


#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("m_s6q1",
                  "m_s6q2",
                  "m_s6q4",
                  "m_s6q5",
                  "m_s6q6",
                  "m_s6q8",
                  "m_s6q10",
                  "m_s6q11",
                  "m_s6q13")

capture_tables (indirect_PII)

# Recode those with very specific values. 
# !!!No very specific values


#'# Matching and crosstabulations: Run automated PII check 
# !!!Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("m_s6q4_other",
               "m_s6q6_other",
               "m_s6q8_warning",
               "m_s6q13_other",
               "m_endnote6")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number

# !!!Redacted, as it contains sensitive information and some information is in Tagalog.
mydata$m_s6q4_other[1003] <- "[language](cooperativa)"
mydata$m_s6q4_other[1294] <- "[language] (tornohan)"
mydata$m_s6q13_other[352] <- "4 kls. Of Certified Seeds from Local Government of [small location]"
mydata$m_s6q13_other[434] <- "LGU [small location] City"
mydata$m_s6q13_other[1468] <- "Department of Agriculture and UP [small location]"
mydata$m_endnote6[173] <- "[name] planted vegetables at their backyard for their consumption, she is not using any fertilizer, no expenses, as well as the seeds were given by friends and neighbors"
mydata$m_endnote6[261] <- "[language]"
mydata$m_endnote6[468] <- "[language]"
mydata$m_endnote6[617] <- "[language]"
mydata$m_endnote6[949] <- "[language]"
mydata$m_endnote6[1126] <- "The farm they used were owned by [name] and his siblings. So they shared in expenses and same with  the crops they harvest."
mydata$m_endnote6[1468] <- "Their crops is organic, by the help of UP [small location], they are planting vegetables. They gets free 4  bags of seeds in the department of Agriculture."
mydata$m_endnote6[2067] <- "The cost was decreased because he has only 5tupongs of land from the 0.50hectares na lang ang pig uuma sa dating half hec. [language]"

#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
