#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_6" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

mydata <- top_recode ("s6q12count", break_point=4, missing=c(888, 999999))  

# Top code high values to the 99.5 percentile
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q2)[na.exclude(mydata$s6q2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q4a)[na.exclude(mydata$s6q4a)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q4a", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q7)[na.exclude(mydata$s6q7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q9)[na.exclude(mydata$s6q9)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q9", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q9a)[na.exclude(mydata$s6q9a)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q9a", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q11)[na.exclude(mydata$s6q11)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q11", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_1)[na.exclude(mydata$s6q17_1)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_1", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_1)[na.exclude(mydata$s6q19_1)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_1", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_1)[na.exclude(mydata$s6q20_1)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_1", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_1)[na.exclude(mydata$s6q21_1)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_1", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_2)[na.exclude(mydata$s6q17_2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_2)[na.exclude(mydata$s6q19_2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_2)[na.exclude(mydata$s6q20_2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_2)[na.exclude(mydata$s6q21_2)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_2", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_3)[na.exclude(mydata$s6q17_3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_3)[na.exclude(mydata$s6q19_3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_3)[na.exclude(mydata$s6q20_3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_3)[na.exclude(mydata$s6q21_3)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_3", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_4)[na.exclude(mydata$s6q17_4)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_4", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_4)[na.exclude(mydata$s6q19_4)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_4", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_4)[na.exclude(mydata$s6q20_4)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_4", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_4)[na.exclude(mydata$s6q21_4)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_4", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_5)[na.exclude(mydata$s6q17_5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_5)[na.exclude(mydata$s6q19_5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_5)[na.exclude(mydata$s6q20_5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_5)[na.exclude(mydata$s6q21_5)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_5", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q17_6)[na.exclude(mydata$s6q17_6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q17_6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_6)[na.exclude(mydata$s6q19_6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_6)[na.exclude(mydata$s6q20_6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_6)[na.exclude(mydata$s6q21_6)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_6", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q19_7)[na.exclude(mydata$s6q19_7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q19_7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q20_7)[na.exclude(mydata$s6q20_7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q20_7", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q21_7)[na.exclude(mydata$s6q21_7)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q21_7", break_point=percentile_99.5, missing=999999)
mydata <- top_recode (variable="s6q22", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q24)[na.exclude(mydata$s6q24)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q24", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q26)[na.exclude(mydata$s6q26)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q26", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q28)[na.exclude(mydata$s6q28)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q28", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q30)[na.exclude(mydata$s6q30)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q30", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q32)[na.exclude(mydata$s6q32)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q32", break_point=percentile_99.5, missing=999999)
percentile_99.5 <- floor(quantile(na.exclude(mydata$s6q35)[na.exclude(mydata$s6q35)!=999999], probs = c(0.995)))
mydata <- top_recode (variable="s6q35", break_point=percentile_99.5, missing=999999)




#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("s6q1",
                  "s6q2unit",
                  "s6q2a",
                  "s6q3",
                  "s6q4",
                  "s6q5",
                  "s6q6",
                  "s6q8",
                  "s6q10",
                  "s6qn16",
                  "s6q12",
                  "s6q13_1",
                  "s6q15_1",
                  "s6q16_1",
                  "s6q18_1",
                  "s6q13_2",
                  "s6q15_2",
                  "s6q16_2",
                  "s6q18_2",
                  "s6q13_3",
                  "s6q15_3",
                  "s6q16_3",
                  "s6q18_3",
                  "s6q13_4",
                  "s6q15_4",
                  "s6q16_4",
                  "s6q18_4",
                  "s6q13_5",
                  "s6q15_5",
                  "s6q16_5",
                  "s6q18_5",
                  "s6q13_6",
                  "s6q15_6",
                  "s6q16_6",
                  "s6q18_6",
                  "s6q13_7",
                  "s6q15_7",
                  "s6q18_7",
                  "s6q13_8",
                  "s6q15_8",
                  "s6q16_8",
                  "s6q18_8",
                  "s6q13_9",
                  "s6q15_9",
                  "s6q16_9",
                  "s6q18_9",
                  "s6q13_10",
                  "s6q15_10",
                  "s6q16_10",
                  "s6q18_10",
                  "s6q13_11",
                  "s6q15_11",
                  "s6q18_11",
                  "s6q15_12",
                  "s6q18_12",
                  "s6q13_13",
                  "s6q15_13",
                  "s6q16_13",
                  "s6q18_13",
                  "s6q13_14",
                  "s6q15_14",
                  "s6q16_14",
                  "s6q18_14",
                  "s6q13_15",
                  "s6q15_15",
                  "s6q16_15",
                  "s6q18_15",
                  "s6q13_16",
                  "s6q15_16",
                  "s6q16_16",
                  "s6q18_16",
                  "s6q13_17",
                  "s6q15_17",
                  "s6q16_17",
                  "s6q18_17",
                  "s6q15_18",
                  "s6q18_18",
                  "s6q15_19",
                  "s6q16_19",
                  "s6q18_19",
                  "s6q15_20",
                  "s6q16_20",
                  "s6q18_20",
                  "s6q15_21",
                  "s6q16_21",
                  "s6q18_21",
                  "s6q13_22",
                  "s6q15_22",
                  "s6q18_22",
                  "s6q15_23",
                  "s6q16_23",
                  "s6q18_23")

capture_tables (indirect_PII)



# Recode those with very specific values. 

break_units <- c(-999,1,2,3)
labels_units <- c("No Response"=1,
                "Hectares" = 2,
                "Square Meters" = 3,
                "Other"=4)
mydata <- ordinal_recode (variable="s6q2unit", break_points=break_units, missing=999999, value_labels=labels_units)

mydata <- ordinal_recode (variable="s6q4", break_points=break_units, missing=999999, value_labels=labels_units)




break_owner <- c(-999,-888,1,2,3)
labels_owner <- c("No Response"=1,
                  "Other (specify)" = 2,
                  "Husband or husband's family" = 3,
                  "Wife or wife's family"=4,
                  "Other"=5)
mydata <- ordinal_recode (variable="s6q5", break_points=break_owner, missing=999999, value_labels=labels_owner)

break_crop <- c(-999,-888,1,2,3,4)
labels_crop <- c("No Response"=1,
                  "Other (specify)" = 2,
                  "Rice" = 3,
                  "Corn"=4,
                  "Coconut"=5,
                  "Other"=6)
mydata <- ordinal_recode (variable="s6q13_1", break_points=break_crop, missing=999999, value_labels=labels_crop)

break_crop <- c(-999,-888,1,2,3)
labels_crop <- c("No Response"=1,
                 "Other (specify)" = 2,
                 "Rice" = 3,
                 "Corn"=4,
                 "Other"=5)
mydata <- ordinal_recode (variable="s6q13_2", break_points=break_crop, missing=999999, value_labels=labels_crop)


break_source <- c(-999,-888,1,2,4,5)
labels_source <- c("No Response"=1,
                 "Other (specify)" = 2,
                 "Loan from family and friends" = 3,
                 "Other"=4,
                 "Personal savings"=5,
                 "Other"=6)
mydata <- ordinal_recode (variable="s6q16_1", break_points=break_source, missing=999999, value_labels=labels_source)


break_source <- c(-999,-888,1,2,4,5)
labels_source <- c("No Response"=1,
                   "Other (specify)" = 2,
                   "Other" = 3,
                   "Other"=4,
                   "Personal savings"=5,
                   "Other"=6)
mydata <- ordinal_recode (variable="s6q16_2", break_points=break_source, missing=999999, value_labels=labels_source)


break_measure <- c(-999,-888,1,2,3)
labels_measure <- c("No Response"=1,
                   "Other (specify)" = 2,
                   "Kilograms" = 3,
                   "Sacks"=4,
                   "Other"=5)
mydata <- ordinal_recode (variable="s6q18_1", break_points=break_measure, missing=999999, value_labels=labels_measure)
mydata <- ordinal_recode (variable="s6q18_2", break_points=break_measure, missing=999999, value_labels=labels_measure)

break_measure <- c(-999,-888,1,2)
labels_measure <- c("No Response"=1,
                    "Other (specify)" = 2,
                    "Kilograms" = 3,
                    "Other"=4)
mydata <- ordinal_recode (variable="s6q18_3", break_points=break_measure, missing=999999, value_labels=labels_measure)
mydata <- ordinal_recode (variable="s6q18_4", break_points=break_measure, missing=999999, value_labels=labels_measure)


#'# Matching and crosstabulations: Run automated PII check 
# !!! Insufficient demographic data


#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("s6q1whynoresponse",
               "s6q2unitwhynoresponse",
               "s6q2whynoresponse",
               "s6q2awhynoresponse",
               "s6q3whynoresponse",
               "s6q4whynoresponse",
               "s6q4awhynoresponse",
               "s6q5_other",
               "s6q5whynoresponse",
               "s6q6whynoresponse",
               "s6q7whynoresponse",
               "s6q8whynoresponse",
               "s6q9whynoresponse",
               "s6q9awhynoresponse",
               "s6q10whynoresponse",
               "s6q11whynoresponse",
               "s6qn16whynoresponse",
               "s6q12whynoresponse",
               "s6q12countwhynoresponse",
               "s6q14_1",
               "s6q15awhynoresponse_1",
               "s6q15whynoresponse_1",
               "s6q16other_1",
               "s6q16whynoresponse_1",
               "s6q17whynoresponse_1",
               "s6q19whynoresponse_1",
               "s6q18other_1",
               "s6q18whynoresponse_1",
               "s6q19awhynoresponse_1",
               "s6q20whynoresponse_1",
               "s6q21whynoresponse_1",
               "s6q14_2",
               "s6q15awhynoresponse_2",
               "s6q15whynoresponse_2",
               "s6q16other_2",
               "s6q16whynoresponse_2",
               "s6q17whynoresponse_2",
               "s6q19whynoresponse_2",
               "s6q18other_2",
               "s6q18whynoresponse_2",
               "s6q19awhynoresponse_2",
               "s6q20whynoresponse_2",
               "s6q21whynoresponse_2",
               "s6q14_3",
               "s6q15awhynoresponse_3",
               "s6q15whynoresponse_3",
               "s6q16other_3",
               "s6q16whynoresponse_3",
               "s6q17whynoresponse_3",
               "s6q19whynoresponse_3",
               "s6q18other_3",
               "s6q18whynoresponse_3",
               "s6q19awhynoresponse_3",
               "s6q20whynoresponse_3",
               "s6q21whynoresponse_3",
               "s6q14_4",
               "s6q15awhynoresponse_4",
               "s6q15whynoresponse_4",
               "s6q16other_4",
               "s6q16whynoresponse_4",
               "s6q17whynoresponse_4",
               "s6q19whynoresponse_4",
               "s6q18other_4",
               "s6q18whynoresponse_4",
               "s6q19awhynoresponse_4",
               "s6q20whynoresponse_4",
               "s6q21whynoresponse_4",
               "s6q14_5",
               "s6q15awhynoresponse_5",
               "s6q15whynoresponse_5",
               "s6q16other_5",
               "s6q16whynoresponse_5",
               "s6q17whynoresponse_5",
               "s6q19whynoresponse_5",
               "s6q18other_5",
               "s6q18whynoresponse_5",
               "s6q19awhynoresponse_5",
               "s6q20whynoresponse_5",
               "s6q21whynoresponse_5",
               "s6q14_6",
               "s6q15awhynoresponse_6",
               "s6q15whynoresponse_6",
               "s6q16other_6",
               "s6q16whynoresponse_6",
               "s6q17whynoresponse_6",
               "s6q19whynoresponse_6",
               "s6q18other_6",
               "s6q18whynoresponse_6",
               "s6q19awhynoresponse_6",
               "s6q20whynoresponse_6",
               "s6q21whynoresponse_6",
               "s6q14_7",
               "s6q15awhynoresponse_7",
               "s6q15whynoresponse_7",
               "s6q16other_7",
               "s6q16whynoresponse_7",
               "s6q17whynoresponse_7",
               "s6q19whynoresponse_7",
               "s6q18other_7",
               "s6q18whynoresponse_7",
               "s6q19awhynoresponse_7",
               "s6q20whynoresponse_7",
               "s6q21whynoresponse_7",
               "s6q14_8",
               "s6q15awhynoresponse_8",
               "s6q15whynoresponse_8",
               "s6q16other_8",
               "s6q16whynoresponse_8",
               "s6q17whynoresponse_8",
               "s6q19whynoresponse_8",
               "s6q18other_8",
               "s6q18whynoresponse_8",
               "s6q19awhynoresponse_8",
               "s6q20whynoresponse_8",
               "s6q21whynoresponse_8",
               "s6q14_9",
               "s6q15awhynoresponse_9",
               "s6q15whynoresponse_9",
               "s6q16other_9",
               "s6q16whynoresponse_9",
               "s6q17whynoresponse_9",
               "s6q19whynoresponse_9",
               "s6q18other_9",
               "s6q18whynoresponse_9",
               "s6q19awhynoresponse_9",
               "s6q20whynoresponse_9",
               "s6q21whynoresponse_9",
               "s6q14_10",
               "s6q15awhynoresponse_10",
               "s6q15whynoresponse_10",
               "s6q16other_10",
               "s6q16whynoresponse_10",
               "s6q17whynoresponse_10",
               "s6q19whynoresponse_10",
               "s6q18other_10",
               "s6q18whynoresponse_10",
               "s6q19awhynoresponse_10",
               "s6q20whynoresponse_10",
               "s6q21whynoresponse_10",
               "s6q14_11",
               "s6q15awhynoresponse_11",
               "s6q15whynoresponse_11",
               "s6q16other_11",
               "s6q16whynoresponse_11",
               "s6q17whynoresponse_11",
               "s6q19whynoresponse_11",
               "s6q18other_11",
               "s6q18whynoresponse_11",
               "s6q19awhynoresponse_11",
               "s6q20whynoresponse_11",
               "s6q21whynoresponse_11",
               "s6q14_12",
               "s6q15awhynoresponse_12",
               "s6q15whynoresponse_12",
               "s6q16other_12",
               "s6q16whynoresponse_12",
               "s6q17whynoresponse_12",
               "s6q19whynoresponse_12",
               "s6q18other_12",
               "s6q18whynoresponse_12",
               "s6q19awhynoresponse_12",
               "s6q20whynoresponse_12",
               "s6q21whynoresponse_12",
               "s6q14_13",
               "s6q15awhynoresponse_13",
               "s6q15whynoresponse_13",
               "s6q16other_13",
               "s6q16whynoresponse_13",
               "s6q17whynoresponse_13",
               "s6q19whynoresponse_13",
               "s6q18other_13",
               "s6q18whynoresponse_13",
               "s6q19awhynoresponse_13",
               "s6q20whynoresponse_13",
               "s6q21whynoresponse_13",
               "s6q14_14",
               "s6q15awhynoresponse_14",
               "s6q15whynoresponse_14",
               "s6q16other_14",
               "s6q16whynoresponse_14",
               "s6q17whynoresponse_14",
               "s6q19whynoresponse_14",
               "s6q18other_14",
               "s6q18whynoresponse_14",
               "s6q19awhynoresponse_14",
               "s6q20whynoresponse_14",
               "s6q21whynoresponse_14",
               "s6q14_15",
               "s6q15awhynoresponse_15",
               "s6q15whynoresponse_15",
               "s6q16other_15",
               "s6q16whynoresponse_15",
               "s6q17whynoresponse_15",
               "s6q19whynoresponse_15",
               "s6q18other_15",
               "s6q18whynoresponse_15",
               "s6q19awhynoresponse_15",
               "s6q20whynoresponse_15",
               "s6q21whynoresponse_15",
               "s6q14_16",
               "s6q15awhynoresponse_16",
               "s6q15whynoresponse_16",
               "s6q16other_16",
               "s6q16whynoresponse_16",
               "s6q17whynoresponse_16",
               "s6q19whynoresponse_16",
               "s6q18other_16",
               "s6q18whynoresponse_16",
               "s6q19awhynoresponse_16",
               "s6q20whynoresponse_16",
               "s6q21whynoresponse_16",
               "s6q14_17",
               "s6q15awhynoresponse_17",
               "s6q15whynoresponse_17",
               "s6q16other_17",
               "s6q16whynoresponse_17",
               "s6q17whynoresponse_17",
               "s6q19whynoresponse_17",
               "s6q18other_17",
               "s6q18whynoresponse_17",
               "s6q19awhynoresponse_17",
               "s6q20whynoresponse_17",
               "s6q21whynoresponse_17",
               "s6q14_18",
               "s6q15awhynoresponse_18",
               "s6q15whynoresponse_18",
               "s6q16other_18",
               "s6q16whynoresponse_18",
               "s6q17whynoresponse_18",
               "s6q19whynoresponse_18",
               "s6q18other_18",
               "s6q18whynoresponse_18",
               "s6q19awhynoresponse_18",
               "s6q20whynoresponse_18",
               "s6q21whynoresponse_18",
               "s6q14_19",
               "s6q15awhynoresponse_19",
               "s6q15whynoresponse_19",
               "s6q16other_19",
               "s6q16whynoresponse_19",
               "s6q17whynoresponse_19",
               "s6q19whynoresponse_19",
               "s6q18other_19",
               "s6q18whynoresponse_19",
               "s6q19awhynoresponse_19",
               "s6q20whynoresponse_19",
               "s6q21whynoresponse_19",
               "s6q14_20",
               "s6q15awhynoresponse_20",
               "s6q15whynoresponse_20",
               "s6q16other_20",
               "s6q16whynoresponse_20",
               "s6q17whynoresponse_20",
               "s6q19whynoresponse_20",
               "s6q18other_20",
               "s6q18whynoresponse_20",
               "s6q19awhynoresponse_20",
               "s6q20whynoresponse_20",
               "s6q21whynoresponse_20",
               "s6q14_21",
               "s6q15awhynoresponse_21",
               "s6q15whynoresponse_21",
               "s6q16other_21",
               "s6q16whynoresponse_21",
               "s6q17whynoresponse_21",
               "s6q19whynoresponse_21",
               "s6q18other_21",
               "s6q18whynoresponse_21",
               "s6q19awhynoresponse_21",
               "s6q20whynoresponse_21",
               "s6q21whynoresponse_21",
               "s6q14_22",
               "s6q15awhynoresponse_22",
               "s6q15whynoresponse_22",
               "s6q16other_22",
               "s6q16whynoresponse_22",
               "s6q17whynoresponse_22",
               "s6q19whynoresponse_22",
               "s6q18other_22",
               "s6q18whynoresponse_22",
               "s6q19awhynoresponse_22",
               "s6q20whynoresponse_22",
               "s6q21whynoresponse_22",
               "s6q14_23",
               "s6q15awhynoresponse_23",
               "s6q15whynoresponse_23",
               "s6q16other_23",
               "s6q16whynoresponse_23",
               "s6q17whynoresponse_23",
               "s6q19whynoresponse_23",
               "s6q18other_23",
               "s6q18whynoresponse_23",
               "s6q19awhynoresponse_23",
               "s6q20whynoresponse_23",
               "s6q21whynoresponse_23",
               "s6q22whynoresponse",
               "s6q23whynoresponse",
               "s6q24whynoresponse",
               "s6q25whynoresponse",
               "s6q26whynoresponse",
               "s6q27whynoresponse",
               "s6q28whynoresponse",
               "s6q29whynoresponse",
               "s6q30whynoresponse",
               "s6q31whynoresponse",
               "s6q33",
               "s6q32whynoresponse",
               "s6q34whynoresponse",
               "s6q35whynoresponse")

report_open (list_open_ends = open_ends)



# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$s6q1whynoresponse[227] <- "The land was granted by the [LGU]."

mydata$s6q5_other[407] <- "Other"
mydata$s6q5_other[513] <- "Other"
mydata$s6q5_other[577] <- "Other"
mydata$s6q5_other[624] <- "Other"
mydata$s6q5_other[936] <- "Other"
mydata$s6q5_other[953] <- "Other"
mydata$s6q5_other[1010] <- "Other"
mydata$s6q5_other[1093] <- "Other"
mydata$s6q5_other[2000] <- "Other"
mydata$s6q5_other[2219] <- "Other"

mydata$s6q5whynoresponse[1073] <- "Other"

mydata$s6q9whynoresponse[30] <- "Out of [amount redacted] respondent only recieve [amount redacted]"
mydata$s6q9whynoresponse[1068] <- "Not definite. Depends on what owner of land asks for after assessment of harvest. Usually just a [percentage redacted]"

mydata$s6q12whynoresponse[16] <- "Other"
mydata$s6q12whynoresponse[333] <- "Other"

mydata$s6q14_1[531] <- "Other"
mydata$s6q14_1[696] <- "Other"
mydata$s6q14_1[709] <- "Other"
mydata$s6q14_1[865] <- "Other"
mydata$s6q14_1[904] <- "Other"
mydata$s6q14_1[992] <- "Other"
mydata$s6q14_1[1073] <- "Other"
mydata$s6q14_1[1235] <- "Other"
mydata$s6q14_1[1316] <- "Other"
mydata$s6q14_1[1331] <- "Other"
mydata$s6q14_1[1358] <- "Other"
mydata$s6q14_1[1421] <- "Other"
mydata$s6q14_1[1486] <- "Other"
mydata$s6q14_1[1520] <- "Other"
mydata$s6q14_1[1571] <- "Other"
mydata$s6q14_1[1641] <- "Other"
mydata$s6q14_1[1695] <- "Other"
mydata$s6q14_1[1699] <- "Other"
mydata$s6q14_1[1704] <- "Other"
mydata$s6q14_1[1715] <- "Other"
mydata$s6q14_1[1810] <- "Other"
mydata$s6q14_1[1814] <- "Other"
mydata$s6q14_1[1818] <- "Other"
mydata$s6q14_1[1901] <- "Other"
mydata$s6q14_1[1976] <- "Other"
mydata$s6q14_1[2132] <- "Other"
mydata$s6q14_1[2135] <- "Other"
mydata$s6q14_1[2228] <- "Other"


mydata$s6q16other_1[662] <- "Loan from family and friends"
mydata$s6q16other_1[671] <- "Loan from family and friends"
mydata$s6q16other_1[1514] <- "Loan from family and friends"
mydata$s6q16other_1[26] <- "Other"
mydata$s6q16other_1[55] <- "Other"
mydata$s6q16other_1[130] <- "Other"
mydata$s6q16other_1[131] <- "Other"
mydata$s6q16other_1[132] <- "Other"
mydata$s6q16other_1[262] <- "Other"
mydata$s6q16other_1[286] <- "Other"
mydata$s6q16other_1[290] <- "Other"
mydata$s6q16other_1[317] <- "Other"
mydata$s6q16other_1[320] <- "Other"
mydata$s6q16other_1[327] <- "Other"
mydata$s6q16other_1[332] <- "Other"
mydata$s6q16other_1[379] <- "Other"
mydata$s6q16other_1[422] <- "Other"
mydata$s6q16other_1[455] <- "Other"
mydata$s6q16other_1[459] <- "Other"
mydata$s6q16other_1[460] <- "Other"
mydata$s6q16other_1[475] <- "Other"
mydata$s6q16other_1[513] <- "Other"
mydata$s6q16other_1[564] <- "Other"
mydata$s6q16other_1[584] <- "Other"
mydata$s6q16other_1[587] <- "Other"
mydata$s6q16other_1[595] <- "Other"
mydata$s6q16other_1[596] <- "Other"
mydata$s6q16other_1[612] <- "Other"
mydata$s6q16other_1[614] <- "Other"
mydata$s6q16other_1[631] <- "Other"
mydata$s6q16other_1[638] <- "Other"
mydata$s6q16other_1[649] <- "Other"
mydata$s6q16other_1[650] <- "Other"
mydata$s6q16other_1[678] <- "Other"
mydata$s6q16other_1[686] <- "Other"
mydata$s6q16other_1[1367] <- "Other"
mydata$s6q16other_1[1389] <- "Other"
mydata$s6q16other_1[1395] <- "Other"
mydata$s6q16other_1[1542] <- "Other"
mydata$s6q16other_1[1588] <- "Other"
mydata$s6q16other_1[1686] <- "Other"
mydata$s6q16other_1[1824] <- "Other"
mydata$s6q16other_1[1825] <- "Other"
mydata$s6q16other_1[1828] <- "Other"
mydata$s6q16other_1[1832] <- "Other"
mydata$s6q16other_1[1904] <- "Other"
mydata$s6q16other_1[2082] <- "Other"
mydata$s6q16other_1[2129] <- "Other"
mydata$s6q16other_1[2134] <- "Other"
mydata$s6q16other_1[2215] <- "Other"
mydata$s6q16other_1[2219] <- "Other"

mydata$s6q18other_1[799] <- "Other"
mydata$s6q18other_1[840] <- "Other"
mydata$s6q18other_1[904] <- "Other"
mydata$s6q18other_1[952] <- "Other"
mydata$s6q18other_1[1358] <- "Other"
mydata$s6q18other_1[1501] <- "Other"

mydata$s6q14_2[17] <- "Other"
mydata$s6q14_2[116] <- "Other"
mydata$s6q14_2[701] <- "Other"
mydata$s6q14_2[709] <- "Other"
mydata$s6q14_2[760] <- "Other"
mydata$s6q14_2[778] <- "Other"
mydata$s6q14_2[941] <- "Other"
mydata$s6q14_2[1057] <- "Other"
mydata$s6q14_2[1073] <- "Other"
mydata$s6q14_2[1205] <- "Other"
mydata$s6q14_2[1235] <- "Other"
mydata$s6q14_2[1299] <- "Other"
mydata$s6q14_2[1313] <- "Other"
mydata$s6q14_2[1316] <- "Other"
mydata$s6q14_2[1340] <- "Other"
mydata$s6q14_2[1347] <- "Other"
mydata$s6q14_2[1417] <- "Other"
mydata$s6q14_2[1421] <- "Other"
mydata$s6q14_2[1476] <- "Other"
mydata$s6q14_2[1520] <- "Other"
mydata$s6q14_2[1553] <- "Other"
mydata$s6q14_2[1698] <- "Other"
mydata$s6q14_2[1744] <- "Other"
mydata$s6q14_2[2000] <- "Other"
mydata$s6q14_2[2024] <- "Other"
mydata$s6q14_2[2136] <- "Other"
mydata$s6q14_2[2138] <- "Other"
mydata$s6q14_2[2139] <- "Other"
mydata$s6q14_2[2221] <- "Other"

mydata$s6q16other_2[132] <- "Other"
mydata$s6q16other_2[290] <- "Other"
mydata$s6q16other_2[327] <- "Other"
mydata$s6q16other_2[459] <- "Other"
mydata$s6q16other_2[466] <- "Other"
mydata$s6q16other_2[580] <- "Other"
mydata$s6q16other_2[593] <- "Other"
mydata$s6q16other_2[599] <- "Other"
mydata$s6q16other_2[627] <- "Other"
mydata$s6q16other_2[666] <- "Other"
mydata$s6q16other_2[1828] <- "Other"
mydata$s6q16other_2[2218] <- "Other"

mydata$s6q18other_2[638] <- "Other"
mydata$s6q18other_2[657] <- "Other"
mydata$s6q18other_2[675] <- "Other"
mydata$s6q18other_2[1068] <- "Other"
mydata$s6q18other_2[1113] <- "Other"
mydata$s6q18other_2[1905] <- "Other"

mydata$s6q18other_3[1367] <- "Other"
mydata$s6q18other_3[1831] <- "Other"
mydata$s6q18other_3[2268] <- "Other"

mydata$s6q18other_4[1345] <- "Other"
mydata$s6q18other_4[1367] <- "Other"
mydata$s6q18other_4[1831] <- "Other"

mydata$s6q19awhynoresponse_5[1235] <- "[Language]"

mydata$s6q14_12[1477] <- "[Language]"

mydata$s6q14_21[1477] <- "[Language]"

mydata$s6q14_23[1477] <- "[Language]"

mydata$s6q24whynoresponse[2046] <- "He only knows the total amount which is [amount redacted] for 12 months"

mydata$s6q26whynoresponse[2046] <- "He only knows the total amount which is [amount redacted] for 12 months"

mydata$s6q30whynoresponse[1085] <- "Only the hudband and wife are working in the farm and also there son [name]"
mydata$s6q30whynoresponse[2046] <- "He only knows the total amount which is [amount redacted] in 12 months"




#'# GPS data: Displace
# !!!No GPS data


#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
