#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_2" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables

# !!!Include any Direct PII variables
dropvars <- c("name") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

# Recode education attainment of adults to reduce risk of re-identification 

break_edu <- c(0:16, 17,20,26)
labels_edu <- c("Pre-Kinder"=1,
                "Kinder"=2,
                "1st Grade"=4,
                "2nd Grade"=5,
                "3rd Grade"=6,
                "4th Grade"=7,
                "5th Grade"=8,
                "6th Grade"=10,
                "7th Grade"=11,
                "8th Grade"=12,
                "9th Grade"=13,
                "10th Grade"=14,
                "11th Grade"=15,
                "12th Grade"=16,
                "High School Graduate"=17,
                "Vocational training or associates degree"=18,
                "Some college or higher"=19)

mydata <- ordinal_recode (variable="s2q7", break_points=break_edu, missing=999999, value_labels=labels_edu)
mydata <- top_recode ("s2q3", break_point=70, missing=c(888, 999999))

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("s2q4",
                  "s2q5",
                  "s2q7",
                  "s2q8",
                  "s2q9",
                  "s2q10",
                  "s2q11")

capture_tables (indirect_PII)


# Recode those with very specific values. 

break_mstatus <- c(-999,-888,1,2,7,8)
labels_mstatus <- c("No Response"=1,
                "Other" = 2,
                "Married Living with Spouse" = 3,
                "Other" = 4,
                "Not married but comitted" = 5,
                "Single"= 6)
mydata <- ordinal_recode (variable="s2q5", break_points=break_mstatus, missing=999999, value_labels=labels_mstatus)

# Recode over-specifc activities with few members for adults

haven_table("s2q8")


range <- 1:length(mydata$s2q3)

for (i in range){
  if(is.na(mydata$s2q3[i])==FALSE){
  if(mydata$s2q3[i]>17){
    if(is.na(mydata$s2q8[i])==FALSE){
    if(mydata$s2q8[i]==1|mydata$s2q8[i]==2|mydata$s2q8[i]==3|mydata$s2q8[i]==4|mydata$s2q8[i]==5|mydata$s2q8[i]==6){
      mydata$s2q8[i]<- 7
    }
    if(mydata$s2q8[i]!=7 & mydata$s2q8[i]!=15 & mydata$s2q8[i]!=16 & mydata$s2q8[i]!=91){
      mydata$s2q8[i] <- -888
    }
    }
  }
  }
}

haven_table("s2q8")


#'# Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('s2q3', 's2q4', 's2q7') ##!!! Replace with candidate categorical demo vars


# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("s2q2whynoresponse",
               "s2q3whynoresponse",
               "s2q4whynoresponse",
               "s2q5whynoresponse",
               "s2q6whynoresponse",
               "s2q7_other",
               "s2q7whynoresponse",
               "s2q8_other",
               "s2q8whynoresponse",
               "s2q9whynoresponse",
               "s2q10whynoresponse",
               "s2q11_other",
               "s2q11whynoresponse",
               "s2q12whynoresponse",
               "s2q13whynoresponse",
               "s2q14whynoresponse",
               "s2q15whynoresponse",
               "s2q16whynoresponse")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$s2q8_other[29] <- "[name] stays at [city] for almost 2yrs from now. [name]is having a vacation twice a month in their house here in [site]."
mydata$s2q8_other[44] <- "[work]"
mydata$s2q8_other[45] <- "farmer"
mydata$s2q8_other[48] <- "driver"
mydata$s2q8_other[108] <- "She is studying in [college]"
mydata$s2q8_other[147] <- "farming"
mydata$s2q8_other[156] <- "Professor"
mydata$s2q8_other[162] <- "cutting"
mydata$s2q8_other[163] <- "Sister of [name]"
mydata$s2q8_other[189] <- "driver"
mydata$s2q8_other[205] <- "[work]"
mydata$s2q8_other[207] <- "Cashier"
mydata$s2q8_other[227] <- "Factory worker "
mydata$s2q8_other[239] <- "Factory worker "
mydata$s2q8_other[249] <- "Installation "
mydata$s2q8_other[313] <- "conductor"
mydata$s2q8_other[324] <- "[work]"
mydata$s2q8_other[339] <- "[work]"
mydata$s2q8_other[366] <- "dealer"
mydata$s2q8_other[461] <- "[object] making"
mydata$s2q8_other[477] <- "driver"
mydata$s2q8_other[496] <- "vendor"
mydata$s2q8_other[545] <- "Farming"
mydata$s2q8_other[548] <- "[work]"
mydata$s2q8_other[582] <- "[work]"
mydata$s2q8_other[650] <- "[work]"

mydata$s2q9whynoresponse[304] <- "[situation]"

mydata$s2q11_other[86] <- "Factory worker in [city]"
mydata$s2q11_other[97] <- "[Tagalo]"
mydata$s2q11_other[98] <- "[work]"
mydata$s2q11_other[108] <- "She is studying in [college]"
mydata$s2q11_other[118] <- "[Tagalo]"
mydata$s2q11_other[162] <- "[work]"
mydata$s2q11_other[249] <- "Installation"
mydata$s2q11_other[330] <- "[work]"
mydata$s2q11_other[412] <- "[vehicle]helper(logistic)"
mydata$s2q11_other[419] <- "[situation]"
mydata$s2q11_other[422] <- "[vehicle] helper"
mydata$s2q11_other[464] <- "[level] Teacher"
mydata$s2q11_other[537] <- "[work]"
mydata$s2q11_other[545] <- "[work]"
mydata$s2q11_other[555] <- "[Tagalo]"
mydata$s2q11_other[582] <- "Barangay [worker]"
mydata$s2q11_other[627] <- "[work]"
mydata$s2q11_other[646] <- "[vehicle] driver"
mydata$s2q11_other[655] <- "[vehicle] conductor"

mydata$s2q11whynoresponse[122] <- "At [province]"
mydata$s2q11whynoresponse[256] <- "[name] is not aware of his parent in law's whereabouts."
mydata$s2q11whynoresponse[304] <- "Not working, currently [situation]"
mydata$s2q11whynoresponse[562] <- "[name] is currently [situation]"

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
