#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "Section_1" # !!!Update filename
functions_vers <-  "functions_1.8.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables
# !!!No Direct PII

#'# Direct PII-team: Encode field team names
# !!!No Direct PII-team

#'# Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small locations

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

# Recode education attainment of adults to reduce risk of re-identification 

break_edu <- c(-999,0,9,10,11,12,13,14,15,16,17)
labels_edu <- c("No Response"=1,
                "5th or less" = 2,
                "6th Grade" = 3,
                "7th Grade" = 4,
                "8th Grade" = 5,
                "9th Grade" = 6,
                "10th Grade" = 7,
                "11th Grade" = 8,
                "12th Grade"= 9,
                "High Scholl Graduate"= 10,
                "1st Year Vocational training or more"=11)
mydata <- ordinal_recode (variable="s1q45", break_points=break_edu, missing=999999, value_labels=labels_edu)

break_edu <- c(-999,0,9,10,11,12,13,14,15,16,17)
labels_edu <- c("No Response"=1,
                "5th or less" = 2,
                "6th Grade" = 3,
                "7th Grade" = 4,
                "8th Grade" = 5,
                "9th Grade" = 6,
                "10th Grade" = 7,
                "11th Grade" = 8,
                "12th Grade"= 9,
                "High Scholl Graduate"= 10,
                "1st Year Vocational training or more"=11)
mydata <- ordinal_recode (variable="s1q53", break_points=break_edu, missing=999999, value_labels=labels_edu)

# Top code high ages

mydata <- top_recode ("s1q3", break_point=60, missing=c(888, 999999)) # Topcode 60 or more
mydata <- bottom_recode ("s1q2", break_point=1955, missing=c(888, 999999)) # Bottom code 1960 or lower
mydata <- top_recode ("age0", break_point=60, missing=c(888, 999999)) #Topcode 60 or more

# mydata <- top_recode ("age0", break_point=61, missing=c(888, 999999))

#'# Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("gender",
                  "s1q5",
                  "s1q8als",
                  "s1q9",
                  "s1q11",
                  "s1q19",
                  "s1q20",
                  "s1q21",
                  "s1q22",
                  "s1q23",
                  "s1q24",
                  "s1q25",
                  "s1q26",
                  "s1q30",
                  "s1q31",
                  "s1q33",
                  "s1q36",
                  "s1q38",
                  "s1q40",
                  "s1q42",
                  "s1q46",
                  "s1q47",
                  "s1q48",
                  "s1q50",
                  "s1q54",
                  "s1q55")

capture_tables (indirect_PII)

# Recode those with very specific values. 

break_mstatus <- c(-999,-888,1,2,4,5,6,7,8)
labels_mstatus <- c("No Response"=1,
                "Other" = 2,
                "Married Living with Spouse" = 3,
                "Married Not Living with Spouse" = 4,
                "Other" = 5,
                "Separated" = 6,
                "Widow" = 7,
                "Not married but comitted" = 8,
                "Single"= 9)
mydata <- ordinal_recode (variable="s1q5", break_points=break_mstatus, missing=999999, value_labels=labels_mstatus)

break_activity <- c(-999,-888,1,16,17,91)
labels_activity <- c("No Response"=1,
                    "Other: Specify" = 2,
                    "Other" = 3,
                    "Domestic Work" = 4,
                    "Other" = 5,
                    "Principally performs chores and other unpaid household services for own household" = 6)
mydata <- ordinal_recode (variable="s1q47", break_points=break_activity, missing=999999, value_labels=labels_activity)

break_activity <- c(-999,-888,1,15,16,47,48)
labels_activity <- c("No Response"=1,
                     "Other: Specify" = 2,
                     "Other" = 3,
                     "Construction" = 4,
                     "Other" = 5,
                     "Motor Vehicle Drivers" = 6,
                     "Other"=7)
mydata <- ordinal_recode (variable="s1q55", break_points=break_activity, missing=999999, value_labels=labels_activity)

#'# Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('gender', 's1q3', 's1q8') ##!!! Replace with candidate categorical demo vars


# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#'# Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("s1q2noresponse", 
               "s1q5noresponse", 
               "s1q6noresponse", 
               "s1q7noresponse", 
               "s1q8_other", 
               "s1q8noresponse", 
               "s1q9noresponse", 
               "s1q10_other", 
               "s1q10noresponse", 
               "s1q11other", 
               "s1q11noresponse", 
               "s1q12noresponse", 
               "s1q13noresponse", 
               "s1q14noresponse", 
               "s1q15noresponse", 
               "s1q16_other", 
               "s1q16noresponse", 
               "s1q17_other", 
               "s1q17noresponse", 
               "s1q18_other", 
               "s1q18noresponse", 
               "s1q19noresponse", 
               "s1q20noresponse", 
               "s1q21noresponse", 
               "s1q22noresponse", 
               "s1q23noresponse", 
               "s1q24noresponse", 
               "s1q25noresponse", 
               "s1q26noresponse", 
               "s1q27noresponse", 
               "s1q28noresponse", 
               "s1q29noresponse", 
               "s1q30noresponse", 
               "s1q31_other", 
               "s1q31noresponse", 
               "s1q32noresponse", 
               "s1q33noresponse", 
               "s1q34", 
               "s1q34other", 
               "s1q34noresponse", 
               "s1q35", 
               "s1q35noresponse", 
               "s1q36noresponse", 
               "s1q37noresponse", 
               "s1q38noresponse", 
               "s1q39noresponse", 
               "s1q40noresponse", 
               "s1q41noresponse", 
               "s1q42noresponse", 
               "s1q43noresponse", 
               "s1q44noresponse", 
               "s1q45_other", 
               "s1q45noresponse", 
               "s1q46noresponse", 
               "s1q47_other", 
               "s1q47noresponse", 
               "s1q48noresponse", 
               "s1q49noresponse", 
               "s1q50noresponse", 
               "s1q51noresponse", 
               "s1q52noresponse", 
               "s1q53_other", 
               "s1q53noresponse", 
               "s1q54noresponse", 
               "s1q55_other", 
               "s1q55noresponse")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 

mydata$s1q5noresponse[6546] <- "[Sensitive information redacted]"
mydata$s1q5noresponse[6548] <- "[Sensitive information redacted]"
mydata$s1q8_other[254] <- "[Trade redacted]"
mydata$s1q8_other[440] <- "[Disability redacted]"
mydata$s1q8_other[650] <- "[Illness redacted]"
mydata$s1q8_other[1145] <- "Did not attend school because she is [disability redacted]"
mydata$s1q8_other[1420] <- "[Disability redacted]"
mydata$s1q8_other[3676] <- "[Trade redacted]"
mydata$s1q8_other[4617] <- "3 years vocational [Trade redacted]"
mydata$s1q8_other[5073] <- "6 months [Trade redacted] tesda"
mydata$s1q8_other[5886] <- "Don't know the level because [disability redacted] already 3 years schooling in SPED"
mydata$s1q8_other[7184] <- "[Disability redacted]"
mydata$s1q8_other[8276] <- "The child is [Disability redacted] so she stop studying"
mydata$s1q8_other[14204] <- "Was not able to go to school.[Disability redacted] according to the mother."
mydata$s1q8noresponse[96] <- "[Disability redacted]"
mydata$s1q8noresponse[132] <- "[Disability redacted]"
mydata$s1q8noresponse[4262] <- "[Disability redacted]"
mydata$s1q8noresponse[5308] <- "[Tagalo]"
mydata$s1q8noresponse[5904] <- "[Disability redacted]"
mydata$s1q8noresponse[7353] <- "[Disability redacted]"
mydata$s1q8noresponse[8232] <- "[Name] is 2 years old only."
mydata$s1q8noresponse[13238] <- "[Tagalo]"
mydata$s1q8noresponse[14371] <- "Inborn with [illness redacted]"
mydata$s1q8noresponse[14445] <- "[Tagalo]"
mydata$s1q12noresponse[8645] <- "[Relative]"
mydata$s1q13noresponse[4389] <- "[Tagalo]"
mydata$s1q13noresponse[6613] <- "[Name] cannot estimate the real amount of the total expenses because the school where [name] is enrolled is for free."
mydata$s1q17noresponse[13466] <- "The respondent do not know as she did not ask about [name]'s dreams in the future."
mydata$s1q18noresponse[1033] <- "They can not tell because she has [illness redacted]. She sometimes go to school but stop whenever she likes."
mydata$s1q18noresponse[7433] <- "[Name] cant answer the question because she dont know if she can send grace to school because of financial problem."
mydata$s1q27noresponse[1857] <- "Dont know because [name] was an ofw last year"
mydata$s1q27noresponse[3631] <- "No idea coz he works as [profession redacted] no standard time a day per week"
mydata$s1q27noresponse[6825] <- "He is a [profession redacted] based in Zamboaga City"
mydata$s1q27noresponse[6828] <- "She is still studying in [city redacted]"
mydata$s1q27noresponse[6930] <- "No idea how much [name] spent in planting before..."
mydata$s1q27noresponse[9217] <- "The respondent dont know the answer because [name] work outside of the community."
mydata$s1q27noresponse[9223] <- "The respondent dont know because [name] work outside of the community"
mydata$s1q28noresponse[1362] <- "[name] is working in another town."
mydata$s1q28noresponse[6720] <- "[name] has a water and gas range."
mydata$s1q28noresponse[6721] <- "[name] has a water"
mydata$s1q29noresponse[1362] <- "[name] is working in another town. Goes home once a month."
mydata$s1q29noresponse[9222] <- "The respondent dont know because [name] seldom cleaning there house."

mydata$s1q31_other[9308] <- "[Domestic work]"
mydata$s1q31_other[2724] <- "[Other]"
mydata$s1q31_other[5199] <- "[Other]"
mydata$s1q31_other[9494] <- "[Other]"
mydata$s1q31_other[2563] <- "[Other]"
mydata$s1q31_other[4883] <- "[Other]"
mydata$s1q31_other[5064] <- "[Other]"
mydata$s1q31_other[6038] <- "[Other]"
mydata$s1q31_other[6380] <- "[Other]"
mydata$s1q31_other[1443] <- "[Other]"
mydata$s1q31_other[2415] <- "[Other]"
mydata$s1q31_other[1134] <- "[Other]"
mydata$s1q31_other[5354] <- "[Other]"
mydata$s1q31_other[11311] <- "[Other]"
mydata$s1q31_other[1136] <- "[Other]"
mydata$s1q31_other[5405] <- "[Other]"
mydata$s1q31_other[1935] <- "[Other]"
mydata$s1q31_other[1630] <- "[Other]"
mydata$s1q31_other[1656] <- "[Other]"
mydata$s1q31_other[1938] <- "[Other]"
mydata$s1q31_other[1949] <- "[Other]"
mydata$s1q31_other[4794] <- "[Other]"
mydata$s1q31_other[13349] <- "[Other]"
mydata$s1q31_other[1331] <- "[Other]"
mydata$s1q31_other[1332] <- "[Other]"
mydata$s1q31_other[7009] <- "[Other]"
mydata$s1q31_other[6700] <- "[Other]"
mydata$s1q31_other[681] <- "[Other]"
mydata$s1q31_other[7403] <- "[Other]"
mydata$s1q31_other[12133] <- "[Other]"
mydata$s1q31_other[6955] <- "[Other]"
mydata$s1q31_other[2992] <- "[Other]"
mydata$s1q31_other[10810] <- "[Other]"
mydata$s1q31_other[12656] <- "[Other]"
mydata$s1q31_other[8543] <- "[Other]"
mydata$s1q31_other[2960] <- "[Other]"
mydata$s1q31_other[3013] <- "[Other]"
mydata$s1q31_other[3015] <- "[Other]"
mydata$s1q31_other[5600] <- "[Other]"
mydata$s1q31_other[458] <- "[Other]"
mydata$s1q31_other[8800] <- "[Other]"
mydata$s1q31_other[13566] <- "[Other]"
mydata$s1q31_other[8352] <- "[Other]"
mydata$s1q31_other[3962] <- "[Other]"
mydata$s1q31_other[11684] <- "[Other]"
mydata$s1q31_other[1333] <- "[Other]"
mydata$s1q31_other[1817] <- "[Other]"
mydata$s1q31_other[1909] <- "[Other]"
mydata$s1q31_other[11921] <- "[Other]"
mydata$s1q31_other[4367] <- "[Other]"
mydata$s1q31_other[8059] <- "[Other]"
mydata$s1q31_other[10886] <- "[Other]"
mydata$s1q31_other[2444] <- "[Other]"
mydata$s1q31_other[11050] <- "[Other]"
mydata$s1q31_other[6329] <- "[Other]"
mydata$s1q31_other[6830] <- "[Other]"
mydata$s1q31_other[13840] <- "[Other]"
mydata$s1q31_other[12826] <- "[Other]"
mydata$s1q31_other[2175] <- "[Other]"
mydata$s1q31_other[11591] <- "[Other]"
mydata$s1q31_other[5081] <- "[Other]"
mydata$s1q31_other[5503] <- "[Other]"
mydata$s1q31_other[12283] <- "[Other]"
mydata$s1q31_other[4654] <- "[Other]"
mydata$s1q31_other[5122] <- "[Other]"
mydata$s1q31_other[5126] <- "[Other]"
mydata$s1q31_other[5754] <- "[Other]"
mydata$s1q31_other[6050] <- "[Other]"
mydata$s1q31_other[6125] <- "[Other]"
mydata$s1q31_other[5150] <- "[Other]"
mydata$s1q31_other[5180] <- "[Other]"
mydata$s1q31_other[5203] <- "[Other]"
mydata$s1q31_other[5329] <- "[Other]"
mydata$s1q31_other[5355] <- "[Other]"
mydata$s1q31_other[5571] <- "[Other]"
mydata$s1q31_other[5573] <- "[Other]"
mydata$s1q31_other[5609] <- "[Other]"
mydata$s1q31_other[5625] <- "[Other]"
mydata$s1q31_other[5934] <- "[Other]"
mydata$s1q31_other[6007] <- "[Other]"
mydata$s1q31_other[6381] <- "[Other]"
mydata$s1q31_other[8449] <- "[Other]"
mydata$s1q31_other[8979] <- "[Other]"
mydata$s1q31_other[6340] <- "[Other]"
mydata$s1q31_other[5152] <- "[Other]"
mydata$s1q31_other[6921] <- "[Other]"
mydata$s1q31_other[11897] <- "[Other]"
mydata$s1q31_other[6655] <- "[Other]"
mydata$s1q31_other[180] <- "[Other]"
mydata$s1q31_other[465] <- "[Other]"
mydata$s1q31_other[5724] <- "[Other]"
mydata$s1q31_other[12455] <- "[Other]"
mydata$s1q31_other[6361] <- "[Other]"
mydata$s1q31_other[9320] <- "[Other]"
mydata$s1q31_other[5124] <- "[Other]"
mydata$s1q31_other[6396] <- "[Other]"
mydata$s1q31_other[8845] <- "[Other]"
mydata$s1q31_other[8487] <- "[Other]"
mydata$s1q31_other[639] <- "[Other]"
mydata$s1q31_other[640] <- "[Other]"
mydata$s1q31_other[1329] <- "[Other]"
mydata$s1q31_other[13042] <- "[Other]"
mydata$s1q31_other[788] <- "[Other]"
mydata$s1q31_other[784] <- "[Other]"
mydata$s1q31_other[787] <- "[Other]"
mydata$s1q31_other[9377] <- "[Other]"
mydata$s1q31_other[6043] <- "[Other]"
mydata$s1q31_other[6501] <- "[Other]"
mydata$s1q31_other[8124] <- "[Other]"
mydata$s1q31_other[8046] <- "[Other]"
mydata$s1q31_other[9582] <- "[Other]"
mydata$s1q31_other[7158] <- "[Other]"
mydata$s1q31_other[9349] <- "[Other]"
mydata$s1q31_other[4071] <- "[Other]"
mydata$s1q31_other[4873] <- "[Other]"
mydata$s1q31_other[5363] <- "[Other]"
mydata$s1q31_other[13151] <- "[Other]"
mydata$s1q31_other[7425] <- "[Other]"
mydata$s1q31_other[13567] <- "[Other]"
mydata$s1q31_other[5213] <- "[Other]"
mydata$s1q31_other[10432] <- "[Other]"
mydata$s1q31_other[6895] <- "[Other]"
mydata$s1q31_other[12428] <- "[Other]"
mydata$s1q31_other[1779] <- "[Other]"
mydata$s1q31_other[13879] <- "[Other]"
mydata$s1q31_other[9409] <- "[Other]"
mydata$s1q31_other[4625] <- "[Other]"
mydata$s1q31_other[6189] <- "[Other]"
mydata$s1q31_other[6210] <- "[Other]"
mydata$s1q31_other[5079] <- "[Other]"
mydata$s1q31_other[5078] <- "[Other]"
mydata$s1q31_other[4302] <- "[Other]"
mydata$s1q31_other[7737] <- "[Other]"
mydata$s1q31_other[13324] <- "[Other]"
mydata$s1q31_other[3028] <- "[Other]"
mydata$s1q31_other[9712] <- "[Other]"
mydata$s1q31_other[14442] <- "[Other]"
mydata$s1q31_other[4323] <- "[Other]"
mydata$s1q31_other[9078] <- "[Other]"
mydata$s1q31_other[6151] <- "[Other]"
mydata$s1q31_other[490] <- "[Other]"
mydata$s1q31_other[493] <- "[Other]"
mydata$s1q31_other[4944] <- "[Other]"
mydata$s1q31_other[59] <- "[Other]"
mydata$s1q31_other[62] <- "[Other]"
mydata$s1q31_other[7932] <- "[Other]"
mydata$s1q31_other[8076] <- "[Other]"
mydata$s1q31_other[5831] <- "[Other]"
mydata$s1q31_other[3072] <- "[Other]"
mydata$s1q31_other[13932] <- "[Other]"
mydata$s1q31_other[9381] <- "[Other]"
mydata$s1q31_other[11585] <- "[Other]"
mydata$s1q31_other[13041] <- "[Other]"
mydata$s1q31_other[6383] <- "[Other]"
mydata$s1q31_other[5374] <- "[Other]"
mydata$s1q31_other[318] <- "[Other]"
mydata$s1q31_other[1439] <- "[Other]"
mydata$s1q31_other[902] <- "[Other]"
mydata$s1q31_other[903] <- "[Other]"
mydata$s1q31_other[5786] <- "[Other]"
mydata$s1q31_other[462] <- "[Other]"
mydata$s1q31_other[4645] <- "[Other]"
mydata$s1q31_other[4754] <- "[Other]"
mydata$s1q31_other[5682] <- "[Other]"
mydata$s1q31_other[7045] <- "[Other]"
mydata$s1q31_other[6465] <- "[Other]"
mydata$s1q31_other[6467] <- "[Other]"
mydata$s1q31_other[6119] <- "[Other]"
mydata$s1q31_other[1127] <- "[Other]"
mydata$s1q31_other[3581] <- "[Other]"
mydata$s1q31_other[7530] <- "[Other]"
mydata$s1q31_other[800] <- "[Other]"
mydata$s1q31_other[14265] <- "[Other]"
mydata$s1q31_other[12314] <- "[Other]"
mydata$s1q31_other[6837] <- "[Other]"
mydata$s1q31_other[4924] <- "[Other]"
mydata$s1q31_other[9224] <- "[Other]"
mydata$s1q31_other[5702] <- "[Other]"
mydata$s1q31_other[12451] <- "[Other]"
mydata$s1q31_other[10805] <- "[Other]"
mydata$s1q31_other[12221] <- "[Other]"
mydata$s1q31_other[4874] <- "[Other]"
mydata$s1q31_other[1283] <- "[Other]"
mydata$s1q31_other[5736] <- "[Other]"
mydata$s1q31_other[2609] <- "[Other]"
mydata$s1q31_other[3061] <- "[Other]"
mydata$s1q31_other[9968] <- "[Other]"
mydata$s1q31_other[3894] <- "[Other]"
mydata$s1q31_other[2558] <- "[Other]"
mydata$s1q31_other[8399] <- "[Other]"
mydata$s1q31_other[7676] <- "Driver"
mydata$s1q31_other[12015] <- "Driver"
mydata$s1q31_other[3750] <- "Driver"
mydata$s1q31_other[423] <- "Driver"
mydata$s1q31_other[6921] <- "Driver"
mydata$s1q31_other[11897] <- "Driver"
mydata$s1q31_other[13342] <- "Driver"
mydata$s1q31_other[9601] <- "Driver"
mydata$s1q31_other[13449] <- "Driver"
mydata$s1q31_other[636] <- "Driver"
mydata$s1q31_other[4518] <- "Driver"
mydata$s1q31_other[8788] <- "Driver"
mydata$s1q31_other[10253] <- "Driver"
mydata$s1q31_other[13177] <- "Driver"
mydata$s1q31_other[13193] <- "Driver"


mydata$s1q34other[119] <- "[Illness]"
mydata$s1q34other[510] <- "[Illness]"
mydata$s1q34other[650] <- "[Illness]"
mydata$s1q34other[666] <- "[Illness]"
mydata$s1q34other[773] <- "[Tagalo]"
mydata$s1q34other[1388] <- "[Illness]"
mydata$s1q34other[1647] <- "[Illness]"
mydata$s1q34other[3114] <- "[Tagalo]"
mydata$s1q34other[3207] <- "[Illness]"
mydata$s1q34other[4267] <- "[Illness]"
mydata$s1q34other[4363] <- "[Illness]"
mydata$s1q34other[4988] <- "[Illness]"
mydata$s1q34other[5284] <- "[Illness]"
mydata$s1q34other[5717] <- "[Illness]"
mydata$s1q34other[5871] <- "[Illness]"
mydata$s1q34other[5908] <- "[Illness]"
mydata$s1q34other[6066] <- "[Tagalo]"
mydata$s1q34other[6213] <- "[Illness]"
mydata$s1q34other[6754] <- "[Illness]"
mydata$s1q34other[7160] <- "[Tagalo]"
mydata$s1q34other[7922] <- "[Illness]"
mydata$s1q34other[8118] <- "[Illness]"
mydata$s1q34other[9668] <- "[Tagalo]"
mydata$s1q34other[10617] <- "[Illness]"
mydata$s1q34other[10768] <- "[Tagalo]"
mydata$s1q34other[10990] <- "[Tagalo]"
mydata$s1q34other[10994] <- "[Tagalo]"
mydata$s1q34other[11183] <- "[Illness]"
mydata$s1q34other[11274] <- "[Illness]"
mydata$s1q34other[11905] <- "[Illness]"
mydata$s1q34other[12081] <- "[Illness]"
mydata$s1q34other[12850] <- "[Tagalo]"
mydata$s1q34other[13633] <- "[Illness]"
mydata$s1q34other[14250] <- "[Illness]"
mydata$s1q34other[14509] <- "[Illness]"
mydata$s1q34other[14551] <- "[Illness]"

mydata$s1q35noresponse[7560] <- "[Illness]"
mydata$s1q35noresponse[11949] <- "[Illness]"

mydata$s1q38noresponse[6736] <- "[name] does not seek for doctor's advise."
mydata$s1q38noresponse[6738] <- "[name] does not consult a doctor, that is the reason why she did not answer."
mydata$s1q38noresponse[6739] <- "[name] does not consult a physician."

mydata$s1q39noresponse[839] <- "[amount] was paid by their relatives. They asked help for him to be treated. He was [illness]. Last April 10 he had a [illness] again."
mydata$s1q39noresponse[5605] <- "She is pregnant [time], she dont take any meds"
mydata$s1q39noresponse[9441] <- "[Tagalo]"

mydata$s1q42noresponse[11960] <- "[Tagalo]"

mydata$s1q44noresponse[7053] <- "[Vietnamita]"
mydata$s1q44noresponse[7461] <- "She is staying in the house of her boyfriend [name]"
mydata$s1q44noresponse[7472] <- "With other family just visiting [name] sometimes"
mydata$s1q44noresponse[7659] <- "[names] is grown up with care of there Grand Mother [name], and only visited by there mother"
mydata$s1q44noresponse[7660] <- "Since birth [name] is in the care of his grand mother [name], and his mother is only visiting him."
mydata$s1q44noresponse[7661] <- "He grown with his grand mother [name] since birth also same with [name], his mother only visiting him"
mydata$s1q44noresponse[7763] <- "His parent is in a diffetent house but thr respondent is one who feed and raise [name] until now"

mydata$s1q47_other[790] <- "[Other]"
mydata$s1q47_other[1146] <- "[Other]"
mydata$s1q47_other[1999] <- "[Other]"
mydata$s1q47_other[2003] <- "[Other]"
mydata$s1q47_other[2077] <- "[Other]"
mydata$s1q47_other[2078] <- "[Other]"
mydata$s1q47_other[2079] <- "[Other]"
mydata$s1q47_other[2125] <- "[Other]"
mydata$s1q47_other[3436] <- "[Other]"
mydata$s1q47_other[3552] <- "[Other]"
mydata$s1q47_other[3563] <- "[Other]"
mydata$s1q47_other[3583] <- "[Other]"
mydata$s1q47_other[3663] <- "[Other]"
mydata$s1q47_other[3834] <- "[Other]"
mydata$s1q47_other[4043] <- "[Other]"
mydata$s1q47_other[4045] <- "[Other]"
mydata$s1q47_other[4381] <- "[Other]"
mydata$s1q47_other[4481] <- "[Other]"
mydata$s1q47_other[4639] <- "[Other]"
mydata$s1q47_other[4640] <- "[Other]"
mydata$s1q47_other[4665] <- "[Other]"
mydata$s1q47_other[4666] <- "[Other]"
mydata$s1q47_other[4724] <- "[Other]"
mydata$s1q47_other[4725] <- "[Other]"
mydata$s1q47_other[4726] <- "[Other]"
mydata$s1q47_other[4863] <- "[Other]"
mydata$s1q47_other[4865] <- "[Other]"
mydata$s1q47_other[4920] <- "[Other]"
mydata$s1q47_other[5004] <- "[Other]"
mydata$s1q47_other[5070] <- "[Other]"
mydata$s1q47_other[5072] <- "[Other]"
mydata$s1q47_other[5096] <- "[Other]"
mydata$s1q47_other[5328] <- "[Other]"
mydata$s1q47_other[5366] <- "[Other]"
mydata$s1q47_other[5470] <- "[Other]"
mydata$s1q47_other[5649] <- "[Other]"
mydata$s1q47_other[6119] <- "[Other]"
mydata$s1q47_other[6358] <- "[Other]"
mydata$s1q47_other[6692] <- "[Other]"
mydata$s1q47_other[6745] <- "[Other]"
mydata$s1q47_other[6892] <- "[Other]"
mydata$s1q47_other[7007] <- "[Other]"
mydata$s1q47_other[7467] <- "[Other]"
mydata$s1q47_other[7472] <- "[Other]"
mydata$s1q47_other[7505] <- "[Other]"
mydata$s1q47_other[7659] <- "[Other]"
mydata$s1q47_other[7660] <- "[Other]"
mydata$s1q47_other[7661] <- "[Other]"
mydata$s1q47_other[7762] <- "[Other]"
mydata$s1q47_other[7763] <- "[Other]"
mydata$s1q47_other[7862] <- "[Other]"
mydata$s1q47_other[7875] <- "[Other]"
mydata$s1q47_other[7973] <- "[Other]"
mydata$s1q47_other[8011] <- "[Other]"
mydata$s1q47_other[8012] <- "[Other]"
mydata$s1q47_other[8105] <- "[Other]"
mydata$s1q47_other[8108] <- "[Other]"
mydata$s1q47_other[8315] <- "[Other]"
mydata$s1q47_other[8316] <- "[Other]"
mydata$s1q47_other[8317] <- "[Other]"
mydata$s1q47_other[8318] <- "[Other]"
mydata$s1q47_other[8319] <- "[Other]"
mydata$s1q47_other[8320] <- "[Other]"
mydata$s1q47_other[8413] <- "[Other]"
mydata$s1q47_other[8416] <- "[Other]"
mydata$s1q47_other[8946] <- "[Other]"
mydata$s1q47_other[9236] <- "[Other]"
mydata$s1q47_other[9325] <- "[Other]"
mydata$s1q47_other[9351] <- "[Other]"
mydata$s1q47_other[9352] <- "[Other]"
mydata$s1q47_other[9353] <- "[Other]"
mydata$s1q47_other[9354] <- "[Other]"
mydata$s1q47_other[9374] <- "[Other]"
mydata$s1q47_other[9376] <- "[Other]"
mydata$s1q47_other[9444] <- "[Other]"
mydata$s1q47_other[9446] <- "[Other]"
mydata$s1q47_other[9478] <- "[Other]"
mydata$s1q47_other[9657] <- "[Other]"
mydata$s1q47_other[9774] <- "[Other]"
mydata$s1q47_other[9809] <- "[Other]"
mydata$s1q47_other[9872] <- "[Other]"
mydata$s1q47_other[9901] <- "[Other]"
mydata$s1q47_other[9902] <- "[Other]"
mydata$s1q47_other[9903] <- "[Other]"
mydata$s1q47_other[9905] <- "[Other]"
mydata$s1q47_other[9907] <- "[Other]"
mydata$s1q47_other[9982] <- "[Other]"
mydata$s1q47_other[10238] <- "[Other]"
mydata$s1q47_other[10606] <- "[Other]"
mydata$s1q47_other[10791] <- "[Other]"
mydata$s1q47_other[10792] <- "[Other]"
mydata$s1q47_other[11396] <- "[Other]"
mydata$s1q47_other[11962] <- "[Other]"
mydata$s1q47_other[12393] <- "[Other]"
mydata$s1q47_other[12845] <- "[Other]"
mydata$s1q47_other[13036] <- "[Other]"
mydata$s1q47_other[13268] <- "[Other]"
mydata$s1q47_other[13883] <- "[Other]"
mydata$s1q47_other[14682] <- "[Other]"


mydata$s1q47noresponse[13726] <- "They dont have any details about the mother of [name]"

mydata$s1q52noresponse[1715] <- "Since birth of [name]"
mydata$s1q52noresponse[5772] <- "Less than year father left [name]"
mydata$s1q52noresponse[6213] <- "[name] was born without the presence of his father."
mydata$s1q52noresponse[6354] <- "[Tagalo]"
mydata$s1q52noresponse[6692] <- "When [name] is in the womb of her mother her father leave them"
mydata$s1q52noresponse[6701] <- "Sometimes he is visiting [name]"
mydata$s1q52noresponse[6707] <- "Sometimes she visiting [name]"
mydata$s1q52noresponse[6754] <- "When [name] is still pregnant the father of [name] left them"
mydata$s1q52noresponse[6781] <- "When [name] is in the womb of [name] for only 9 months old they left them"
mydata$s1q52noresponse[6814] <- "[name] dont see her father since birth"
mydata$s1q52noresponse[6826] <- "[name] is 2 months old only"
mydata$s1q52noresponse[6972] <- "Sometimes the father of [name] visiting her"
mydata$s1q52noresponse[6987] <- "The father of [name] is working in other province"
mydata$s1q52noresponse[7461] <- "Shes now staying in the house of her boyfriend [name]"
mydata$s1q52noresponse[7660] <- "Since Birth [name] is in the care of his Grand Mother [name], his Father only visiting Him"
mydata$s1q52noresponse[7661] <- "[name] grown up with his Grand mother  [name], his father only visiting Him"
mydata$s1q52noresponse[7762] <- "At [site]"
mydata$s1q52noresponse[8408] <- "Father was in [site] when the baby was born."
mydata$s1q52noresponse[11381] <- "Respodents was still pregnant for [name]"
mydata$s1q52noresponse[12020] <- "Father left when [name] was still in his mothers womb"

mydata$s1q53noresponse[534] <- "The respondent doesn't know anything about [name]'s father."
mydata$s1q53noresponse[5061] <- "[Tagalo]"
mydata$s1q53noresponse[5070] <- "[name] does not know"
mydata$s1q53noresponse[6354] <- "[Tagalo]"
mydata$s1q53noresponse[6358] <- "[Tagalo]"
mydata$s1q53noresponse[8012] <- "[name]does not have any idea..."
mydata$s1q53noresponse[13941] <- "She dont know the other details about the father of [name]"
mydata$s1q53noresponse[13943] <- "She dont know the other details of [name]'s father"

mydata$s1q54noresponse[184] <- "Did not seen when [name] mothers died"
mydata$s1q54noresponse[233] <- "[site]"
mydata$s1q54noresponse[4036] <- "[situation]"
mydata$s1q54noresponse[6788] <- "[situation]"
mydata$s1q54noresponse[6789] <- "[site]"
mydata$s1q54noresponse[7264] <- "In [site]."
mydata$s1q54noresponse[7265] <- "In [site]."
mydata$s1q54noresponse[7268] <- "In [site]."
mydata$s1q54noresponse[7269] <- "In [site]."
mydata$s1q54noresponse[8408] <- "[situation]"

mydata$s1q55_other[150] <- "[Other]"
mydata$s1q55_other[152] <- "[Other]"
mydata$s1q55_other[153] <- "[Other]"
mydata$s1q55_other[182] <- "[Other]"
mydata$s1q55_other[413] <- "[Other]"
mydata$s1q55_other[979] <- "[Other]"
mydata$s1q55_other[1022] <- "[Other]"
mydata$s1q55_other[1356] <- "[Other]"
mydata$s1q55_other[1357] <- "[Other]"
mydata$s1q55_other[1358] <- "[Other]"
mydata$s1q55_other[1359] <- "[Other]"
mydata$s1q55_other[1608] <- "[Other]"
mydata$s1q55_other[1794] <- "[Other]"
mydata$s1q55_other[1869] <- "[Other]"
mydata$s1q55_other[1999] <- "[Other]"
mydata$s1q55_other[2003] <- "[Other]"
mydata$s1q55_other[2094] <- "[Other]"
mydata$s1q55_other[2096] <- "[Other]"
mydata$s1q55_other[2097] <- "[Other]"
mydata$s1q55_other[2099] <- "[Other]"
mydata$s1q55_other[2100] <- "[Other]"
mydata$s1q55_other[2101] <- "[Other]"
mydata$s1q55_other[2307] <- "[Other]"
mydata$s1q55_other[2341] <- "[Other]"
mydata$s1q55_other[2343] <- "[Other]"
mydata$s1q55_other[2750] <- "[Other]"
mydata$s1q55_other[3083] <- "[Other]"
mydata$s1q55_other[3116] <- "[Other]"
mydata$s1q55_other[3460] <- "[Other]"
mydata$s1q55_other[3822] <- "[Other]"
mydata$s1q55_other[3827] <- "[Other]"
mydata$s1q55_other[4096] <- "[Other]"
mydata$s1q55_other[4098] <- "[Other]"
mydata$s1q55_other[4108] <- "[Other]"
mydata$s1q55_other[4140] <- "[Other]"
mydata$s1q55_other[4141] <- "[Other]"
mydata$s1q55_other[4392] <- "[Other]"
mydata$s1q55_other[4946] <- "[Other]"
mydata$s1q55_other[4949] <- "[Other]"
mydata$s1q55_other[4950] <- "[Other]"
mydata$s1q55_other[4996] <- "[Other]"
mydata$s1q55_other[4998] <- "[Other]"
mydata$s1q55_other[5083] <- "[Other]"
mydata$s1q55_other[5253] <- "[Other]"
mydata$s1q55_other[5301] <- "[Other]"
mydata$s1q55_other[5302] <- "[Other]"
mydata$s1q55_other[5303] <- "[Other]"
mydata$s1q55_other[5305] <- "[Other]"
mydata$s1q55_other[5317] <- "[Other]"
mydata$s1q55_other[5352] <- "[Other]"
mydata$s1q55_other[5441] <- "[Other]"
mydata$s1q55_other[5595] <- "[Other]"
mydata$s1q55_other[5596] <- "[Other]"
mydata$s1q55_other[5598] <- "[Other]"
mydata$s1q55_other[5600] <- "[Other]"
mydata$s1q55_other[5802] <- "[Other]"
mydata$s1q55_other[5809] <- "[Other]"
mydata$s1q55_other[5811] <- "[Other]"
mydata$s1q55_other[5812] <- "[Other]"
mydata$s1q55_other[6031] <- "[Other]"
mydata$s1q55_other[6084] <- "[Other]"
mydata$s1q55_other[6187] <- "[Other]"
mydata$s1q55_other[6190] <- "[Other]"
mydata$s1q55_other[6191] <- "[Other]"
mydata$s1q55_other[6207] <- "[Other]"
mydata$s1q55_other[6208] <- "[Other]"
mydata$s1q55_other[6417] <- "[Other]"
mydata$s1q55_other[6486] <- "[Other]"
mydata$s1q55_other[6490] <- "[Other]"
mydata$s1q55_other[6491] <- "[Other]"
mydata$s1q55_other[6492] <- "[Other]"
mydata$s1q55_other[6727] <- "[Other]"
mydata$s1q55_other[6770] <- "[Other]"
mydata$s1q55_other[6772] <- "[Other]"
mydata$s1q55_other[6775] <- "[Other]"
mydata$s1q55_other[6781] <- "[Other]"
mydata$s1q55_other[6822] <- "[Other]"
mydata$s1q55_other[6891] <- "[Other]"
mydata$s1q55_other[6892] <- "[Other]"
mydata$s1q55_other[6987] <- "[Other]"
mydata$s1q55_other[7007] <- "[Other]"
mydata$s1q55_other[7117] <- "[Other]"
mydata$s1q55_other[7309] <- "[Other]"
mydata$s1q55_other[7310] <- "[Other]"
mydata$s1q55_other[7323] <- "[Other]"
mydata$s1q55_other[7324] <- "[Other]"
mydata$s1q55_other[7327] <- "[Other]"
mydata$s1q55_other[7405] <- "[Other]"
mydata$s1q55_other[7409] <- "[Other]"
mydata$s1q55_other[7410] <- "[Other]"
mydata$s1q55_other[7411] <- "[Other]"
mydata$s1q55_other[7452] <- "[Other]"
mydata$s1q55_other[7453] <- "[Other]"
mydata$s1q55_other[7454] <- "[Other]"
mydata$s1q55_other[7461] <- "[Other]"
mydata$s1q55_other[7475] <- "[Other]"
mydata$s1q55_other[7476] <- "[Other]"
mydata$s1q55_other[7478] <- "[Other]"
mydata$s1q55_other[7505] <- "[Other]"
mydata$s1q55_other[7586] <- "[Other]"
mydata$s1q55_other[7591] <- "[Other]"
mydata$s1q55_other[7664] <- "[Other]"
mydata$s1q55_other[7665] <- "[Other]"
mydata$s1q55_other[7667] <- "[Other]"
mydata$s1q55_other[7762] <- "[Other]"
mydata$s1q55_other[7763] <- "[Other]"
mydata$s1q55_other[7868] <- "[Other]"
mydata$s1q55_other[7869] <- "[Other]"
mydata$s1q55_other[7972] <- "[Other]"
mydata$s1q55_other[8072] <- "[Other]"
mydata$s1q55_other[8074] <- "[Other]"
mydata$s1q55_other[8075] <- "[Other]"
mydata$s1q55_other[8178] <- "[Other]"
mydata$s1q55_other[8319] <- "[Other]"
mydata$s1q55_other[8320] <- "[Other]"
mydata$s1q55_other[8890] <- "[Other]"
mydata$s1q55_other[8891] <- "[Other]"
mydata$s1q55_other[8933] <- "[Other]"
mydata$s1q55_other[8934] <- "[Other]"
mydata$s1q55_other[9026] <- "[Other]"
mydata$s1q55_other[9129] <- "[Other]"
mydata$s1q55_other[9169] <- "[Other]"
mydata$s1q55_other[9170] <- "[Other]"
mydata$s1q55_other[9238] <- "[Other]"
mydata$s1q55_other[9266] <- "[Other]"
mydata$s1q55_other[9325] <- "[Other]"
mydata$s1q55_other[9454] <- "[Other]"
mydata$s1q55_other[9464] <- "[Other]"
mydata$s1q55_other[9465] <- "[Other]"
mydata$s1q55_other[9466] <- "[Other]"
mydata$s1q55_other[9639] <- "[Other]"
mydata$s1q55_other[9641] <- "[Other]"
mydata$s1q55_other[9656] <- "[Other]"
mydata$s1q55_other[9659] <- "[Other]"
mydata$s1q55_other[9660] <- "[Other]"
mydata$s1q55_other[9661] <- "[Other]"
mydata$s1q55_other[9668] <- "[Other]"
mydata$s1q55_other[9670] <- "[Other]"
mydata$s1q55_other[9671] <- "[Other]"
mydata$s1q55_other[10141] <- "[Other]"
mydata$s1q55_other[10162] <- "[Other]"
mydata$s1q55_other[10254] <- "[Other]"
mydata$s1q55_other[10255] <- "[Other]"
mydata$s1q55_other[10257] <- "[Other]"
mydata$s1q55_other[10258] <- "[Other]"
mydata$s1q55_other[10535] <- "[Other]"
mydata$s1q55_other[10609] <- "[Other]"
mydata$s1q55_other[10672] <- "[Other]"
mydata$s1q55_other[10674] <- "[Other]"
mydata$s1q55_other[10675] <- "[Other]"
mydata$s1q55_other[10933] <- "[Other]"
mydata$s1q55_other[10934] <- "[Other]"
mydata$s1q55_other[10972] <- "[Other]"
mydata$s1q55_other[10973] <- "[Other]"
mydata$s1q55_other[10974] <- "[Other]"
mydata$s1q55_other[10975] <- "[Other]"
mydata$s1q55_other[10977] <- "[Other]"
mydata$s1q55_other[10978] <- "[Other]"
mydata$s1q55_other[10979] <- "[Other]"
mydata$s1q55_other[11099] <- "[Other]"
mydata$s1q55_other[11115] <- "[Other]"
mydata$s1q55_other[11158] <- "[Other]"
mydata$s1q55_other[11236] <- "[Other]"
mydata$s1q55_other[11384] <- "[Other]"
mydata$s1q55_other[11396] <- "[Other]"
mydata$s1q55_other[11745] <- "[Other]"
mydata$s1q55_other[11792] <- "[Other]"
mydata$s1q55_other[11914] <- "[Other]"
mydata$s1q55_other[12288] <- "[Other]"
mydata$s1q55_other[12399] <- "[Other]"
mydata$s1q55_other[12400] <- "[Other]"
mydata$s1q55_other[12401] <- "[Other]"
mydata$s1q55_other[12402] <- "[Other]"
mydata$s1q55_other[12568] <- "[Other]"
mydata$s1q55_other[12629] <- "[Other]"
mydata$s1q55_other[12630] <- "[Other]"
mydata$s1q55_other[12632] <- "[Other]"
mydata$s1q55_other[12649] <- "[Other]"
mydata$s1q55_other[12653] <- "[Other]"
mydata$s1q55_other[12845] <- "[Other]"
mydata$s1q55_other[13260] <- "[Other]"
mydata$s1q55_other[13556] <- "[Other]"
mydata$s1q55_other[13557] <- "[Other]"
mydata$s1q55_other[13559] <- "[Other]"
mydata$s1q55_other[13560] <- "[Other]"
mydata$s1q55_other[13561] <- "[Other]"
mydata$s1q55_other[13839] <- "[Other]"
mydata$s1q55_other[13883] <- "[Other]"
mydata$s1q55_other[13887] <- "[Other]"
mydata$s1q55_other[13902] <- "[Other]"
mydata$s1q55_other[13903] <- "[Other]"
mydata$s1q55_other[13904] <- "[Other]"
mydata$s1q55_other[14195] <- "[Other]"
mydata$s1q55_other[14196] <- "[Other]"
mydata$s1q55_other[14197] <- "[Other]"
mydata$s1q55_other[14263] <- "[Other]"
mydata$s1q55_other[14264] <- "[Other]"
mydata$s1q55_other[14375] <- "[Other]"
mydata$s1q55_other[14376] <- "[Other]"
mydata$s1q55_other[14377] <- "[Other]"
mydata$s1q55_other[14378] <- "[Other]"
mydata$s1q55_other[14549] <- "[Other]"
mydata$s1q55_other[14550] <- "[Other]"
mydata$s1q55_other[14552] <- "[Other]"
mydata$s1q55_other[14623] <- "[Other]"
mydata$s1q55_other[14624] <- "[Other]"
mydata$s1q55_other[14627] <- "[Other]"
mydata$s1q55_other[14679] <- "[Other]"
mydata$s1q55_other[1480] <- "Driver"
mydata$s1q55_other[2001] <- "Driver"
mydata$s1q55_other[2004] <- "Driver"
mydata$s1q55_other[2005] <- "Driver"
mydata$s1q55_other[2008] <- "Driver"
mydata$s1q55_other[2059] <- "Driver"
mydata$s1q55_other[2060] <- "Driver"
mydata$s1q55_other[2080] <- "Driver"
mydata$s1q55_other[3021] <- "Driver"
mydata$s1q55_other[3167] <- "Driver"
mydata$s1q55_other[3168] <- "Driver"
mydata$s1q55_other[3169] <- "Driver"
mydata$s1q55_other[3954] <- "Driver"
mydata$s1q55_other[3956] <- "Driver"
mydata$s1q55_other[3958] <- "Driver"
mydata$s1q55_other[4834] <- "Driver"
mydata$s1q55_other[4835] <- "Driver"
mydata$s1q55_other[4838] <- "Driver"
mydata$s1q55_other[5072] <- "Driver"
mydata$s1q55_other[5131] <- "Driver"
mydata$s1q55_other[5151] <- "Driver"
mydata$s1q55_other[5649] <- "Driver"
mydata$s1q55_other[6970] <- "Driver"
mydata$s1q55_other[6971] <- "Driver"
mydata$s1q55_other[6972] <- "Driver"
mydata$s1q55_other[8011] <- "Driver"
mydata$s1q55_other[8012] <- "Driver"
mydata$s1q55_other[8435] <- "Driver"
mydata$s1q55_other[8507] <- "Driver"
mydata$s1q55_other[8509] <- "Driver"
mydata$s1q55_other[8974] <- "Driver"
mydata$s1q55_other[8976] <- "Driver"
mydata$s1q55_other[8977] <- "Driver"
mydata$s1q55_other[8978] <- "Driver"
mydata$s1q55_other[9374] <- "Driver"
mydata$s1q55_other[9481] <- "Driver"
mydata$s1q55_other[10090] <- "Driver"
mydata$s1q55_other[11693] <- "Driver"
mydata$s1q55_other[11816] <- "Driver"
mydata$s1q55_other[11817] <- "Driver"
mydata$s1q55_other[12018] <- "Driver"
mydata$s1q55_other[12020] <- "Driver"
mydata$s1q55_other[14174] <- "Driver"
mydata$s1q55_other[14537] <- "Driver"
mydata$s1q55_other[865] <- "Construction"
mydata$s1q55_other[3552] <- "Construction"
mydata$s1q55_other[3553] <- "Construction"
mydata$s1q55_other[3825] <- "Construction"
mydata$s1q55_other[5637] <- "Construction"
mydata$s1q55_other[6723] <- "Construction"


mydata$s1q55noresponse[233] <- "[site]"
mydata$s1q55noresponse[1800] <- "Dont know. The father of this child is [nationality]."
mydata$s1q55noresponse[2211] <- "Her father was in [site] until now."
mydata$s1q55noresponse[2729] <- "In [site]"
mydata$s1q55noresponse[2730] <- "In [site]"
mydata$s1q55noresponse[2731] <- "In [site]"
mydata$s1q55noresponse[4036] <- "In [site]"
mydata$s1q55noresponse[5080] <- "In [site]"
mydata$s1q55noresponse[5432] <- "In [site]"
mydata$s1q55noresponse[5433] <- "In [site]"
mydata$s1q55noresponse[5435] <- "In [site]"
mydata$s1q55noresponse[6354] <- "[Tagalo]"
mydata$s1q55noresponse[6679] <- "[name] doesnt know."
mydata$s1q55noresponse[6714] <- "Her father is in [site]."
mydata$s1q55noresponse[6717] <- "Her father is in [site]."
mydata$s1q55noresponse[6754] <- "They have no communication with the father of [name]"
mydata$s1q55noresponse[6765] <- "[names] has the same father."
mydata$s1q55noresponse[6767] <- "[names] has the same father therefor the mother doesnt know the where abouts of their father."
mydata$s1q55noresponse[6768] <- "[name] doesnt know what kindnof work is he into."
mydata$s1q55noresponse[6769] <- "[name] does not know the where abouts of [name]'s father."
mydata$s1q55noresponse[6788] <- "[situation]"
mydata$s1q55noresponse[6789] <- "[situation]"
mydata$s1q55noresponse[7264] <- "In [site]."
mydata$s1q55noresponse[7265] <- "In [site]."
mydata$s1q55noresponse[7268] <- "In [site]."
mydata$s1q55noresponse[7269] <- "In [site]."
mydata$s1q55noresponse[7432] <- "[Tagalo]"
mydata$s1q55noresponse[7742] <- "He is in [site]"
mydata$s1q55noresponse[8408] <- "Not working, [situation]"
mydata$s1q55noresponse[8752] <- "He has [illness] and staying in [site]."
mydata$s1q55noresponse[8753] <- "He has [illness] and staying in [site]."
mydata$s1q55noresponse[8756] <- "He has [illness] and staying in [site]."
mydata$s1q55noresponse[11727] <- "Parents of [name] are separated"
mydata$s1q55noresponse[13249] <- "Father is in [site]"
mydata$s1q55noresponse[13250] <- "Father is in [site]"
mydata$s1q55noresponse[13251] <- "Father is in [site]"
mydata$s1q55noresponse[13252] <- "None.father is in [site]"
mydata$s1q55noresponse[13253] <- "Father is in [site]"

mydata$s1q32noresponse[760] <- "Cant remember how many times he was hired but he knows that they are being paid [amount] a day."
mydata$s1q32noresponse[1735] <- "Gives [amount] every time he comes home but respondent doesn't know how much his salary is."
mydata$s1q32noresponse[1935] <- "[name]'s salary for barter is their whole income for the whole year. Both of them is doing it at the samw time."
mydata$s1q32noresponse[2748] <- "Cant estimate how many times theyve worked but they are being paid [amount] pesos a day as hired farmer. No payment for taiing care of the animals."
mydata$s1q32noresponse[2751] <- "Cant remember how many times she was hired, but she is being paid [amount] pesos a day."
mydata$s1q32noresponse[3313] <- "She said [amount] per day but she cannot say how many times"
mydata$s1q32noresponse[4476] <- "Casual work, around [amount] daily wage"
mydata$s1q32noresponse[5839] <- "She cannot estimate, sometimes [amount] pesos, sometimes [amount] pesos not regular"
mydata$s1q32noresponse[5937] <- "It differs everyday. Sometimes they earn [amount] pesos each day, sometimes none."
mydata$s1q32noresponse[6737] <- "[name] doesnt know the exact figure of salary of [name]."
mydata$s1q32noresponse[6746] <- "His father does not knows about it. [name] is doing cosmetology works."
mydata$s1q32noresponse[6765] <- "[name] cannot estimate the money given to her son [name] because.."
mydata$s1q32noresponse[6809] <- "[name] is not sure how much her husband is earning."
mydata$s1q32noresponse[7455] <- "Evreday allowance of Php [amount]"
mydata$s1q32noresponse[7463] <- "[amount] for only 1 month contract"
mydata$s1q32noresponse[7539] <- "He has won [amount] pesos from the soccer game in his school"
mydata$s1q32noresponse[7607] <- "He is only a part time in [work] only [time] and recieve a pay of [amount]"
mydata$s1q32noresponse[7791] <- "He is an agent of Small town he is [amount] a week"
mydata$s1q32noresponse[8139] <- "Don't know, [name] doesn't say"
mydata$s1q32noresponse[8251] <- "[amount]"

#'# GPS data: Displace
# !!!No GPS data

#'# Save processed data in Stata and SPSS format


haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
